/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.NoSessionException;
import ca.infodata.ofys.data.dataaccess.service.eform.EFormAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EFormCache
extends ObjectCache<XBaseEform> {
    private static final Logger logger = Logger.getLogger(EFormCache.class.getName());
    private static final String TAG = "form";
    private boolean formsLoaded = false;
    private final Object lstSortedLock = new Object();
    private ArrayList<XBaseEform> lstSorted = null;
    private static final Comparator<XBaseEform> eformSortByName = new Comparator<XBaseEform>(){

        @Override
        public int compare(XBaseEform o1, XBaseEform o2) {
            return StringUtils.compareAscii((String)o1.getName(), (String)o2.getName());
        }
    };

    protected EFormCache() {
        super(TAG);
    }

    public boolean isFormsLoaded() {
        return this.formsLoaded;
    }

    public void setFormsLoaded(boolean formsLoaded) {
        this.formsLoaded = formsLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XBaseEform> getAll() {
        Object object = this.lstSortedLock;
        synchronized (object) {
            if (this.lstSorted == null) {
                ArrayList list = new ArrayList();
                list.addAll(this.getMap().values());
                MiscUtil.trySort(list, eformSortByName);
                this.lstSorted = list;
            }
            return this.lstSorted;
        }
    }

    public void removeById(Integer id) {
        this.remove(new ObjectCache.Key(TAG, id));
        this.lstSorted = null;
    }

    public void put(Integer id, XBaseEform eform) {
        ObjectCache.Key key = new ObjectCache.Key(TAG, id);
        this.getMap().put(key, eform);
        this.lstSorted = null;
    }

    public XBaseEform getById(Integer id) {
        return this.getById(id, false);
    }

    private XBaseEform getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, false);
    }

    private XBaseEform getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XBaseEform)this.get(new ObjectCache.Key(TAG, id), logIfNotFound, mustTryToFindServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        block6: {
            logger.info("EformCache.loadEforms()");
            try {
                if (session == null || session.getUser() == null || session.getUser().getId() == null) break block6;
                EFormAccessorClient.getInstance().list(callback, true);
                Object object = this.lstSortedLock;
                synchronized (object) {
                    this.lstSorted = null;
                }
                this.formsLoaded = true;
            }
            catch (NoSessionException noSessionException) {
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error loading eform list", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        block6: {
            logger.info("EformCache.loadSync()");
            try {
                if (session == null || session.getUser() == null || session.getUser().getId() == null) break block6;
                ArrayList list = (ArrayList)EFormAccessorClient.getInstance().list(true);
                Object object = this.lstSortedLock;
                synchronized (object) {
                    this.lstSorted = null;
                }
                this.formsLoaded = true;
                callback.response(new ReturnObject((Serializable)list));
            }
            catch (NoSessionException noSessionException) {
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error loading eform list", e);
            }
        }
    }

    protected void add(Map<ObjectCache.Key, XBaseEform> map, XBaseEform e) {
        if (e != null) {
            map.put(new ObjectCache.Key(TAG, e.getId()), e);
        }
    }

    protected XBaseEform loadSync(XSession session, ObjectCache.Key key) throws Exception {
        return null;
    }
}

