/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq.controller;

import ca.infodata.dsq.domain.NIU_OTHER_MEDICATION_DM;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION_DM;
import ca.infodata.dsq.domain.OtherMedicationDetail;
import ca.infodata.dsq.domain.OtherMedicationSummary;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.domain.PrescriptionDrugSummary;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.MySubProgressMonitor;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateAction;
import ca.infodata.ofys.ui.dsq.controller.DMMedicationControllerCallback;
import ca.infodata.ofys.ui.dsq.controller.DMPrescriptionController;
import ca.infodata.ofys.ui.dsq.controller.QueryContinuationController;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DMMedicationController
extends QueryContinuationController {
    private static final LocalDate MINIMALDATE = LocalDate.from((int)1, (int)1, (int)2007);
    private static final String OBTENTION_DU_SOMMAIRE_DE_LA_MEDICATION = Messages.getString((String)"DMPrescriptionController.OBTENTION_DU_SOMMAIRE_DE_LA_MEDICATION", (String[])new String[0]);
    private static final String OBTENTION_DU_DETAIL_DUN_MEDICAMENT_SANS_ORDONNANCE = Messages.getString((String)"DMPrescriptionController.OBTENTION_DU_DETAIL_DUN_MEDICAMENT_SANS_ORDONNANCE", (String[])new String[0]);
    private static final String OBTENTION_DU_DETAIL_DUNE_ORDONNANCE = Messages.getString((String)"DMPrescriptionController.OBTENTION_DU_DETAIL_DUNE_ORDONNANCE", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(DMPrescriptionController.class.getName());
    private final DMMedicationControllerCallback callback;
    private IPatient patient;
    private LocalDate administrationEffectiveStart = LocalDate.today().plusYear(-1);
    private LocalDate administrationEffectiveEnd = LocalDate.today();
    private LocalDate amendedInTimeStart;
    private LocalDate amendedInTimeEnd;
    private boolean onlyThoseWithIssue;
    private int limit = 50;
    private List<PrescriptionDrugSummary> prescriptions;
    private List<OtherMedicationSummary> medications;
    private QueryContinuationResult summaryQCR;
    private Map<NIU_PRESCRIPTION_DM, PrescriptionDrugDetails> prescriptionMapDetail;
    private Map<NIU_OTHER_MEDICATION_DM, OtherMedicationDetail> medicationMapDetail;
    private Job listSummaryJob;
    private JobExtension getDetailJob;
    private FindCandidateAction findCandidateAction;

    public DMMedicationController(DMMedicationControllerCallback callback, BaseDSQAction dsq, FindCandidateAction findCandidateAction) {
        super(dsq);
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        this.callback = callback;
        this.findCandidateAction = findCandidateAction;
        this.prescriptionMapDetail = new ConcurrentHashMap<NIU_PRESCRIPTION_DM, PrescriptionDrugDetails>();
        this.medicationMapDetail = new ConcurrentHashMap<NIU_OTHER_MEDICATION_DM, OtherMedicationDetail>();
    }

    public void listSummary() {
        if (this.listSummaryJob == null) {
            this.listSummaryJob = new Job("Sommaire de la m\u00e9dication active"){

                protected IStatus run(IProgressMonitor monitor) {
                    DMMedicationController.this.listSummary2(monitor);
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.listSummaryJob.getState() == 4) {
            this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listSummaryJob.schedule();
        }
    }

    protected void listSummary2(IProgressMonitor monitor) {
        if (this.summaryQCR == null) {
            DsqCallback<QueryContinuationResult> r = this.listSummary3(monitor);
            this.summaryQCR = (QueryContinuationResult)r.result;
            if (r.result != null) {
                this.prescriptions = new ArrayList<PrescriptionDrugSummary>(((QueryContinuationResult)r.result).drugs);
                this.medications = new ArrayList<OtherMedicationSummary>(((QueryContinuationResult)r.result).otherMedications);
            }
            this.callback.listSummary(r);
        } else if (this.summaryQCR != null && this.summaryQCR.originalTotalQuantity > this.prescriptions.size() + this.medications.size()) {
            DsqCallback<QueryContinuationResult> r = this.continueQuery(this.patient, this.summaryQCR, this.limit, monitor);
            if (r.result != null) {
                this.summaryQCR = (QueryContinuationResult)r.result;
                int maxSequenceValue = this.computeMaxSequenceValue();
                for (PrescriptionDrugSummary e : ((QueryContinuationResult)r.result).drugs) {
                    e.sequence += maxSequenceValue;
                }
                for (PrescriptionDrugSummary e : ((QueryContinuationResult)r.result).otherMedications) {
                    e.sequence += maxSequenceValue;
                }
                this.prescriptions.addAll(((QueryContinuationResult)r.result).drugs);
                this.medications.addAll(((QueryContinuationResult)r.result).otherMedications);
                QueryContinuationResult r2 = new QueryContinuationResult();
                r2.originalTotalQuantity = this.summaryQCR.originalTotalQuantity;
                r2.drugs = this.prescriptions;
                r2.otherMedications = this.medications;
                r2.queryId = ((QueryContinuationResult)r.result).queryId;
                r2.resultTotalQuantity = r2.originalTotalQuantity;
                r2.resultCurrentQuantity = r2.drugs.size() + r2.otherMedications.size();
                r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
                this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
            } else {
                this.callback.listSummary(r);
            }
        } else {
            QueryContinuationResult r2 = new QueryContinuationResult();
            r2.originalTotalQuantity = this.summaryQCR.originalTotalQuantity;
            r2.drugs = this.prescriptions;
            r2.otherMedications = this.medications;
            r2.queryId = this.summaryQCR.queryId;
            r2.resultTotalQuantity = r2.originalTotalQuantity;
            r2.resultCurrentQuantity = r2.drugs.size() + r2.otherMedications.size();
            r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
            this.callback.listSummary((DsqCallback<QueryContinuationResult>)new DsqCallback((Object)r2));
        }
    }

    private int computeMaxSequenceValue() {
        int v = 0;
        if (this.prescriptions != null) {
            for (PrescriptionDrugSummary prescriptionDrugSummary : this.prescriptions) {
                v = Math.max(v, prescriptionDrugSummary.sequence);
            }
        }
        if (this.medications != null) {
            for (OtherMedicationSummary otherMedicationSummary : this.medications) {
                v = Math.max(v, otherMedicationSummary.sequence);
            }
        }
        return v;
    }

    private DsqCallback<QueryContinuationResult> listSummary3(IProgressMonitor monitor) {
        DsqCallback callback = new DsqCallback();
        try {
            if (this.administrationEffectiveStart == null && this.administrationEffectiveEnd != null || this.administrationEffectiveStart != null && this.administrationEffectiveEnd == null) {
                callback.message = "Les deux dates de p\u00e9riode doivent \u00eatre pr\u00e9sente pour \u00eatre prisent en compte";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.amendedInTimeStart == null && this.amendedInTimeEnd != null || this.amendedInTimeStart != null && this.amendedInTimeEnd == null) {
                callback.message = "Les deux dates de Modif\u00e9 doivent \u00eatre pr\u00e9sente pour \u00eatre prisent en compte";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.administrationEffectiveStart != null && this.administrationEffectiveEnd != null && this.administrationEffectiveEnd.before((IPartialDate)this.administrationEffectiveStart)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.amendedInTimeStart != null && this.amendedInTimeEnd != null && this.amendedInTimeEnd.before((IPartialDate)this.amendedInTimeStart)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.administrationEffectiveStart != null && LocalDate.today().before((IPartialDate)this.administrationEffectiveStart) || this.amendedInTimeStart != null && LocalDate.today().before((IPartialDate)this.amendedInTimeStart)) {
                callback.message = "Une date de d\u00e9but est dans le futur";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            if (this.administrationEffectiveStart != null && this.administrationEffectiveStart.before((IPartialDate)MINIMALDATE) || this.amendedInTimeStart != null && this.amendedInTimeStart.before((IPartialDate)MINIMALDATE)) {
                callback.message = "La date de d\u00e9but ne peut \u00eatre avant " + MINIMALDATE.formatSlash();
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback dsqCallback = callback;
                return dsqCallback;
            }
            try {
                if (monitor != null) {
                    monitor.beginTask(OBTENTION_DU_SOMMAIRE_DE_LA_MEDICATION, 2);
                }
                XmlSignatureI signature = null;
                XmlSignatureI signatureNiu = null;
                if (!this.dsq.hasSignatures(this.patient.getId())) {
                    if (!UI.OS_WINDOWS) {
                        throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                    }
                    this.dsq.checkIfActionWasCanceled(monitor);
                    Alias alias = this.dsq.getAlias(monitor);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    String niu = this.findCandidateAction.getNiu(this.patient, (IProgressMonitorWithLog)(monitor == null ? null : new MySubProgressMonitor(monitor, 1)));
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signature = this.dsq.getSignatureI(monitor, alias, null);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, null, niu);
                    this.dsq.checkIfActionWasCanceled(monitor);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
                this.dsq.checkIfActionWasCanceled(monitor);
                if (monitor != null) {
                    monitor.subTask("Recherche");
                }
                XSession session = Application.get().getGlobalInstances().getSession();
                int idPatient = this.patient.getId();
                ReturnObject r = DSQAccessorClient.getInstance().getMedicationSummaryServiceDM(session, this.administrationEffectiveStart, this.administrationEffectiveEnd, this.amendedInTimeStart, this.amendedInTimeEnd, this.onlyThoseWithIssue, idPatient, this.limit, (Signature)signature, (Signature)signatureNiu);
                if (r == null) {
                    throw new AbortException("Erreur lors de l'" + OBTENTION_DU_SOMMAIRE_DE_LA_MEDICATION.toLowerCase());
                }
                this.dsq.manageDsqStatus(r.getStatus());
                callback.result = (QueryContinuationResult)r.getObj();
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                callback.message = MessageUtil.CANNOT_CONNECT_TO_SERVER_MESSAGE;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (AbortException | StatusException e) {
                callback.message = e.getMessage();
            }
            catch (CancelException cancelException) {
            }
            catch (Exception e) {
                callback.exception = e;
                callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? MessageUtil.UNEXPECTED_ERROR_MESSAGE : e.getMessage();
                logger.log(Level.SEVERE, "Failed to get dm summary list. patient=" + StringUtils.safeToString((Logger)logger, (Object)this.patient), e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void getMedicationDetail(NIU_OTHER_MEDICATION_DM id) {
        if (this.getDetailJob == null) {
            this.getDetailJob = new JobExtension(OBTENTION_DU_DETAIL_DUN_MEDICAMENT_SANS_ORDONNANCE);
        }
        if (this.getDetailJob.getState() == 4) {
            this.callback.getMedicationDetail(id, (DsqCallback<OtherMedicationDetail>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDetailJob.setIdMedication(id);
            this.getDetailJob.schedule();
        }
    }

    public void getPrescriptionDetail(NIU_PRESCRIPTION_DM id, String context) {
        if (this.getDetailJob == null) {
            this.getDetailJob = new JobExtension(OBTENTION_DU_DETAIL_DUNE_ORDONNANCE);
        }
        if (this.getDetailJob.getState() == 4) {
            this.callback.getPrescriptionDetail(id, context, (DsqCallback<PrescriptionDrugDetails>)new DsqCallback(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDetailJob.setIdPrescription(id, context);
            this.getDetailJob.schedule();
        }
    }

    protected void getPrescriptionDetail2(NIU_PRESCRIPTION_DM id, String context, IProgressMonitor monitor) {
        PrescriptionDrugDetails d = this.prescriptionMapDetail.get(id);
        if (d == null) {
            DsqCallback<PrescriptionDrugDetails> c = this.getPrescriptionDetail3(id, monitor);
            if (c.result != null) {
                this.prescriptionMapDetail.put(id, (PrescriptionDrugDetails)c.result);
            }
            this.callback.getPrescriptionDetail(id, context, c);
        } else {
            this.callback.getPrescriptionDetail(id, context, (DsqCallback<PrescriptionDrugDetails>)new DsqCallback((Object)d));
        }
    }

    protected void getMedicationDetail2(NIU_OTHER_MEDICATION_DM id, IProgressMonitor monitor) {
        OtherMedicationDetail d = this.medicationMapDetail.get(id);
        if (d == null) {
            DsqCallback<OtherMedicationDetail> c = this.getMedicationDetail3(id, monitor);
            if (c.result != null) {
                this.medicationMapDetail.put(id, (OtherMedicationDetail)c.result);
            }
            this.callback.getMedicationDetail(id, c);
        } else {
            this.callback.getMedicationDetail(id, (DsqCallback<OtherMedicationDetail>)new DsqCallback((Object)d));
        }
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<PrescriptionDrugDetails> getPrescriptionDetail3(NIU_PRESCRIPTION_DM id, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private DsqCallback<OtherMedicationDetail> getMedicationDetail3(NIU_OTHER_MEDICATION_DM id, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
        this.clearLists();
        this.clearDetails();
    }

    private void clearDetails() {
        this.medicationMapDetail.clear();
        this.prescriptionMapDetail.clear();
    }

    public boolean isOnlyThoseWithIssue() {
        return this.onlyThoseWithIssue;
    }

    public void setOnlyThoseWithIssue(boolean onlyThoseWithIssue) {
        this.onlyThoseWithIssue = onlyThoseWithIssue;
        this.clearLists();
    }

    public LocalDate getAdministrationEffectiveStart() {
        return this.administrationEffectiveStart;
    }

    public void setAdministrationEffectiveStart(LocalDate administrationEffectiveStart) {
        this.administrationEffectiveStart = administrationEffectiveStart;
        this.clearLists();
    }

    private void clearLists() {
        this.prescriptions = null;
        this.medications = null;
        this.summaryQCR = null;
    }

    public LocalDate getAdministrationEffectiveEnd() {
        return this.administrationEffectiveEnd;
    }

    public void setAdministrationEffectiveEnd(LocalDate administrationEffectiveEnd) {
        this.administrationEffectiveEnd = administrationEffectiveEnd;
        this.clearLists();
    }

    public LocalDate getAmendedInTimeStart() {
        return this.amendedInTimeStart;
    }

    public void setAmendedInTimeStart(LocalDate amendedInTimeStart) {
        this.amendedInTimeStart = amendedInTimeStart;
        this.clearLists();
    }

    public LocalDate getAmendedInTimeEnd() {
        return this.amendedInTimeEnd;
    }

    public void setAmendedInTimeEnd(LocalDate amendedInTimeEnd) {
        this.amendedInTimeEnd = amendedInTimeEnd;
        this.clearLists();
    }

    final class JobExtension
    extends Job {
        private NIU_OTHER_MEDICATION_DM idMedication;
        private NIU_PRESCRIPTION_DM idPrescription;
        private String context;

        private JobExtension(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.idMedication != null) {
                DMMedicationController.this.getMedicationDetail2(this.idMedication, monitor);
            } else if (this.idPrescription != null) {
                DMMedicationController.this.getPrescriptionDetail2(this.idPrescription, this.context, monitor);
            }
            return Status.OK_STATUS;
        }

        public void setIdMedication(NIU_OTHER_MEDICATION_DM idMedication) {
            this.idMedication = idMedication;
            this.idPrescription = null;
            this.context = null;
        }

        public void setIdPrescription(NIU_PRESCRIPTION_DM idPrescription, String context) {
            this.idMedication = null;
            this.idPrescription = idPrescription;
            this.context = context;
        }
    }
}

