/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.ILocation;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.dsq.DsqFormatter;
import ca.infodata.ofys.ui.dsq.Messages;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ChooseLocationDialog {
    private static final String TITRE = Messages.getString("ChooseLocationDialog.TITRE");
    private Shell dialog;
    private boolean ok;
    private FormToolkit toolkit;
    private TableViewer viewer;
    private List<ILocation> locations;
    private ILocation selection;

    public ChooseLocationDialog(Shell parent, List<ILocation> list) {
        this.locations = list;
        this.createDialog(parent);
    }

    private void createDialog(Shell parent) {
        this.dialog = new Shell(parent, 2160);
        this.dialog.setText(TITRE);
        Color white = ResourceGetter.getColorForWidget((int)255, (int)255, (int)255, (Widget)this.dialog);
        this.dialog.setBackground(white);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.spacing = 5;
        this.dialog.setLayout((Layout)layout);
        this.toolkit = new FormToolkit(this.dialog.getDisplay());
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ChooseLocationDialog.this.toolkit.dispose();
            }
        });
        this.createChilds(this.dialog);
    }

    private void createChilds(Shell parent) {
        this.viewer = new TableViewer((Composite)parent, 68356);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.viewer.setInput(this.locations);
        this.viewer.getTable().setHeaderVisible(false);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        UI.autoAdjustColumnWidthToContent((Table)this.viewer.getTable());
        MyButton btnClose = new MyButton((Composite)parent, "S\u00e9lectionner", 8, this.toolkit);
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)ChooseLocationDialog.this.viewer.getSelection();
                if (sel != null && sel.getFirstElement() != null) {
                    ChooseLocationDialog.this.setSelection((ILocation)sel.getFirstElement());
                }
            }
        });
        btnClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ChooseLocationDialog.this.ok();
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        data.bottom = new FormAttachment(100, -MyButton.getStandardButtonHeight() - 5);
        this.viewer.getTable().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.viewer.getTable(), 5);
        data.right = new FormAttachment(100, -10);
        data.width = 100;
        btnClose.setLayoutData((Object)data);
    }

    private void ok() {
        this.ok = true;
        this.dialog.close();
    }

    public void open() {
        this.dialog.setSize(600, 400);
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.dialog.open();
        UI.waitForWindowToClose((Shell)this.dialog);
    }

    public final boolean isOk() {
        return this.ok;
    }

    public ILocation getSelection() {
        return this.selection;
    }

    public void setSelection(ILocation selection) {
        this.selection = selection;
    }

    public class MyLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ILocation location = (ILocation)element;
            return DsqFormatter.formatLocation(location);
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object o, String s) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }
}

