/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.client.dataaccess;

import ca.infodata.dsq.domain.ApprovedRequest;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.Id;
import ca.infodata.dsq.domain.NIU_OTHER_MEDICATION_DM;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION_DM;
import ca.infodata.dsq.domain.NIU_SH;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationCriteria;
import ca.infodata.dsq.service.odslds.ServiceDeliveryLocationCriteria;
import ca.infodata.dsq.service.oe.OEC1701Svc.RetractRequestCriteria;
import ca.infodata.dsq.service.ri.FindProviderCriteria;
import ca.infodata.dsq.service.ru.FindCandidateCriteria;
import ca.infodata.dsq.signature.Pkcs7SignatureI;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DSQAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(DSQAccessorClient.class.getName());
    private static DSQAccessorClient instance;
    private final IDSQAccessor accessor;

    public static DSQAccessorClient getInstance() throws CannotConnectToServerException {
        return DSQAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static DSQAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new DSQAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(((Object)((Object)instance)).getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private DSQAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getDSQAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(((Object)((Object)this)).getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public ReturnObject listPatientConsentRefusal(XSession session, int idPatient, Signature signature) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.listPatientConsentRefusal", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.listPatientConsentRefusal(signature, idPatient);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.listPatientConsentRefusal", null);
            }
        }
        return null;
    }

    public ReturnObject hasPatientConsented(XSession session, int idPatient, Signature signature) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.hasPatientConsented", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.hasPatientConsented(signature, idPatient);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.hasPatientConsented", null);
            }
        }
        return null;
    }

    public ReturnObject findCandidateById(XSession session, int idPatient, boolean useCache, Signature signature) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.findCandidateById", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.findCandidateById(signature, idPatient, useCache);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.findCandidateById", null);
            }
        }
        return null;
    }

    public ReturnObject findProvider(XSession session, Integer idPerson, FindProviderCriteria criteria, Signature signature) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.findCandidateById", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.findProvider(signature, idPerson, criteria);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.findCandidateById", null);
            }
        }
        return null;
    }

    public ReturnObject findLocation(XSession session, Integer healthCareFacilityId, ServiceDeliveryLocationCriteria criteria, Signature signature) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.findCandidateById", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.findLocation(signature, healthCareFacilityId, criteria);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.findCandidateById", null);
            }
        }
        return null;
    }

    public ReturnObject findCandidateByCriteria(XSession session, FindCandidateCriteria criteria, Signature signature) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.findCandidateByCriteria", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.findCandidateByCriteria(signature, criteria);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.findCandidateByCriteria", null);
            }
        }
        return null;
    }

    public ReturnObject getDrugDispensesSummary(XSession session, LocalDate startDate, LocalDate endDate, boolean mostRecent, int idPatient, Integer limit, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getDrugDispensesSummary", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.getDrugDispensesSummary(signature, signatureNiu, startDate, endDate, mostRecent, idPatient, limit);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDrugDispensesSummary", null);
            }
        }
        return null;
    }

    public void getDrugDispenseDetails(ICallback callback, XSession session, int idPatient, String dispenseNumber, Signature signature, Signature signatureNiu) throws InterruptedException {
        if (this.isOkToCallFunction("DSQAccessorClient.getDrugDispensesDetails", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.getDrugDispenseDetails(signature, signatureNiu, dispenseNumber, idPatient));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.getDrugDispensesDetails", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDrugDispensesDetails", callback);
            }
        }
    }

    public ReturnObject getDrugDispenseDetails(XSession session, int idPatient, String dispenseNumber, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getDrugDispenseDetails", null)) {
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getDrugDispenseDetails(signature, signatureNiu, dispenseNumber, idPatient);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDrugDispenseDetails", null);
            }
        }
        return null;
    }

    public void getDrugPrescriptionDetailsOE(ICallback callback, XSession session, int idPatient, String prescriptionNumber, String prescriptionVersion, Signature signature, Signature signatureNiu) throws InterruptedException {
        if (this.isOkToCallFunction("DSQAccessorClient.getDrugPrescriptionDetailsOE", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.getDrugPrescriptionDetailsOE(signature, signatureNiu, idPatient, prescriptionNumber, prescriptionVersion));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.getDrugPrescriptionDetailsOE", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDrugPrescriptionDetailsOE", callback);
            }
        }
    }

    public ReturnObject getDrugPrescriptionDetailsOE(XSession session, int idPatient, String prescriptionNumber, String prescriptionVersion, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getDrugPrescriptionDetailsOE", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getDrugPrescriptionDetailsOE(signature, signatureNiu, idPatient, prescriptionNumber, prescriptionVersion);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDrugPrescriptionDetailsOE", null);
            }
        }
        return null;
    }

    public ReturnObject getDrugPrescriptionDetailsDM(XSession session, int idPatient, String prescriptionNumber, String prescriptionVersion, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getDrugPrescriptionDetailsOE", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getDrugPrescriptionDetailsDM(signature, signatureNiu, idPatient, prescriptionNumber, prescriptionVersion);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDrugPrescriptionDetailsOE", null);
            }
        }
        return null;
    }

    public ReturnObject getDevicePrescriptionDetailsOE(XSession session, int idPatient, String prescriptionNumber, String prescriptionVersion, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getDevicePrescriptionDetailsOE", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getDevicePrescriptionDetailsOE(signature, signatureNiu, idPatient, prescriptionNumber, prescriptionVersion);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDevicePrescriptionDetailsOE", null);
            }
        }
        return null;
    }

    public void getDevicePrescriptionDetailsOE(ICallback callback, XSession session, int idPatient, String prescriptionNumber, String prescriptionVersion, Signature signature, Signature signatureNiu) throws InterruptedException {
        if (this.isOkToCallFunction("DSQAccessorClient.getDevicePrescriptionDetailsOE", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.getDevicePrescriptionDetailsOE(signature, signatureNiu, idPatient, prescriptionNumber, prescriptionVersion));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.getDevicePrescriptionDetailsOE", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDevicePrescriptionDetailsOE", callback);
            }
        }
    }

    public void getPrescriptionOrderSummaryServiceOE(ICallback callback, XSession session, int idPatient, LocalDate startdate, LocalDate enddate, boolean onlyActive, Signature signature, Signature signatureNiu) throws InterruptedException {
        if (this.isOkToCallFunction("DSQAccessorClient.getPrescriptionOrderSummaryServiceOE", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.getPrescriptionOrderSummaryServiceOE(signature, signatureNiu, idPatient, startdate, enddate, onlyActive));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.getPrescriptionOrderSummaryServiceOE", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getPrescriptionOrderSummaryServiceOE", callback);
            }
        }
    }

    public ReturnObject getPrescriptionOrderSummaryServiceOE(XSession session, int idPatient, LocalDate startdate, LocalDate enddate, boolean onlyActive, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getPrescriptionOrderSummaryServiceOE", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getPrescriptionOrderSummaryServiceOE(signature, signatureNiu, idPatient, startdate, enddate, onlyActive);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getPrescriptionOrderSummaryServiceOE", null);
            }
        }
        return null;
    }

    public ReturnObject dsqSignatureAndDataByPatient(XSession session, LocalDate startdate, LocalDate enddate, Integer limit, Integer whatToDo, String clientUid, String channelName, HashMap<Integer, XmlSignatureI> xmlSignatureIForCache, HashMap<Pair<Integer, String>, Pair<Pkcs7SignatureI, XmlSignatureI>> mapPatSign) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.dsqSignatureAndDataByPatient", null)) {
            this.latency();
            try {
                ReturnObject ret;
                LocalDate start = startdate == null ? LocalDate.today().plusMonth(-24) : startdate;
                LocalDate end = enddate == null ? LocalDate.today() : enddate;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.dsqSignatureAndDataByPatient(xmlSignatureIForCache, mapPatSign, start, end, limit, whatToDo, clientUid, channelName);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.dsqSignatureAndDataByPatient", null);
            }
        }
        return null;
    }

    public ReturnObject getCacheSqimDataByPatient(XSession session, Integer idPatient) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getCacheSqimDataByPatient", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getCacheSqimDataByPatient(idPatient);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getCacheSqimDataByPatient", null);
            }
        }
        return null;
    }

    public ReturnObject hasSignatures(XSession session, Integer idPatient) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.hasSignatures", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.hasSignatures(idPatient);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.hasSignatures", null);
            }
        }
        return null;
    }

    public ReturnObject getPrescriptionOrderSummaryServiceDM(XSession session, int idPatient, LocalDate startdate, LocalDate enddate, boolean onlyThoseWithIssue, boolean includeCompletlyDispensed, boolean includePartiallyDispensed, boolean includeNeverDispensed, Integer limit, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getPrescriptionOrderSummaryServiceDM", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getPrescriptionOrderSummaryServiceDM(signature, signatureNiu, idPatient, startdate, enddate, onlyThoseWithIssue, includeCompletlyDispensed, includePartiallyDispensed, includeNeverDispensed, limit);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getPrescriptionOrderSummaryServiceDM", null);
            }
        }
        return null;
    }

    public void retractPrescriptions1(ICallback callback, XSession session, int idPatient, Signature signature, Map<String, String> lst) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.retractPrescription1", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.retractPrescriptions1(signature, idPatient, lst));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.retractPrescription1", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.retractPrescription1", callback);
            }
        }
    }

    public void retractPrescriptions2(ICallback callback, XSession session, int idPatient, Signature signature, HashMap<String, ApprovedRequest<RetractRequestCriteria>> mapApprovedRequests) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.retractPrescription2", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.retractPrescriptions2(signature, idPatient, mapApprovedRequests));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.retractPrescription2", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.retractPrescription2", callback);
            }
        }
    }

    public void retractPrescription1(ICallback callback, XSession session, int idPatient, Signature signature, String prescriptionNiuValue, String prescriptionNiuVersion) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.retractPrescription1", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.retractPrescription1(signature, idPatient, prescriptionNiuValue, prescriptionNiuVersion));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.retractPrescription1", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.retractPrescription1", callback);
            }
        }
    }

    public void retractPrescription2(ICallback callback, XSession session, int idPatient, Signature signature, String prescriptionNiuValue, String prescriptionNiuVersion, ApprovedRequest<RetractRequestCriteria> approvedRequest) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.retractPrescription2", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.retractPrescription2(signature, idPatient, prescriptionNiuValue, prescriptionNiuVersion, approvedRequest));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.retractPrescription2", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.retractPrescription2", callback);
            }
        }
    }

    public ReturnObject retractPrescriptions1(XSession session, int idPatient, Signature signature, Map<String, String> mapIds) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.retractPrescriptions1", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.retractPrescriptions1(signature, idPatient, mapIds);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.retractPrescriptions1", null);
            }
        }
        return null;
    }

    public ReturnObject retractPrescription2(XSession session, int idPatient, Signature signature, String prescriptionNiuValue, String prescriptionNiuVersion, ApprovedRequest<RetractRequestCriteria> approvedRequest) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.retractPrescription2", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.retractPrescription2(signature, idPatient, prescriptionNiuValue, prescriptionNiuVersion, approvedRequest);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.retractPrescription2", null);
            }
        }
        return null;
    }

    public ReturnObject continueQuery(XSession session, int idPatient, QueryContinuationCriteria criteria, Signature signature) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.continueQuery", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.continueQuery(signature, idPatient, criteria);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.continueQuery", null);
            }
        }
        return null;
    }

    public void exportLocalPrescriptionsToDsq1(ICallback callback, XSession session, int idPatient, Signature signature, ArrayList<Integer> localPrescriptionIds) throws InterruptedException {
        if (this.isOkToCallFunction("DSQAccessorClient.exportLocalPrescriptionsToDsq1", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.exportLocalPrescriptionsToDsq1(signature, idPatient, localPrescriptionIds));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.exportLocalPrescriptionsToDsq1", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.exportLocalPrescriptionsToDsq1", callback);
            }
        }
    }

    public void exportLocalPrescriptionsToDsq2(ICallback callback, XSession session, int idPatient, Signature signature, HashMap<Integer, Signature> mapApprovedRequests) throws InterruptedException {
        if (this.isOkToCallFunction("DSQAccessorClient.exportLocalPrescriptionsToDsq2", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.exportLocalPrescriptionsToDsq2(signature, idPatient, mapApprovedRequests));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.exportLocalPrescriptionsToDsq2", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.exportLocalPrescriptionsToDsq2", callback);
            }
        }
    }

    public void exportLocalPrescriptionToDsq1(ICallback callback, XSession session, int idPatient, Signature signature, int localPrescriptionId, boolean confirmedDUPTHPY) throws InterruptedException {
        if (this.isOkToCallFunction("DSQAccessorClient.exportLocalPrescriptionToDsq1", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.exportLocalPrescriptionToDsq1(signature, idPatient, localPrescriptionId, confirmedDUPTHPY));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.exportLocalPrescriptionToDsq1", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.exportLocalPrescriptionToDsq1", callback);
            }
        }
    }

    public void exportLocalPrescriptionToDsq2(ICallback callback, XSession session, int idPatient, Signature signature, int localPrescriptionId, boolean async, ApprovedRequest<?> approvedRequest) throws InterruptedException {
        if (this.isOkToCallFunction("DSQAccessorClient.exportLocalPrescriptionToDsq1", callback)) {
            this.latency();
            try {
                try {
                    callback.response(DSQAccessorClient.instance.accessor.exportLocalPrescriptionToDsq2(signature, idPatient, localPrescriptionId, async, approvedRequest));
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("DSQAccessorClient.exportLocalPrescriptionToDsq1", callback);
                }
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.exportLocalPrescriptionToDsq1", callback);
            }
        }
    }

    public ReturnObject getMedicationDetailServiceDM(XSession session, LocalDate administrationEffectiveStartDate, LocalDate administrationEffectiveEndDate, LocalDate amendedInTimeStartDate, LocalDate amendedInTimeEndDate, boolean onlyThoseWithIssue, NIU_OTHER_MEDICATION_DM niuMedicationDM, int idPatient, Integer limit, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getMedicationDetailServiceDM", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.getMedicationDetailServiceDM(signature, signatureNiu, administrationEffectiveStartDate, administrationEffectiveEndDate, amendedInTimeStartDate, amendedInTimeEndDate, onlyThoseWithIssue, niuMedicationDM, idPatient, limit);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getMedicationDetailServiceDM", null);
            }
        }
        return null;
    }

    public ReturnObject getMedicationSummaryServiceDM(XSession session, LocalDate administrationEffectiveStartDate, LocalDate administrationEffectiveEndDate, LocalDate amendedInTimeStartDate, LocalDate amendedInTimeEndDate, boolean onlyThoseWithIssue, int idPatient, Integer limit, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getMedicationSummaryServiceDM", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.getMedicationSummaryServiceDM(signature, signatureNiu, administrationEffectiveStartDate, administrationEffectiveEndDate, amendedInTimeStartDate, amendedInTimeEndDate, onlyThoseWithIssue, idPatient, limit);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getMedicationSummaryServiceDM", null);
            }
        }
        return null;
    }

    public ReturnObject getDrugPrescriptionDispensesSummary(XSession session, int idPatient, NIU_PRESCRIPTION_DM niuPrescriptionDM, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getDrugPrescriptionDispensesSummary", null)) {
            this.latency();
            try {
                ReturnObject returnObject = DSQAccessorClient.instance.accessor.getDrugPrescriptionDispensesSummary(signature, signatureNiu, niuPrescriptionDM, idPatient);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getDrugPrescriptionDispensesSummary", null);
            }
        }
        return null;
    }

    public ReturnObject getLaboList(XSession session, int idPatient, LocalDate startdate, LocalDate enddate, Integer limit, Signature signature, Signature signatureNiu, String clientUid, String channelName) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getLaboList", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getLaboList(signature, signatureNiu, idPatient, startdate, enddate, limit, clientUid, channelName);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getLaboList", null);
            }
        }
        return null;
    }

    public ReturnObject getLaboReport(XSession session, int idPatient, Code reportType, Id requestId, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getLaboReport", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getLaboReport(signature, signatureNiu, idPatient, reportType, requestId);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getLaboReport", null);
            }
        }
        return null;
    }

    public ReturnObject getLaboReport(XSession session, int idPatient, Code reportType, Id requestId) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getLaboReport", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getLaboReport(null, null, idPatient, reportType, requestId);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getLaboReport", null);
            }
        }
        return null;
    }

    public ReturnObject getLaboCumul(XSession session, int idPatient, LocalDate startdate, LocalDate enddate, Code orderTest, Integer limit, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getLaboList", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getLaboCumul(signature, signatureNiu, idPatient, startdate, enddate, orderTest, limit);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getLaboList", null);
            }
        }
        return null;
    }

    public ReturnObject listImagingExam(XSession session, int idPatient, LocalDate startdate, LocalDate enddate, Integer limit, Signature signature, Signature signatureNiu, String clientUid, String channelName) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.listImagingExam", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.listImagingExam(signature, signatureNiu, idPatient, startdate, enddate, limit, clientUid, channelName);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.listImagingExam", null);
            }
        }
        return null;
    }

    public ReturnObject getImagingExam(XSession session, int idPatient, Id studyIdentifier, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getImagingExam", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getImagingExam(signature, signatureNiu, idPatient, studyIdentifier);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getImagingExam", null);
            }
        }
        return null;
    }

    public ReturnObject getImagingExam(XSession session, int idPatient, Id studyIdentifier) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getImagingExam", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getImagingExam(null, null, idPatient, studyIdentifier);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getImagingExam", null);
            }
        }
        return null;
    }

    public ReturnObject listPatientDischargeCareSummary(XSession session, int idPatient, LocalDate startdate, LocalDate enddate, Boolean mostRecentByTypeIndicator, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.listPatientDischargeCareSummary", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.listPatientDischargeCareSummary(signature, signatureNiu, idPatient, startdate, enddate, mostRecentByTypeIndicator);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.listPatientDischargeCareSummary", null);
            }
        }
        return null;
    }

    public ReturnObject getPatientDischargeCareDetail(XSession session, int idPatient, NIU_SH niu_SH, Boolean includeHistory, Signature signature, Signature signatureNiu) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getPatientDischargeCareDetail", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getPatientDischargeCareDetail(signature, signatureNiu, idPatient, niu_SH, includeHistory);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getPatientDischargeCareDetail", null);
            }
        }
        return null;
    }

    public ReturnObject getPatientDischargeCareDetail(XSession session, int idPatient, NIU_SH niu_SH, Boolean includeHistory) throws Exception {
        if (this.isOkToCallFunction("DSQAccessorClient.getPatientDischargeCareDetail", null)) {
            this.latency();
            try {
                ReturnObject ret;
                ReturnObject returnObject = ret = DSQAccessorClient.instance.accessor.getPatientDischargeCareDetail(null, null, idPatient, niu_SH, includeHistory);
                return returnObject;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.functionCallEnded("DSQAccessorClient.getPatientDischargeCareDetail", null);
            }
        }
        return null;
    }

    protected IDSQAccessor getAccessor() {
        return this.accessor;
    }
}

