/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.io.SignerInputStream;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsDHKeyExchange;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSigner;
import org.bouncycastle.crypto.tls.TlsUtils;

class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    TlsDHEKeyExchange(TlsClientContext context, int keyExchange) {
        super(context, keyExchange);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initSigner(this.tlsSigner, securityParameters);
        SignerInputStream sigIn = new SignerInputStream(is, signer);
        byte[] pBytes = TlsUtils.readOpaque16(sigIn);
        byte[] gBytes = TlsUtils.readOpaque16(sigIn);
        byte[] YsBytes = TlsUtils.readOpaque16(sigIn);
        byte[] sigByte = TlsUtils.readOpaque16(is);
        if (!signer.verifySignature(sigByte)) {
            throw new TlsFatalAlert(42);
        }
        BigInteger p = new BigInteger(1, pBytes);
        BigInteger g = new BigInteger(1, gBytes);
        BigInteger Ys = new BigInteger(1, YsBytes);
        this.dhAgreeServerPublicKey = this.validateDHPublicKey(new DHPublicKeyParameters(Ys, new DHParameters(p, g)));
    }

    protected Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

