/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.crypto.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private final int[][][] M = new int[16][256][];

    @Override
    public void init(byte[] H) {
        this.M[0][0] = new int[4];
        this.M[0][128] = GCMUtil.asInts(H);
        int j = 64;
        while (j >= 1) {
            int[] tmp = new int[4];
            System.arraycopy(this.M[0][j + j], 0, tmp, 0, 4);
            GCMUtil.multiplyP(tmp);
            this.M[0][j] = tmp;
            j >>= 1;
        }
        int i = 0;
        block1: while (true) {
            int j2 = 2;
            while (j2 < 256) {
                int k = 1;
                while (k < j2) {
                    int[] tmp = new int[4];
                    System.arraycopy(this.M[i][j2], 0, tmp, 0, 4);
                    GCMUtil.xor(tmp, this.M[i][k]);
                    this.M[i][j2 + k] = tmp;
                    ++k;
                }
                j2 += j2;
            }
            if (++i == 16) {
                return;
            }
            this.M[i][0] = new int[4];
            j2 = 128;
            while (true) {
                if (j2 <= 0) continue block1;
                int[] tmp = new int[4];
                System.arraycopy(this.M[i - 1][j2], 0, tmp, 0, 4);
                GCMUtil.multiplyP8(tmp);
                this.M[i][j2] = tmp;
                j2 >>= 1;
            }
            break;
        }
    }

    @Override
    public void multiplyH(byte[] x) {
        int[] z = new int[4];
        int i = 15;
        while (i >= 0) {
            int[] m = this.M[i][x[i] & 0xFF];
            z[0] = z[0] ^ m[0];
            z[1] = z[1] ^ m[1];
            z[2] = z[2] ^ m[2];
            z[3] = z[3] ^ m[3];
            --i;
        }
        Pack.intToBigEndian(z[0], x, 0);
        Pack.intToBigEndian(z[1], x, 4);
        Pack.intToBigEndian(z[2], x, 8);
        Pack.intToBigEndian(z[3], x, 12);
    }
}

