/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.AuthAttributesProvider;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSecureReadable;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.KeyTransRecipient;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r = info.getRecipientIdentifier();
        if (r.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier oid) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals(oid)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return oid.getId();
    }

    protected Key getSessionKey(Key receiverPrivateKey, Provider prov) throws CMSException {
        CMSEnvelopedHelper helper = CMSEnvelopedHelper.INSTANCE;
        String keyExchangeAlgorithm = this.getExchangeEncryptionAlgorithmName(this.keyEncAlg.getObjectId());
        try {
            Key sKey = null;
            Cipher keyCipher = helper.createAsymmetricCipher(keyExchangeAlgorithm, prov);
            byte[] encryptedKeyBytes = this.info.getEncryptedKey().getOctets();
            String contentAlgorithmName = this.getContentAlgorithmName();
            try {
                keyCipher.init(4, receiverPrivateKey);
                sKey = keyCipher.unwrap(encryptedKeyBytes, contentAlgorithmName, 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ProviderException providerException) {}
            if (sKey == null) {
                keyCipher.init(2, receiverPrivateKey);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKeyBytes), contentAlgorithmName);
            }
            return sKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CMSException("illegal blocksize in message.", e);
        }
        catch (BadPaddingException e) {
            throw new CMSException("bad padding in message.", e);
        }
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        Key sKey = this.getSessionKey(key, prov);
        return this.getContentFromSessionKey(sKey, prov);
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

