/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509.qualified;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERPrintableString;

public class Iso4217CurrencyCode
extends ASN1Encodable
implements ASN1Choice {
    final int ALPHABETIC_MAXSIZE = 3;
    final int NUMERIC_MINSIZE = 1;
    final int NUMERIC_MAXSIZE = 999;
    DEREncodable obj;
    int numeric;

    public static Iso4217CurrencyCode getInstance(Object obj) {
        if (obj == null || obj instanceof Iso4217CurrencyCode) {
            return (Iso4217CurrencyCode)obj;
        }
        if (obj instanceof DERInteger) {
            DERInteger numericobj = DERInteger.getInstance(obj);
            int numeric = numericobj.getValue().intValue();
            return new Iso4217CurrencyCode(numeric);
        }
        if (obj instanceof DERPrintableString) {
            DERPrintableString alphabetic = DERPrintableString.getInstance(obj);
            return new Iso4217CurrencyCode(alphabetic.getString());
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public Iso4217CurrencyCode(int numeric) {
        if (numeric > 999 || numeric < 1) {
            throw new IllegalArgumentException("wrong size in numeric code : not in (1..999)");
        }
        this.obj = new DERInteger(numeric);
    }

    public Iso4217CurrencyCode(String alphabetic) {
        if (alphabetic.length() > 3) {
            throw new IllegalArgumentException("wrong size in alphabetic code : max size is 3");
        }
        this.obj = new DERPrintableString(alphabetic);
    }

    public boolean isAlphabetic() {
        return this.obj instanceof DERPrintableString;
    }

    public String getAlphabetic() {
        return ((DERPrintableString)this.obj).getString();
    }

    public int getNumeric() {
        return ((DERInteger)this.obj).getValue().intValue();
    }

    @Override
    public DERObject toASN1Object() {
        return this.obj.getDERObject();
    }
}

