/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.lucene.store.ByteBufferIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Constants;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = UNMAP_SUPPORTED;
    public static final int DEFAULT_MAX_BUFF;
    final int chunkSizePower;
    public static final boolean UNMAP_SUPPORTED;

    static {
        boolean v;
        DEFAULT_MAX_BUFF = Constants.JRE_IS_64BIT ? 0x40000000 : 0x10000000;
        try {
            Class.forName("sun.misc.Cleaner");
            Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            v = true;
        }
        catch (Exception exception) {
            v = false;
        }
        UNMAP_SUPPORTED = v;
    }

    public MMapDirectory(File path, LockFactory lockFactory) throws IOException {
        this(path, lockFactory, DEFAULT_MAX_BUFF);
    }

    public MMapDirectory(File path) throws IOException {
        this(path, null);
    }

    public MMapDirectory(File path, LockFactory lockFactory, int maxChunkSize) throws IOException {
        super(path, lockFactory);
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 31 - Integer.numberOfLeadingZeros(maxChunkSize);
        assert (this.chunkSizePower >= 0 && this.chunkSizePower <= 30);
    }

    public void setUseUnmap(boolean useUnmapHack) {
        if (useUnmapHack && !UNMAP_SUPPORTED) {
            throw new IllegalArgumentException("Unmap hack not supported on this platform!");
        }
        this.useUnmapHack = useUnmapHack;
    }

    public boolean getUseUnmap() {
        return this.useUnmapHack;
    }

    public final int getMaxChunkSize() {
        return 1 << this.chunkSizePower;
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File f = new File(this.getDirectory(), name);
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            MMapIndexInput mMapIndexInput = new MMapIndexInput("MMapIndexInput(path=\"" + f + "\")", raf);
            return mMapIndexInput;
        }
    }

    @Override
    public Directory.IndexInputSlicer createSlicer(String name, IOContext context) throws IOException {
        final MMapIndexInput full = (MMapIndexInput)this.openInput(name, context);
        return new Directory.IndexInputSlicer(this){

            @Override
            public IndexInput openSlice(String sliceDescription, long offset, long length) throws IOException {
                MMapDirectory.this.ensureOpen();
                return full.slice(sliceDescription, offset, length);
            }

            @Override
            public IndexInput openFullSlice() throws IOException {
                MMapDirectory.this.ensureOpen();
                return full.clone();
            }

            @Override
            public void close() throws IOException {
                full.close();
            }
        };
    }

    ByteBuffer[] map(RandomAccessFile raf, long offset, long length) throws IOException {
        if (length >>> this.chunkSizePower >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("RandomAccessFile too big for chunk size: " + raf.toString());
        }
        long chunkSize = 1L << this.chunkSizePower;
        int nrBuffers = (int)(length >>> this.chunkSizePower) + 1;
        ByteBuffer[] buffers = new ByteBuffer[nrBuffers];
        long bufferStart = 0L;
        FileChannel rafc = raf.getChannel();
        int bufNr = 0;
        while (bufNr < nrBuffers) {
            int bufSize = (int)(length > bufferStart + chunkSize ? chunkSize : length - bufferStart);
            buffers[bufNr] = rafc.map(FileChannel.MapMode.READ_ONLY, offset + bufferStart, bufSize);
            bufferStart += (long)bufSize;
            ++bufNr;
        }
        return buffers;
    }

    private final class MMapIndexInput
    extends ByteBufferIndexInput {
        private final boolean useUnmapHack;

        MMapIndexInput(String resourceDescription, RandomAccessFile raf) throws IOException {
            super(resourceDescription, MMapDirectory.this.map(raf, 0L, raf.length()), raf.length(), MMapDirectory.this.chunkSizePower, MMapDirectory.this.getUseUnmap());
            this.useUnmapHack = MMapDirectory.this.getUseUnmap();
        }

        @Override
        protected void freeBuffer(final ByteBuffer buffer) throws IOException {
            if (this.useUnmapHack) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                            getCleanerMethod.setAccessible(true);
                            Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                            if (cleaner != null) {
                                cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    IOException ioe = new IOException("unable to unmap the mapped buffer");
                    ioe.initCause(e.getCause());
                    throw ioe;
                }
            }
        }
    }
}

