/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.statusbar;

import ca.infodata.ofys.mb.listener.property.IPropertyListener2;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager2;
import ca.infodata.ofys.ui.controls.statusbar.StatusMessage;
import ca.infodata.ofys.ui.controls.statusbar.StatusMessageManager;
import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.ui.library.ResourceGetter;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;

public class StatusBarManager
implements IPropertyListener2 {
    private IWorkbenchWindowConfigurer wwc;
    private ConcurrentMap<String, Message> messages;
    private CopyOnWriteArrayList<Message> list;
    private static StatusBarManager statusBar;
    private final int MAX_LOOP = 50;
    private final int FREQ = 1;
    private final long SLEEP_TIME = 100L;
    private Color systemBackgroundColor;

    private StatusBarManager(IWorkbenchWindowConfigurer wwc) {
        this.wwc = wwc;
        this.messages = new ConcurrentHashMap<String, Message>();
        this.list = new CopyOnWriteArrayList();
        Runnable run = new Runnable(){
            Message currentMsg;
            int count = 0;

            @Override
            public void run() {
                while (true) {
                    this.showMsg();
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }

            private void showMsg() {
                if (this.currentMsg == null && StatusBarManager.this.list.size() > 0) {
                    try {
                        this.currentMsg = (Message)StatusBarManager.this.list.get(0);
                    }
                    catch (Exception exception) {}
                }
                if (this.currentMsg != null && this.count - this.currentMsg.timeBonus < 50) {
                    StatusBarManager.this.showMessage(this.currentMsg);
                    ++this.count;
                } else if (this.currentMsg != null && this.count - this.currentMsg.timeBonus >= 50 && this.currentMsg.message != null) {
                    if (this.count % 1 == 0 && this.currentMsg.message.length() > 1) {
                        this.currentMsg.message = this.currentMsg.message.substring(1);
                    }
                    StatusBarManager.this.showMessage(this.currentMsg);
                    ++this.count;
                    if (this.count % 1 == 0 && this.currentMsg.message.length() <= 1) {
                        this.currentMsg.message = null;
                    }
                } else if (this.currentMsg != null && this.count - this.currentMsg.timeBonus >= 50 && this.currentMsg.message == null) {
                    StatusBarManager.this.showMessage(null);
                    this.count = 0;
                    StatusBarManager.this.messages.remove(this.currentMsg.key);
                    this.currentMsg = null;
                    StatusBarManager.this.list.remove(0);
                }
            }
        };
        DaemonThread t = new DaemonThread(run);
        t.setPriority(1);
        t.start();
        PropertyListenerManager2.addListener((Object)StatusMessageManager.getInstance(), (IPropertyListener2)this);
    }

    public static StatusBarManager getInstance() {
        return statusBar;
    }

    public static void init(IWorkbenchWindowConfigurer wwc) {
        statusBar = new StatusBarManager(wwc);
    }

    public void setMessage(String key, String message) {
        this.setMessage(key, message, 0);
    }

    public void setMessage(String key, String message, int timeBonus) {
        Message m = new Message(key, message, timeBonus, null);
        this.messages.put(key, m);
        this.list.add(m);
    }

    public void setMessage(Message message) {
        this.messages.put(message.key, message);
        this.list.add(message);
    }

    private void showMessage(final Message message) {
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    StatusLineManager slm;
                    Control control;
                    IStatusLineManager statusLineManager;
                    IActionBarConfigurer actionBarConfigurer;
                    if (StatusBarManager.this.wwc != null && (actionBarConfigurer = StatusBarManager.this.wwc.getActionBarConfigurer()) != null && (statusLineManager = actionBarConfigurer.getStatusLineManager()) != null && (control = (slm = (StatusLineManager)statusLineManager).getControl()) != null) {
                        if (StatusBarManager.this.systemBackgroundColor == null) {
                            StatusBarManager.this.systemBackgroundColor = control.getBackground();
                        }
                        StatusBarManager.this.setStatusLineBackGround(control, message == null ? null : message.background);
                        control.setBackground(message == null || message.background == null ? StatusBarManager.this.systemBackgroundColor : ResourceGetter.getColor((RGB)message.background));
                        statusLineManager.setMessage(message == null ? "" : message.message);
                    }
                }
            });
        }
    }

    protected void setStatusLineBackGround(Object object, RGB rgb) {
        try {
            Color color = rgb == null ? Display.getDefault().getSystemColor(22) : ResourceGetter.getColor((RGB)rgb);
            Field field = object.getClass().getDeclaredField("fMessageLabel");
            field.setAccessible(true);
            CLabel fMessageLabel = (CLabel)field.get(object);
            fMessageLabel.setBackground(color);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void propertyChanged(int propertyId, Object arg) {
        if (propertyId == 1) {
            StatusMessage sm = (StatusMessage)arg;
            Message message = new Message("key", sm.message, 0, sm.background);
            this.setMessage(message);
        }
    }

    public static class Message {
        public String key;
        public String message;
        public int timeBonus = 0;
        public RGB background;

        public Message(String key, String message) {
            this.key = key;
            this.message = message;
        }

        public Message(String key, String message, int timeBonus, RGB background) {
            this.key = key;
            this.message = message;
            this.timeBonus = timeBonus;
            this.background = background;
        }

        public String toString() {
            return "Message [key=" + this.key + ", message=" + this.message + ", timeBonus=" + this.timeBonus + ", background=" + this.background + "]";
        }
    }
}

