/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.handlers;

import ca.infodata.ofys.ui.controls.ICancelablePart;
import ca.infodata.ofys.ui.controls.IDeleteablePart;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.IRefreshablePart;
import ca.infodata.ofys.ui.controls.ISaveablePart;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class EditorPartEditionStateSourceProvider
extends AbstractSourceProvider {
    public static final String NAME = "ca.infodata.ofys.ui.editor.saveable";
    public static final String SAVEABLE = "ca.infodata.ofys.ui.editor.saveable";
    public static final String DELETABLE = "ca.infodata.ofys.ui.editor.deleteable";
    public static final String CANCELABLE = "ca.infodata.ofys.ui.editor.cancelable";
    public static final String PRINTABLE = "ca.infodata.ofys.ui.editor.printable";
    public static final String REFRESHABLE = "ca.infodata.ofys.ui.editor.refreshable";
    public static final String TRUE = "t";
    public static final String FALSE = "f";

    public String[] getProvidedSourceNames() {
        return new String[]{"ca.infodata.ofys.ui.editor.saveable", DELETABLE, CANCELABLE, PRINTABLE, REFRESHABLE};
    }

    public Map<String, String> getCurrentState() {
        HashMap<String, String> currentState = new HashMap<String, String>(1);
        IEditorPart part = this.getCurrentEditorPart();
        currentState.put("ca.infodata.ofys.ui.editor.saveable", this.isSaveable(part));
        currentState.put(DELETABLE, this.isDeleteable(part));
        currentState.put(CANCELABLE, this.isCancelable(part));
        currentState.put(PRINTABLE, this.isPrintable(part));
        currentState.put(REFRESHABLE, this.isRefreshable(part));
        return currentState;
    }

    private String toXml(boolean value) {
        return value ? TRUE : FALSE;
    }

    private String isSaveable(IEditorPart part) {
        if (part instanceof ISaveablePart) {
            return this.toXml(true);
        }
        return this.toXml(false);
    }

    private String isDeleteable(IEditorPart part) {
        if (part instanceof IDeleteablePart) {
            return this.toXml(true);
        }
        return this.toXml(false);
    }

    private String isCancelable(IEditorPart part) {
        if (part instanceof ICancelablePart) {
            return this.toXml(true);
        }
        return this.toXml(false);
    }

    private String isPrintable(IEditorPart part) {
        if (part instanceof IPrintable) {
            return this.toXml(true);
        }
        return this.toXml(false);
    }

    private String isRefreshable(IEditorPart part) {
        if (part instanceof IRefreshablePart) {
            return this.toXml(true);
        }
        return this.toXml(false);
    }

    private IEditorPart getCurrentEditorPart() {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IEditorPart activeEditor = activePage.getActiveEditor();
                return activeEditor;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void refresh() {
        IEditorPart part = this.getCurrentEditorPart();
        this.fireSourceChanged(0, "ca.infodata.ofys.ui.editor.saveable", this.isSaveable(part));
        this.fireSourceChanged(0, DELETABLE, this.isDeleteable(part));
        this.fireSourceChanged(0, CANCELABLE, this.isCancelable(part));
        this.fireSourceChanged(0, PRINTABLE, this.isPrintable(part));
    }

    public void dispose() {
    }
}

