/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.NumberMask;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SimpleNumberText
extends MyMaskedText {
    private final NumberMask defaultMask = new NumberMask();

    public SimpleNumberText(Composite parent, FormToolkit formToolkit) {
        super(parent, formToolkit);
        super.setMask(this.defaultMask);
        super.setAutoTraverseTabNextOnMaskLimit(false);
    }

    public SimpleNumberText(Composite parent, int style, FormToolkit formToolkit) {
        super(parent, style, formToolkit);
        super.setMask(this.defaultMask);
        super.setAutoTraverseTabNextOnMaskLimit(false);
    }

    public SimpleNumberText(Composite parent, int style) {
        super(parent, style);
        super.setMask(this.defaultMask);
        super.setAutoTraverseTabNextOnMaskLimit(false);
    }

    @Override
    public void setMask(MyMask mask) {
        if (!(mask instanceof NumberMask)) {
            throw new IllegalArgumentException("mask must be instance of NumberMask");
        }
        super.setMask(mask);
    }

    @Override
    public NumberMask getMask() {
        return (NumberMask)super.getMask();
    }

    @Override
    public void setAutoTraverseTabNextOnMaskLimit(boolean autoTraverseTabNextOnMaskLimit) {
    }

    public void setNumber(Integer number) {
        if (number == null) {
            this.setText(null);
        } else {
            this.setText(number.toString());
        }
    }

    public void setNumber(Short number) {
        if (number == null) {
            this.setText(null);
        } else {
            this.setText(number.toString());
        }
    }

    public void setNumber(Double number, int dec) {
        if (number == null) {
            this.setText(null);
        } else {
            this.setText(SimpleNumberText.Round(number, dec).toString());
        }
    }

    public void setNumberKeepSelection(Integer number) {
        if (number == null) {
            this.setTextKeepSelection(null);
        } else {
            this.setTextKeepSelection(number.toString());
        }
    }

    public Integer getNumber() {
        String text = this.getText();
        if (text == null || text.length() == 0 || text.length() == 1 && text.charAt(0) == '-') {
            return null;
        }
        try {
            return Integer.valueOf(text);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setText(String s) {
        if (s != null && this.getMask() != null && !this.isValidNotSetText()) {
            s = this.getMask().apply(s);
            SimpleNumberText snt = this;
            if (!NumberUtils.isNumber((String)s) || Integer.parseInt(s) < snt.getMask().getMinimum()) {
                s = String.valueOf(snt.getMask().getMinimum());
            }
        }
        this.setRawText(s);
    }

    public static Double Round(Number value, int digits) {
        Double d = null;
        if (value == null) {
            return null;
        }
        if (digits == 0) {
            d = new Double((double)Math.round(value.floatValue() * 1.0f) / 1.0);
        }
        if (digits == 1) {
            d = new Double((double)Math.round(value.floatValue() * 10.0f) / 10.0);
        }
        if (digits == 2) {
            d = new Double((double)Math.round(value.floatValue() * 100.0f) / 100.0);
        }
        if (digits == 3) {
            d = new Double((double)Math.round(value.floatValue() * 1000.0f) / 1000.0);
        }
        return d;
    }
}

