/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.callback.DeleteCallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallbackWrapper;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationProcessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IVariablesReplacer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.ISwitchTable;
import ca.infodata.ofys.ui.controls.ISwitchTableListener;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.MutableBoolean;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;

public class EditorsGenericFunctions {
    private static final Logger logger = Logger.getLogger(EditorsGenericFunctions.class.getName());
    private static final String A_NEWER_VERSION = Messages.getString((String)"UNE_VERSION_PLUS_RECENTE_DE_CET_ENREGISTREMENT_EXISTE_VOTRE_VERSION_SERA_REMPLACEE", (String[])new String[0]);
    private static DataObjectNotificationProcessor donop = new DataObjectNotificationProcessor();
    private static GlobalInstancesListener globalInstancesListener = new GlobalInstancesAdapter(){

        public void sessionChanged() {
            Application.get().getGlobalInstances().getNotificationSystem().removeDataObjectNotificationHandler(donop.handler);
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null) {
                Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(donop.handler);
            }
        }
    };
    private IBaseEditor editor;
    private volatile boolean isUILoaded = false;
    private volatile boolean isDataLoaded = false;
    private volatile boolean[] isDisposed = new boolean[1];
    private boolean mustEditDataObject = true;
    private boolean lastKnowDirtyStatus = false;
    private ArrayList<ISwitchTable> lstSwitchTable = new ArrayList();
    private final ISwitchTableListener switchTableListener = new ISwitchTableListener(){

        @Override
        public void editionStateChanged() {
            EditorsGenericFunctions.this.checkDirty(true);
        }
    };
    private IVariablesReplacer<EditableDataObject> replacer;
    private Image imageTitle;
    protected IStatus lastSaveOrDeleteStatus;
    protected volatile boolean saving;
    private DataObjectNotificationProcessor.DataObjectNotificationProcessorListener handlerListener;

    static {
        Application.get().getGlobalInstances().addGlobalInstancesListener(globalInstancesListener);
        if (Application.get().getGlobalInstances().getSession() != null) {
            Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(EditorsGenericFunctions.donop.handler);
        }
    }

    public EditorsGenericFunctions(IBaseEditor editor, boolean registerListener) {
        this.editor = editor;
        if (registerListener) {
            this.editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 300 && EditorsGenericFunctions.this.getEditorInput().getCompleteDataObject() != null) {
                        donop.put((Object)EditorsGenericFunctions.this.getEditorInput().getCompleteDataObject());
                    }
                }
            });
            this.handlerListener = new DataObjectNotificationProcessor.DataObjectNotificationProcessorListener(){

                public void afterUpdate(Object object, boolean majorUpdate) {
                    EditorsGenericFunctions.this.tryRefresh(object, majorUpdate);
                }

                public void beforeUpdate(Object object, boolean majorUpdate) {
                }

                public void afterReplace(Object oldObj, Object newObj) {
                    Log.log((Level)Level.FINE, (String)"EditorGenericFunctions", (String)"afterReplace");
                    EditorsGenericFunctions.this.tryReplace(oldObj, newObj, true);
                }

                public void beforeReplace(Object oldObj, Object newObj) {
                }

                public void processed(Object obj, boolean replacedOrUpdated) {
                }
            };
            donop.addListener(this.handlerListener);
        }
    }

    private void tryRefresh(final Object obj, final boolean majorUpdate) {
        if (this.isDisposed() || this.saving) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int result = EditorsGenericFunctions.this.compareWithCurrent(obj);
                switch (result) {
                    case -1: 
                    case 1: {
                        break;
                    }
                    case 0: {
                        if (majorUpdate) {
                            logger.fine("isActiveEditor()" + String.valueOf(EditorsGenericFunctions.this.isActiveEditor()));
                            if (EditorsGenericFunctions.this.isDirty() && EditorsGenericFunctions.this.isActiveEditor()) {
                                MessageDialog.openWarning((Shell)EditorsGenericFunctions.this.getShell(), (String)Messages.getString((String)"AVERTISSEMENT", (String[])new String[0]), (String)A_NEWER_VERSION);
                            }
                            EditorsGenericFunctions.this.doRefresh();
                            break;
                        }
                        EditorsGenericFunctions.this.replaceBy(obj);
                    }
                }
            }
        });
    }

    private void tryReplace(Object old, final Object obj, final boolean majorUpdate) {
        if (this.isDisposed() || this.saving) {
            return;
        }
        if (this.compareWithCurrent(old) == -1) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int result = EditorsGenericFunctions.this.compareWithCurrent(obj);
                switch (result) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        if (EditorsGenericFunctions.this.isDirty() && majorUpdate && EditorsGenericFunctions.this.isActiveEditor()) {
                            MessageDialog.openWarning((Shell)EditorsGenericFunctions.this.getShell(), (String)Messages.getString((String)"AVERTISSEMENT", (String[])new String[0]), (String)A_NEWER_VERSION);
                        }
                        EditorsGenericFunctions.this.replaceBy(obj);
                        break;
                    }
                }
            }
        });
    }

    private boolean isActiveEditor() {
        IEditorPart activeEditor = this.editor.getEditorPart().getEditorSite().getPage().getActiveEditor();
        return activeEditor == this.editor.getEditorPart();
    }

    private Shell getShell() {
        return this.editor.getEditorPart().getEditorSite().getShell();
    }

    private int compareWithCurrent(Object obj) {
        boolean tagsAreEqual;
        EditableDataObject current;
        EditorInput editorInput = this.getEditorInput();
        EditableDataObject editableDataObject = current = editorInput == null ? null : editorInput.getCompleteDataObject();
        if (current == null || !(obj instanceof EditableDataObject)) {
            return -1;
        }
        boolean objectAreEqual = current.equals(obj);
        boolean bl = tagsAreEqual = current.getTag() != null && MiscUtil.objectsAreEquals((Object)current.getTag(), (Object)((EditableDataObject)obj).getTag());
        if (tagsAreEqual) {
            return 1;
        }
        if (objectAreEqual) {
            return 0;
        }
        return -1;
    }

    private void replaceBy(Object obj) {
        if (obj == null) {
            this.setCompleteDataObject(null);
        } else {
            EditableDataObject clone = ((EditableDataObject)obj).clone();
            clone.setTag(null);
            this.setCompleteDataObject(clone);
        }
    }

    protected EditorInput getEditorInput() {
        return (EditorInput)this.editor.getEditorInput();
    }

    public void checkDirty() {
        this.checkDirty(false);
    }

    public void checkDirty(boolean force) {
        boolean newDirty = this.isDirty();
        if (force || this.lastKnowDirtyStatus != newDirty) {
            this.lastKnowDirtyStatus = newDirty;
            this.editor.firePropertyChange(257);
            this.setAllToolBarStatus();
        }
    }

    public final boolean isUILoaded() {
        return this.isUILoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUILoaded() {
        EditorInput editorInput = this.getEditorInput();
        synchronized (editorInput) {
            try {
                this.isUILoaded = true;
                if (this.isDataLoaded) {
                    this.editor.showAllDataObject();
                    this.editor.setEnabled(true);
                }
                this.editor.setPartName(this.editor.getEditorTitle());
                this.imageTitle = this.editor.getEditorTitleImage();
                this.editor.setTitleImage(this.editor.getEditorTitleImage());
            }
            catch (Exception e) {
                this.isUILoaded = false;
                this.editor.setEnabled(false);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public final void setDataLoaded(boolean value) {
        this.isDataLoaded = value;
        if (this.isUILoaded) {
            if (this.isDataLoaded) {
                this.editor.showAllDataObject();
            }
            this.editor.setEnabled(this.isDataLoaded);
        }
        this.editor.firePropertyChange(257);
    }

    public final void setFocus() {
        ControlsPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditorsGenericFunctions.this.checkDirty();
                EditorsGenericFunctions.this.setAllToolBarStatus();
            }
        });
    }

    public void setAllToolBarStatus() {
        this.editor.setToolBarStatus();
    }

    public String getTitleToolTip() {
        String tooltip = this.editor.getSuperTitleToolTip();
        if (tooltip == null) {
            tooltip = "";
        }
        return tooltip;
    }

    public final boolean isDirty() {
        if (!this.isDataLoaded || !this.isUILoaded()) {
            return false;
        }
        boolean dirty = true;
        if (this.getEditorInput().getCompleteDataObject() != null) {
            if (!this.getEditorInput().getCompleteDataObject().isNewOrNewUpdated()) {
                dirty = this.editor.isDataDirty();
            }
        } else {
            dirty = false;
        }
        return dirty;
    }

    public final boolean isSaveAllowed() {
        return !this.hasSwitchTableInEditon() && this.isDirty();
    }

    private boolean hasSwitchTableInEditon() {
        int i = 0;
        while (i < this.lstSwitchTable.size()) {
            if (this.lstSwitchTable.get(i).isInEdition()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void doSave(Runnable runnable) {
        SaveCallback callbackDelegate = new SaveCallback(Application.get().getGlobalInstances().getSession());
        this.doSave(runnable, callbackDelegate, true);
    }

    public void doSave(final Runnable runnable, SaveCallback callbackDelegate, boolean askQuestion) {
        block9: {
            if (callbackDelegate == null) {
                throw new NullPointerException("callbackDelegate");
            }
            if (this.getEditorInput().getCompleteDataObject() != null) {
                final MutableBoolean switchOk = new MutableBoolean(true);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < EditorsGenericFunctions.this.lstSwitchTable.size()) {
                            if (((ISwitchTable)EditorsGenericFunctions.this.lstSwitchTable.get(i)).isInEdition() && !((ISwitchTable)EditorsGenericFunctions.this.lstSwitchTable.get(i)).save()) {
                                switchOk.setFalse();
                                break;
                            }
                            ++i;
                        }
                    }
                });
                if (switchOk.booleanValue()) {
                    SaveCallbackWrapper callback = null;
                    try {
                        EditableDataObject o = this.getEditorInput().getCompleteDataObject();
                        o.setTag();
                        final XPatientImage ptimgToHoldPict = new XPatientImage();
                        if (o instanceof XPatientImage) {
                            ptimgToHoldPict.setPicture(((XPatientImage)o).getPicture());
                            ptimgToHoldPict.setPictureToPrint(((XPatientImage)o).getPictureToPrint());
                            if (o.getId() != null) {
                                ((XPatientImage)o).picture = null;
                                ((XPatientImage)o).pictureToPrint = null;
                            }
                        }
                        logger.log(Level.FINE, "o.getTag()=" + String.valueOf(o.getTag()));
                        this.saving = true;
                        callback = new SaveCallbackWrapper(callbackDelegate){

                            public void responseReceived(final ReturnObject response) {
                                super.responseReceived(response);
                                EditorsGenericFunctions.this.lastSaveOrDeleteStatus = response.getStatus();
                                if (!EditorsGenericFunctions.this.isDisposed()) {
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (response.getStatus().isOkToProceed()) {
                                                Object oo = response.getObj() instanceof Object[] ? ((Object[])response.getObj())[0] : response.getObj();
                                                EditorInput editorInput = (EditorInput)EditorsGenericFunctions.this.editor.getEditorInput();
                                                EditableDataObject obj = (EditableDataObject)oo;
                                                if (editorInput.getDataObject().getId() == null) {
                                                    editorInput.getDataObject().setId(obj.getId());
                                                }
                                                if (obj instanceof XPatientImage && EditorsGenericFunctions.this.getEditorInput().getCompleteDataObject() instanceof XPatientImage) {
                                                    if (((XPatientImage)obj).getPicture() == null) {
                                                        ((XPatientImage)obj).picture = ptimgToHoldPict.getPicture();
                                                    }
                                                    if (((XPatientImage)obj).getPictureToPrint() == null) {
                                                        ((XPatientImage)obj).pictureToPrint = ptimgToHoldPict.getPictureToPrint();
                                                    }
                                                }
                                                EditorsGenericFunctions.this.setCompleteDataObject(obj);
                                                BaseView.refreshViews(EditorsGenericFunctions.this.editor.getEditorInput());
                                                (this).EditorsGenericFunctions.this.saving = false;
                                                EditorsGenericFunctions.this.editor.saved();
                                                Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)obj, this.getSession());
                                            } else {
                                                EditorsGenericFunctions.this.editor.saveFailed();
                                            }
                                        }
                                    });
                                }
                                if (runnable != null) {
                                    Display.getDefault().asyncExec(runnable);
                                }
                            }
                        };
                        this.editor.getAccessor().saveSync(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), (SaveCallback)callback, (Serializable)o, askQuestion);
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        this.saving = false;
                        MessageUtil.cannotConnectToServerExceptionMsg();
                        if (callback != null) {
                            callback.kill();
                        }
                    }
                    catch (Exception e) {
                        this.saving = false;
                        logger.log(Level.SEVERE, "Erreur", e);
                        if (callback == null) break block9;
                        callback.kill();
                    }
                }
            }
        }
    }

    public void initializeCompleteDataObject(EditableDataObject completeDataObject) {
        this.setCompleteDataObject(completeDataObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompleteDataObject(EditableDataObject completeDataObject) {
        EditorInput editorInput = this.getEditorInput();
        synchronized (editorInput) {
            this.getEditorInput().setCompleteDataObject(completeDataObject);
            this.editor.firePropertyChange(300);
            this.editor.firePropertyChange(258);
            if (this.getVariablesReplacer() != null) {
                this.getVariablesReplacer().setDataObject((Object)completeDataObject);
                this.getVariablesReplacer().setToday(LocalDate.today());
            }
            this.setDataLoaded(true);
        }
        this.editor.setPartName(this.editor.getEditorTitle());
        this.editor.setEnabled(true);
    }

    public final void doClose() {
        this.editor.getEditorPart().getSite().getPage().closeEditor((IEditorPart)this.editor, false);
    }

    public final void doCancel() {
        int i = 0;
        while (i < this.lstSwitchTable.size()) {
            if (this.lstSwitchTable.get(i).isInEdition()) {
                this.lstSwitchTable.get(i).cancel();
            }
            ++i;
        }
        if (this.getEditorInput().getCompleteDataObject() != null) {
            this.getEditorInput().reloadInitialCompleteDataObject();
            this.setCompleteDataObject(this.getEditorInput().getCompleteDataObject());
        }
    }

    public final void doDelete(final IProgressMonitor monitor) {
        if (monitor != null) {
            this.doDelete(new Runnable(){

                @Override
                public void run() {
                    monitor.done();
                }
            });
        }
    }

    public final void doDelete(final Runnable callback) {
        block7: {
            if (this.getEditorInput().getCompleteDataObject() != null) {
                int i = 0;
                while (i < this.lstSwitchTable.size()) {
                    if (this.lstSwitchTable.get(i).isInEdition()) {
                        this.lstSwitchTable.get(i).cancel();
                    }
                    ++i;
                }
                DeleteCallback callback2 = new DeleteCallback(Application.get().getGlobalInstances().getSession()){

                    public void responseReceived(ReturnObject response) {
                        EditorsGenericFunctions.this.lastSaveOrDeleteStatus = response.getStatus();
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!EditorsGenericFunctions.this.isDisposed() && this.getHandlerStatusState() == IStatusHandler.State.HANDLED_POSITIVE) {
                                    LibPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getPages()[0].closeEditor((IEditorPart)EditorsGenericFunctions.this.editor, false);
                                }
                            }
                        });
                        if (callback != null) {
                            Display.getDefault().asyncExec(callback);
                        }
                    }
                };
                try {
                    this.editor.getAccessor().delete(this.getUniqueKey(), Application.get().getGlobalInstances().getSession(), callback2, (IDataObject)this.getEditorInput().getCompleteDataObject(), true);
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback2 != null && !callback2.killed()) {
                        callback2.kill();
                    }
                }
                catch (Exception exception) {
                    if (callback2 == null || callback2.killed()) break block7;
                    callback2.kill();
                }
            }
        }
    }

    public boolean isRefreshAllowed() {
        IDataObject dataObject;
        EditorInput input;
        if (!this.isDisposed() && (input = this.getEditorInput()) != null && (dataObject = input.getDataObject()) != null) {
            return dataObject.getId() != null && !this.isDirty();
        }
        return false;
    }

    public final void doRefresh() {
        if (!this.isDisposed()) {
            this.getEditorInput().setCompleteDataObject(null);
            this.editor.initData();
        }
        this.editor.setPartName(this.editor.getEditorTitle());
    }

    public void redrawControls() {
        Shell comp = this.getShell();
        comp.setSize(comp.getSize().x - 1, comp.getSize().y + 1);
        comp.setSize(comp.getSize().x + 1, comp.getSize().y - 1);
    }

    public boolean mustEditDataObject() {
        return this.mustEditDataObject;
    }

    public void setMustEditDataObject(boolean mustEditDataObject) {
        this.mustEditDataObject = mustEditDataObject;
    }

    public void setDisposed() {
        if (this.imageTitle != null) {
            ResourceGetter.dispose((Object)this.imageTitle);
        }
        if (this.handlerListener != null) {
            donop.removeListener(this.handlerListener);
            this.handlerListener = null;
        }
        this.isDisposed[0] = true;
    }

    public void registerSwitchTable(ISwitchTable table) {
        this.lstSwitchTable.add(table);
        table.addListener(this.switchTableListener);
    }

    public IVariablesReplacer<EditableDataObject> getVariablesReplacer() {
        if (this.replacer == null) {
            this.replacer = this.editor.getVariablesReplacerNewInstance();
        }
        return this.replacer;
    }

    public boolean isDisposed() {
        return this.isDisposed[0];
    }

    public boolean getLastKnowDirtyStatus() {
        return this.lastKnowDirtyStatus;
    }

    public String getEditorTitle() {
        String title = "";
        if (this.getEditorInput().getCompleteDataObject() != null && this.getEditorInput().getCompleteDataObject().toString().length() != 0) {
            title = Application.get().getGlobalInstances().inDebugMode() ? this.getEditorInput().getCompleteDataObject().getId() + ", " + this.getEditorInput().getCompleteDataObject().toString() : this.getEditorInput().getCompleteDataObject().toString();
        } else if (this.getEditorInput().getDataObject() != null) {
            title = Application.get().getGlobalInstances().inDebugMode() ? this.getEditorInput().getDataObject().getId() + ", " + this.getEditorInput().getDataObject().toString() : this.getEditorInput().getDataObject().toString();
        }
        return title;
    }

    public int getUniqueKey() {
        return this.getEditorInput().getDataObject().hashCode();
    }

    public IStatus getLastSaveOrDeleteStatus() {
        return this.lastSaveOrDeleteStatus;
    }
}

