/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.EncounterAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.billingnb.XNBServiceCode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.ICode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCodeClassification;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLabType;
import ca.infodata.ofys.ui.controls.NoSessionWarningComposite;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CodeSearchComposite
extends BaseSearchComposite {
    private static final Logger logger = Logger.getLogger(CodeSearchComposite.class.getName());
    protected String MOT_CODE = Messages.getString((String)"MOT(S)_OU_CODE", (String[])new String[0]);
    protected MyLabel lblDescDiagnostic;
    protected MyText txtDescDiagnostic;
    protected MyCombo<XCodeClassification> cmbClassification;
    protected boolean visitReasonMode = false;

    public static void openNewDialog(Shell parent, IReferenceControl referenceControl, XCodeClassification classification) {
        CodeSearchComposite.openNewDialog(parent, referenceControl, classification, classification);
    }

    public static void openNewDialog(Shell parent, IReferenceControl referenceControl, XCodeClassification defaultClassification, XCodeClassification ... classification) {
        final Shell shell = new Shell(parent, 65616);
        shell.setLayout((Layout)new FillLayout());
        if (Application.get().getGlobalInstances().getSession() == null) {
            new NoSessionWarningComposite((Composite)shell, 0);
        } else {
            CodeSearchComposite searhComposite = new CodeSearchComposite((Composite)shell, 0){

                @Override
                public void close() {
                    shell.close();
                }
            };
            if (classification != null) {
                searhComposite.setClassificationChoices(classification);
                searhComposite.setClassification(defaultClassification, classification.length > 1);
            }
            searhComposite.setReferenceControl(referenceControl);
        }
        shell.setSize(600, 400);
        UI.centerComposite((Composite)shell, (Composite)shell.getParent());
        shell.setSize(600, 500);
        shell.open();
    }

    public CodeSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
    }

    public CodeSearchComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void setFocus() {
        this.txtDescDiagnostic.setFocus();
        this.txtDescDiagnostic.getDisplay().timerExec(50, new Runnable(){

            @Override
            public void run() {
                if (!CodeSearchComposite.this.txtDescDiagnostic.isDisposed()) {
                    CodeSearchComposite.this.txtDescDiagnostic.setFocus();
                }
            }
        });
    }

    @Override
    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        this.setIsWithButtonNew(false);
        this.lblDescDiagnostic = new MyLabel(parent, this.MOT_CODE, 0, toolkit);
        this.txtDescDiagnostic = new MyText(parent, toolkit);
        this.txtDescDiagnostic.setTextLimit(95);
        this.txtDescDiagnostic.addKeyListener(this.enterCtrlEnterListener);
        this.txtDescDiagnostic.setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.cmbClassification = new MyCombo(parent, 8, toolkit);
        this.cmbClassification.setItems((XCodeClassification[])XCodeClassification.values());
        this.cmbClassification.setDefaultSelection(XCodeClassification.CIM10);
        this.cmbClassification.select(XCodeClassification.CIM10);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblDescDiagnostic.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDescDiagnostic.getControl());
        data.right = new FormAttachment(100);
        this.cmbClassification.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDescDiagnostic.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment((Control)this.cmbClassification.getControl());
        this.txtDescDiagnostic.setLayoutData(data);
    }

    @Override
    protected void processSelection(SearchItem item) {
    }

    @Override
    protected void search() throws ErrorWhileSearchingException {
        block6: {
            JobCallback callback = null;
            String text = this.txtDescDiagnostic.getText();
            String classification = this.cmbClassification.getSelection().id;
            try {
                callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                    public void responseReceived(ReturnObject response) {
                        CodeSearchComposite.this.searchResponse((List)response.getObj());
                    }
                };
                if (!this.visitReasonMode) {
                    EncounterAccessorClient.getInstance().findCode(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, text, classification);
                } else {
                    EncounterAccessorClient.getInstance().findCodeReasonVisit(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, text);
                }
            }
            catch (CannotConnectToServerException e) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
                throw new ErrorWhileSearchingException((Exception)((Object)e));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to find code with " + text + ", classi. " + classification, e);
                if (callback == null || callback.killed()) break block6;
                callback.kill();
            }
        }
    }

    private void sortResponse(List<ICode> list) {
        Collections.sort(list, new Comparator<ICode>(){

            @Override
            public int compare(ICode a1, ICode a2) {
                if (a1 instanceof XNBServiceCode && a2 instanceof XNBServiceCode) {
                    XNBServiceCode o1 = (XNBServiceCode)a1;
                    XNBServiceCode o2 = (XNBServiceCode)a2;
                    if (o1.getCode() == null && o2.getCode() == null) {
                        return 0;
                    }
                    if (o1.getCode() == null) {
                        return -1;
                    }
                    if (o2.getCode() == null) {
                        return 1;
                    }
                    if (o1.getCode().compareToIgnoreCase(o2.getCode()) == 0) {
                        if (o1.getEndDate() == null && o2.getEndDate() == null) {
                            return 0;
                        }
                        if (o1.getEndDate() == null) {
                            return 1;
                        }
                        if (o2.getEndDate() == null) {
                            return -1;
                        }
                        if (o1.getEndDate().equals((Object)o2.getEndDate())) {
                            if (o1.getStartDate() == null && o2.getStartDate() == null) {
                                return 0;
                            }
                            if (o1.getStartDate() == null) {
                                return 1;
                            }
                            if (o2.getStartDate() == null) {
                                return -1;
                            }
                            if (o1.getStartDate().dayFrom1970 - o2.getStartDate().dayFrom1970 > 0) {
                                return -1;
                            }
                            return 0;
                        }
                        if (o1.getEndDate().dayFrom1970 - o2.getEndDate().dayFrom1970 > 0) {
                            return -1;
                        }
                        return 0;
                    }
                    return o1.getCode().compareToIgnoreCase(o2.getCode());
                }
                return 0;
            }
        });
    }

    private void searchResponse(final List<ICode> list) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!CodeSearchComposite.this.parent.isDisposed()) {
                        if (list.isEmpty()) {
                            CodeSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                            CodeSearchComposite.this.txtDescDiagnostic.setFocus();
                        } else {
                            CodeSearchComposite.this.setMessage(null);
                        }
                        CodeSearchComposite.this.disposeTableColumns();
                        CodeSearchComposite.this.createTableColumns();
                        CodeSearchComposite.this.sortResponse(list);
                        SearchItem[] search = new SearchItem[list == null ? 0 : list.size()];
                        int i = 0;
                        while (i < search.length) {
                            ICode d = (ICode)list.get(i);
                            search[i] = CodeSearchComposite.this.newSearchItem(d);
                            ++i;
                        }
                        CodeSearchComposite.this.loadSearchListInTable(search);
                        CodeSearchComposite.this.callbackContainerReferenceControl(list);
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Failed to load resonse list " + new JoinList("\n", (Collection)list), e);
                }
            }
        });
    }

    protected void createTableColumns() {
        this.tblSearch.setLinesVisible(true);
        this.tblSearch.setHeaderVisible(false);
        this.tableColumns = new ArrayList();
        SearchColumn<ICode> sc = new SearchColumn<ICode>((Table)this.tblSearch, "Code"){

            @Override
            public String getText(ICode e) {
                return e.getCode();
            }
        };
        sc.getColumn().setData("maxWidth", (Object)150);
        this.tableColumns.add(sc);
        sc = new SearchColumn<ICode>((Table)this.tblSearch, ""){

            @Override
            public String getText(ICode e) {
                if (e instanceof XCode) {
                    return StringUtils.abbreviateToWord((String)((XCode)e).getDescriptionLong(), (int)60);
                }
                if (e instanceof XLabType) {
                    return ((XLabType)e).getInterval();
                }
                return e.getDescription();
            }
        };
        this.tableColumns.add(sc);
        sc = new SearchColumn<ICode>((Table)this.tblSearch, ""){

            @Override
            public String getText(ICode e) {
                if (e instanceof XLabType) {
                    return ((XLabType)e).getUnit();
                }
                if (e instanceof XNBServiceCode) {
                    XNBServiceCode code = (XNBServiceCode)e;
                    return String.valueOf(code.getStartDate() == null ? "" : code.getStartDate().formatSlash()) + " <-> " + (code.getEndDate() == null ? "" : code.getEndDate().formatSlash());
                }
                if (e instanceof XCode) {
                    return "";
                }
                return "";
            }
        };
        this.tableColumns.add(sc);
    }

    @Override
    protected void createNew() {
        throw new UnsupportedOperationException();
    }

    public void setClassificationChoices(XCodeClassification ... classifications) {
        this.cmbClassification.setItems((XCodeClassification[])classifications);
    }

    public void setClassification(XCodeClassification classification, boolean userCanChangeSelection) {
        if (classification == null) {
            classification = XCodeClassification.CIM10;
        }
        if (XCodeClassification.CCI.equals((Object)classification)) {
            this.lblDescDiagnostic.setText(this.MOT_CODE.substring(0, this.MOT_CODE.indexOf(44)));
        }
        this.cmbClassification.select(classification);
        this.cmbClassification.setEnabled(userCanChangeSelection);
    }

    public void showVisitReasonsOnly() {
        this.setClassification(XCodeClassification.ICPC2, false);
        this.visitReasonMode = true;
    }

    @Override
    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    @Override
    protected String getPreferencesKeys() {
        return null;
    }
}

