/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import org.eclipse.jetty.util.resource.Resource;

public class FileResource2
extends Resource {
    private File file;

    public FileResource2(File file) throws IOException, URISyntaxException {
        this.file = file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public long length() {
        return this.file.length();
    }

    public String getName() {
        return this.file.getAbsolutePath();
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return new FileOutputStream(this.file);
    }

    public boolean delete() throws SecurityException {
        return this.file.delete();
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource2) {
            return this.file.renameTo(((FileResource2)dest).file);
        }
        return false;
    }

    public String[] list() {
        String[] list = this.file.list();
        if (list == null) {
            return null;
        }
        int i = list.length;
        while (i-- > 0) {
            if (!new File(this.file, list[i]).isDirectory() || list[i].endsWith("/")) continue;
            int n = i;
            list[n] = String.valueOf(list[n]) + "/";
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof FileResource2)) {
            return false;
        }
        FileResource2 f = (FileResource2)((Object)o);
        return f.file == this.file || this.file != null && this.file.equals(f.file);
    }

    public int hashCode() {
        return this.file == null ? super.hashCode() : this.file.hashCode();
    }

    public URL getURL() {
        return null;
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        return null;
    }

    public void close() {
    }

    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return null;
    }

    public boolean isContainedIn(Resource arg0) throws MalformedURLException {
        return false;
    }
}

