/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.test;

import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppointmentRobotController {
    private static final Logger logger = Logger.getLogger(AppointmentRobotController.class.getName());
    private AppointmentMainController appointmentMainController;
    private Random random;

    public AppointmentRobotController(AppointmentMainController appointmentMainController) {
        this.appointmentMainController = appointmentMainController;
        this.random = new Random();
    }

    public String run() {
        try {
            LocalDate date = this.appointmentMainController.getCurrentCalendarDate();
            if (date != null) {
                XAppointmentDate xdate = this.appointmentMainController.getAppointmentDate(date);
                ArrayList<IAppointment> appointments = new ArrayList<IAppointment>();
                for (IAppointment a : this.appointmentMainController.getAppointments(xdate)) {
                    if (Boolean.TRUE.equals(a.getIsDeleted())) continue;
                    appointments.add(a);
                }
                if (appointments.size() > 0) {
                    IAppointment a;
                    a = (IAppointment)appointments.get(this.random.nextInt(appointments.size()));
                    this.appointmentMainController.setCurrentAppointment(a);
                    XAppointmentStatus[] values = XAppointmentStatus.values();
                    XAppointmentStatus status = values[this.random.nextInt(values.length)];
                    this.appointmentMainController.setAppointmentStatus(a, status);
                    IStatus saveStatus = this.appointmentMainController.saveAll();
                    if (saveStatus.isOkToProceed()) {
                        return "Modified with success " + a;
                    }
                    return "Failed to modify " + a + ". Reason=" + saveStatus.getMessage();
                }
            }
            return "No appointment to modify ...";
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception in robot run", e);
            this.appointmentMainController.cancelAll();
            return "Exception in robot run " + e.getMessage();
        }
    }

    public AppointmentMainController getAppointmentMainController() {
        return this.appointmentMainController;
    }

    public void setAppointmentMainController(AppointmentMainController appointmentMainController) {
        this.appointmentMainController = appointmentMainController;
    }
}

