/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.menu.NewPatientRecallElement;
import ca.infodata.ofys.ui.appointment.menu.PatientRecallElement;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElementsPastille;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public final class ListPatientRecall
implements ITreeElements,
DataObjectNotificationHandler,
ITreeElementsPastille,
IFontProvider {
    private static final Logger logger = Logger.getLogger(ListPatientRecall.class.getName());
    private ITreeElements parent;
    private IPatient patient;
    private boolean isLoading;
    private ITreeElements[] children;
    private CopyOnWriteArrayList<XPatientRecall> recalls;
    public int childrenNumber = -1;

    public ListPatientRecall(ITreeElements parent, IPatient patient) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        this.parent = parent;
        this.patient = patient;
        this.getChildren();
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler((DataObjectNotificationHandler)this);
    }

    public Object[] getChildren() {
        if (this.notLoaded()) {
            this.fillAsLoading();
        }
        return this.children;
    }

    private void fillAsLoading() {
        this.isLoading = true;
        this.children = new ITreeElements[]{new NewPatientRecallElement(this, this.patient), new LoadingElement((ITreeElements)this)};
        this.findPatientRecalls();
    }

    private boolean notLoaded() {
        return this.children == null || this.isLoading;
    }

    private void findPatientRecalls() {
        JobCallback callback = new JobCallback(Messages.getString((String)"TROUVER_LES_RAPPELS", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                ArrayList obj = (ArrayList)response.getObj();
                if (obj == null) {
                    obj = new ArrayList(0);
                }
                ListPatientRecall.this.fill(obj);
            }
        };
        try {
            XPatientRecallSearchCriteria criteria = new XPatientRecallSearchCriteria();
            criteria.patientId = this.patient.getId();
            AppointmentAccessorClient.getInstance().findPatientRecall(Application.get().getGlobalInstances().getSession(), (ICallback)callback, criteria);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fill(new ArrayList<XPatientRecall>(0));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            if (callback != null && !callback.killed()) {
                callback.kill();
            }
            this.fill(new ArrayList<XPatientRecall>(0));
        }
    }

    private void fill(List<XPatientRecall> recalls) {
        this.recalls = new CopyOnWriteArrayList<XPatientRecall>(recalls);
        Collections.sort(recalls, AppointmentPlugin.getDefault().getXRecallComparator(true));
        ArrayList<Object> listChild = new ArrayList<Object>(recalls.size() + 2);
        listChild.add(new NewPatientRecallElement(this, this.patient));
        for (XPatientRecall recall : recalls) {
            recall.patient = this.patient;
            PatientRecallElement e = new PatientRecallElement(this, recall);
            e.setShowPatientName(false);
            listChild.add(e);
        }
        this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        this.isLoading = false;
        this.childrenNumber = this.children.length - 1;
        DossierPlugin.getDefault().refreshTree((ITreeElements)this);
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return Messages.getString((String)"RAPPELS", (String[])new String[0]);
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/alarmclock22.png");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListPatientRecall && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void handle(DataObjectUpdatedNotification notification) {
        XPatientRecall recall;
        IDataObject object = notification.getObject();
        if (object instanceof XPatientRecall && this.patient.equals((recall = (XPatientRecall)object).getPatient()) && this.recalls != null && !this.recalls.contains(recall)) {
            this.children = null;
            DossierPlugin.getDefault().refreshTree((ITreeElements)this);
        }
    }

    public int getChildrenNumberForPastille() {
        return this.childrenNumber;
    }

    public Color getPastilleColor() {
        return ResourceGetter.getColor((RGB)ResourceGetter.GREEN_WARNING_COLOR);
    }

    public Font getFont(Object element) {
        return ResourceGetter.getFontNormal();
    }
}

