/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.preferences;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.ui.appointment.editor.preferences.AppointmentPeriodTypeControl;
import ca.infodata.ofys.ui.appointment.editor.preferences.AppointmentTypeListRow;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.ResourceGetter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miginfocom.swt.MigLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class AppointmentPeriodTypeList
extends Composite {
    private static final String FRANCAIS = Messages.getString((String)"FRANCAIS", (String[])new String[0]);
    private static final String ENGLISH = Messages.getString((String)"ENGLISH", (String[])new String[0]);
    private static final String CAN_HAVE_APPOINTMENT = Messages.getString((String)"PEUT_AVOIR_DES_RDV", (String[])new String[0]);
    private static final String CAN_HAVE_APPOINTMENT_TTT = Messages.getString((String)"PEUT_AVOIR_DES_RDV_TTT", (String[])new String[0]);
    private static final String ACTIF = Messages.getString((String)"ACTIF", (String[])new String[0]);
    private MyLabel lblColor;
    private MyLabel lblCanHaveAppointment;
    private MyLabel lblFrench;
    private MyLabel lblEnglish;
    private MyLabel lblCode;
    private MyLabel lblActive;
    private MyButton btnAddPeriodType;
    private LinkedHashMap<XAppointmentPeriodType, AppointmentPeriodTypeControl> items;
    private final FormToolkit toolkit;
    private Image btnAddPeriodTypeImage;
    private final IBaseEditor editor;

    public AppointmentPeriodTypeList(IBaseEditor editor, Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (toolkit == null) {
            throw new NullPointerException("toolkit");
        }
        this.editor = editor;
        this.toolkit = toolkit;
        this.items = new LinkedHashMap();
        this.lblColor = new MyLabel((Composite)this, "", 0, toolkit);
        this.lblColor.setFont(0, 1);
        this.lblCanHaveAppointment = new MyLabel((Composite)this, CAN_HAVE_APPOINTMENT, 0, toolkit);
        this.lblCanHaveAppointment.setToolTipText(CAN_HAVE_APPOINTMENT_TTT);
        this.lblCanHaveAppointment.setFont(0, 1);
        this.lblCode = new MyLabel((Composite)this, AppointmentTypeListRow.CODE, 0, toolkit);
        this.lblCode.setFont(0, 1);
        this.lblFrench = new MyLabel((Composite)this, FRANCAIS, 0, toolkit);
        this.lblFrench.setFont(0, 1);
        this.lblEnglish = new MyLabel((Composite)this, ENGLISH, 0, toolkit);
        this.lblEnglish.setFont(0, 1);
        this.lblActive = new MyLabel((Composite)this, ACTIF, 0, toolkit);
        this.lblActive.setFont(0, 1);
        this.btnAddPeriodType = new MyButton((Composite)this, null, 0, toolkit);
        this.btnAddPeriodTypeImage = ResourceGetter.getImage((String)"images/nouveau.gif");
        this.btnAddPeriodType.setImage(this.btnAddPeriodTypeImage);
        this.btnAddPeriodType.setToolTipText(Messages.getString((String)"APPOINTEMENT.BTN_AJOUTER", (String[])new String[0]));
        this.btnAddPeriodType.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)editor, 13){

            public void edited(Event e) {
                XAppointmentPeriodType type = AppointmentPeriodTypeList.this.getNewXAppointmentPeriodType();
                if (type != null) {
                    AppointmentPeriodTypeList.this.items.put(type, AppointmentPeriodTypeList.this.addNewTypeControl(null, type));
                    AppointmentPeriodTypeList.this.layoutChanged();
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)AppointmentPeriodTypeList.this.btnAddPeriodTypeImage);
            }
        });
        this.setLayoutData("grow");
        this.setLayout((Layout)new MigLayout("fillx, gapy 5, hidemode 3", "[15!]15[min:pref:30]15[]15[]15[]15[]15[min:pref:30]15[center, 30!]"));
        this.lblColor.setLayoutData((Object)"cell 0 0, c");
        this.lblCanHaveAppointment.setLayoutData((Object)"cell 1 0, c");
        this.lblCode.setLayoutData((Object)"cell 2 0, c");
        this.lblFrench.setLayoutData((Object)"cell 3 0, c");
        this.lblEnglish.setLayoutData((Object)"cell 4 0, c");
        this.lblActive.setLayoutData((Object)"cell 6 0, c");
        this.btnAddPeriodType.setLayoutData((Object)"cell 6 0, w 24!, h 24!, c");
        toolkit.adapt((Composite)this);
    }

    public final void setTypes(List<XAppointmentPeriodType> types) {
        if (types == null) {
            throw new NullPointerException("types");
        }
        for (AppointmentPeriodTypeControl control : this.items.values()) {
            control.dispose();
        }
        this.items.clear();
        for (XAppointmentPeriodType type : types) {
            this.items.put(type, this.addNewTypeControl(null, type));
        }
        this.layoutChanged();
    }

    public final void showDataObject() {
        for (Map.Entry<XAppointmentPeriodType, AppointmentPeriodTypeControl> item : this.items.entrySet()) {
            item.getValue().showDataObject();
        }
    }

    private AppointmentPeriodTypeControl addNewTypeControl(AppointmentPeriodTypeControl reusableControl, XAppointmentPeriodType type) {
        final AppointmentPeriodTypeControl control = reusableControl != null ? reusableControl : new AppointmentPeriodTypeControl(this.editor, this, -1, this.toolkit);
        control.setType(type);
        this.setTypeControlLayout(control, this.items.size() + 1);
        control.getBtnDelete().addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.editor, 13){

            public void edited(Event e) {
                if (!control.ignore && (control.getType() == null || control.getType().isStatusDeleted() || control.getType().isNonExisting())) {
                    AppointmentPeriodTypeList.this.removeTypeControl(control.getType());
                }
            }
        });
        return control;
    }

    public void layoutChanged() {
        this.toolkit.adapt((Composite)this);
        this.reflow();
    }

    protected void reflow() {
        AppointmentPeriodTypeList c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    private void removeTypeControl(XAppointmentPeriodType type) {
        this.deleteXAppointmentPeriodType(type);
        AppointmentPeriodTypeControl control = (AppointmentPeriodTypeControl)((Object)this.items.remove(type));
        if (control != null) {
            control.dispose();
        }
        int i = 1;
        for (Map.Entry<XAppointmentPeriodType, AppointmentPeriodTypeControl> item : this.items.entrySet()) {
            this.setTypeControlLayout(item.getValue(), i);
            ++i;
        }
        this.layoutChanged();
    }

    private void setTypeControlLayout(AppointmentPeriodTypeControl control, int irow) {
        String row = String.valueOf(irow);
        control.getCvsColor().setLayoutData((Object)"cell 0 row, w 15!, h 15!, shp 30, c".replaceFirst("row", row));
        control.getBtnCanHaveAppointment().setLayoutData((Object)"cell 1 row, shp 30, c".replaceFirst("row", row));
        control.getCode().setLayoutData((Object)"cell 2 row, shp 30, growx".replaceFirst("row", row));
        control.getFrench().setLayoutData((Object)"cell 3 row, shp 30, growx".replaceFirst("row", row));
        control.getEnglish().setLayoutData((Object)"cell 4 row, shp 30, growx".replaceFirst("row", row));
        control.getChkActive().setLayoutData((Object)"cell 6 row, shp 30, c".replaceFirst("row", row));
        control.getBtnDelete().setLayoutData((Object)"cell 6 row, w 24!, h 24!, shp 30, c".replaceFirst("row", row));
    }

    protected abstract void deleteXAppointmentPeriodType(XAppointmentPeriodType var1);

    protected abstract XAppointmentPeriodType getNewXAppointmentPeriodType();

    public void dispose() {
        super.dispose();
        for (AppointmentPeriodTypeControl control : this.items.values()) {
            control.dispose();
        }
    }
}

