/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.multiprof;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class MultiProfInput
implements IEditorInput {
    private Set<XBaseProfessionnal> professionnals = new LinkedHashSet<XBaseProfessionnal>();
    private LocalDate date = LocalDate.today();

    public void addProf(Collection<XBaseProfessionnal> c) {
        this.professionnals.addAll(c);
        this.setPreferencesAppointment();
    }

    public boolean addProf(XBaseProfessionnal e) {
        boolean added = this.professionnals.add(e);
        this.setPreferencesAppointment();
        return added;
    }

    public boolean removeProf(XBaseProfessionnal e) {
        boolean removed = this.professionnals.remove(e);
        this.setPreferencesAppointment();
        return removed;
    }

    public List<XBaseProfessionnal> getProfessionnals() {
        return new ArrayList<XBaseProfessionnal>(this.professionnals);
    }

    public boolean hasProf(XBaseProfessionnal e) {
        return this.professionnals.contains(e);
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        this.date = date;
    }

    private void setPreferencesAppointment() {
        String st = "";
        for (XBaseProfessionnal xbp : this.professionnals) {
            if (xbp == null || xbp.getId() == null) continue;
            st = String.valueOf(st) + ";" + xbp.getId();
        }
        if (st.length() > 0) {
            st = st.substring(1);
        }
        PreferencesSettings.getInstance().put("appointment/last-opened-editor-type", "multi-prof");
        PreferencesSettings.getInstance().put("appointment/multi-prof-input", st);
        PreferencesSettings.getInstance().save();
    }

    public Object getAdapter(Class arg0) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return "Vue multi-professionnels des rendez-vous";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "Vue multi-professionnels des rendez-vous";
    }

    public String toString() {
        return "MultiProfInput [professionnals=" + this.professionnals + ", date=" + this.date + "]";
    }
}

