/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.model2;

import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.util1.ConcurrentHashSet;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class XAppointmentTable {
    private static final Logger logger = Logger.getLogger(XAppointmentTable.class.getName());
    private SetValuedMap<Pair<Integer, LocalDate>, XAppointment> appointmentByProfDate = new HashSetValuedHashMap();
    private HashMap<Integer, XAppointment> appointmentById;
    private ConcurrentHashSet<XAppointment> appointmentSet = new ConcurrentHashSet(1000, 8);

    public XAppointmentTable() {
        this.appointmentById = new HashMap(1000);
    }

    private void validNotCorrupted(String context, Collection<XAppointment> c) {
        for (XAppointment a : c) {
            if (a == null) {
                logger.severe(String.valueOf(context) + " XAppointmentTable.corruption appointment is null");
                break;
            }
            if (a.getId() == null) {
                logger.severe(String.valueOf(context) + " XAppointmentTable.corruption appointment.id is null " + a);
                break;
            }
            if (!a.isDirty()) continue;
            logger.severe(String.valueOf(context) + " XAppointmentTable.corruption appointment.isDirty == true " + a);
            break;
        }
    }

    public synchronized IEditableDataObjectList<XAppointment> get(Integer idProf, LocalDate date) {
        Pair key = Pair.newPair((Object)idProf, (Object)date);
        Set c = this.appointmentByProfDate.get((Object)key);
        if (c == null) {
            return EditableDataObjectList.emptyList();
        }
        EditableDataObjectList list = new EditableDataObjectList((Collection)c);
        return list;
    }

    public synchronized boolean add(XAppointment appointment) {
        if (appointment == null) {
            return false;
        }
        this.validNotCorrupted("add", Arrays.asList(appointment));
        boolean b = this.appointmentSet.add((Object)appointment);
        if (b) {
            for (Integer idProf : appointment.getIdProfessionals()) {
                Pair key = Pair.newPair((Object)idProf, (Object)appointment.getDate());
                this.appointmentByProfDate.put((Object)key, (Object)appointment);
            }
            this.appointmentById.put(appointment.getId(), appointment);
        }
        return b;
    }

    public synchronized void addAll(Collection<XAppointment> c) {
        if (c != null) {
            for (XAppointment a : c) {
                this.add(a);
            }
        }
    }

    public synchronized boolean replace(XAppointment appointment) {
        if (appointment == null) {
            return false;
        }
        this.remove(appointment);
        return this.add(appointment);
    }

    private synchronized void remove(XAppointment appointment) {
        if (appointment == null) {
            return;
        }
        XAppointment removedAppt = this.appointmentById.remove(appointment.getId());
        if (removedAppt != null) {
            this.appointmentSet.remove((Object)removedAppt);
            for (Integer ii : removedAppt.getIdProfessionals()) {
                Pair key = Pair.newPair((Object)ii, (Object)removedAppt.getDate());
                this.appointmentByProfDate.get((Object)key).remove(removedAppt);
            }
        }
    }

    public synchronized void remove(Integer idProf, LocalDate date) {
        Pair key = Pair.newPair((Object)idProf, (Object)date);
        Set c = this.appointmentByProfDate.get((Object)key);
        this.appointmentByProfDate.remove((Object)key);
        if (c != null) {
            for (XAppointment a : c) {
                this.appointmentSet.remove((Object)a);
                this.appointmentById.remove(a.getId());
            }
        }
    }

    public synchronized Collection<XAppointment> getAll() {
        return this.appointmentSet;
    }

    public synchronized XAppointment get(Integer id) {
        return this.appointmentById.get(id);
    }

    public synchronized void clear() {
        this.appointmentById.clear();
        this.appointmentByProfDate.clear();
        this.appointmentSet.clear();
    }
}

