/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.dnd.DayTransfert;
import ca.infodata.ofys.ui.controls.dnd.WeekTransfert;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TouchEvent;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ScheduleControl
extends Composite
implements IObjectListener<Object> {
    private static final ProviderAR<XAppointmentDateTemplate, String[]> dayLabelProvider = new ProviderAR<XAppointmentDateTemplate, String[]>(){

        public String[] get(XAppointmentDateTemplate day) {
            if (Application.get().getGlobalInstances().inDebugMode()) {
                return new String[]{day.getId() + " " + day.getNote()};
            }
            return new String[]{day.getNote()};
        }
    };
    private static final ProviderAR<XAppointmentWeekTemplate, String[]> weekLabelProvider = new ProviderAR<XAppointmentWeekTemplate, String[]>(){

        public String[] get(XAppointmentWeekTemplate week) {
            if (Application.get().getGlobalInstances().inDebugMode()) {
                return new String[]{week.getId() + " " + week.getNote()};
            }
            return new String[]{week.getNote()};
        }
    };
    private FontAwareTable tblWeeks;
    private FontAwareTable tblDays;
    private MyButton btnNewDay;
    private MyButton btnDeleteDay;
    private MyButton btnNewWeek;
    private MyButton btnDeleteWeek;
    private XAppointmentDateTemplate internal_dateTemplate;
    private XAppointmentWeekTemplate internal_weekTemplate;

    public ScheduleControl(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.createMyControl(this, toolkit);
    }

    private void createMyControl(Composite parent, FormToolkit toolkit) {
        this.btnNewWeek = new MyButton(parent, Messages.getString((String)"NOUVEAU", (String[])new String[0]), 8, toolkit);
        this.btnDeleteWeek = new MyButton(parent, Messages.getString((String)"RETIRER", (String[])new String[0]), 8, toolkit);
        MyLabel lblWeeks = new MyLabel(parent, Messages.getString((String)"SEMAINES", (String[])new String[0]), 0, toolkit);
        lblWeeks.setFont(3, 0);
        this.tblWeeks = new FontAwareTable(parent, 67586, toolkit);
        this.btnNewDay = new MyButton(parent, Messages.getString((String)"NOUVEAU", (String[])new String[0]), 8, toolkit);
        this.btnDeleteDay = new MyButton(parent, Messages.getString((String)"RETIRER", (String[])new String[0]), 8, toolkit);
        MyLabel lblDays = new MyLabel(parent, Messages.getString((String)"JOURS", (String[])new String[0]), 0, toolkit);
        lblDays.setFont(3, 0);
        this.tblDays = new FontAwareTable(parent, 67586);
        this.btnNewWeek.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XAppointmentWeekTemplate week = ScheduleControl.this.createNewAppointmentWeekTemplate();
                ScheduleControl.this.internal_weekTemplate = week;
                ScheduleControl.this.refresh();
                ScheduleControl.this.weekTemplateChanged(week);
            }
        });
        this.btnDeleteWeek.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ScheduleControl.this.tblWeeks.getSelectionIndex();
                ScheduleControl.this.deleteWeekSelected();
                if (ScheduleControl.this.tblWeeks.getItemCount() > 0) {
                    if (ScheduleControl.this.tblWeeks.getItemCount() > selectionIndex) {
                        ScheduleControl.this.tblWeeks.select(selectionIndex);
                    } else {
                        ScheduleControl.this.tblWeeks.select(ScheduleControl.this.tblWeeks.getItemCount() - 1);
                    }
                }
            }
        });
        this.tblWeeks.addTouchListener(new TouchListener(){

            public void touch(TouchEvent e) {
                ScheduleControl.this.tblWeeks.notifyListeners(8, UI.toEvent((TouchEvent)e));
            }
        });
        this.tblWeeks.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ScheduleControl.this.tblWeeks.getSelectionCount() > 0) {
                    ScheduleControl.this.tblDays.deselectAll();
                    XAppointmentWeekTemplate week = (XAppointmentWeekTemplate)ScheduleControl.this.tblWeeks.getSelection()[0].getData();
                    ScheduleControl.this.internal_weekTemplate = week;
                    ScheduleControl.this.weekTemplateChanged(week);
                }
            }
        });
        this.btnNewDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XAppointmentDateTemplate day = ScheduleControl.this.createNewAppointmentDateTemplate();
                ScheduleControl.this.internal_dateTemplate = day;
                ScheduleControl.this.refresh();
                ScheduleControl.this.dateTemplateChanged(day);
            }
        });
        this.btnDeleteDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ScheduleControl.this.tblDays.getSelectionIndex();
                ScheduleControl.this.deleteDaySelected();
                if (ScheduleControl.this.tblDays.getItemCount() > 0) {
                    if (ScheduleControl.this.tblDays.getItemCount() > selectionIndex) {
                        ScheduleControl.this.tblDays.select(selectionIndex);
                    } else {
                        ScheduleControl.this.tblDays.select(ScheduleControl.this.tblDays.getItemCount() - 1);
                    }
                }
            }
        });
        this.tblDays.addTouchListener(new TouchListener(){

            public void touch(TouchEvent e) {
                ScheduleControl.this.tblDays.notifyListeners(8, UI.toEvent((TouchEvent)e));
            }
        });
        this.tblDays.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ScheduleControl.this.tblDays.getSelectionCount() > 0) {
                    ScheduleControl.this.tblWeeks.deselectAll();
                    XAppointmentDateTemplate day = (XAppointmentDateTemplate)ScheduleControl.this.tblDays.getSelection()[0].getData();
                    ScheduleControl.this.internal_dateTemplate = day;
                    ScheduleControl.this.dateTemplateChanged(day);
                }
            }
        });
        DragSource source = new DragSource((Control)this.tblDays, 19);
        source.setTransfer(new Transfer[]{DayTransfert.getInstance()});
        source.addDragListener(new DragSourceListener(){
            private XAppointmentDateTemplate selection;

            public void dragStart(DragSourceEvent event) {
                List<XAppointmentDateTemplate> selection = ScheduleControl.this.getAppointmentDateTemplateSelection();
                if (selection.size() > 0) {
                    event.doit = true;
                    this.selection = selection.get(0);
                } else {
                    event.doit = false;
                    this.selection = null;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (DayTransfert.getInstance().isSupportedType(event.dataType) && this.selection != null) {
                    String key = String.valueOf(this.selection.hashCode());
                    DayTransfert.getInstance().put(key, (Object)this.selection);
                    event.data = key;
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        source = new DragSource((Control)this.tblWeeks, 19);
        source.setTransfer(new Transfer[]{WeekTransfert.getInstance()});
        source.addDragListener(new DragSourceListener(){
            private XAppointmentWeekTemplate selection;

            public void dragStart(DragSourceEvent event) {
                List<XAppointmentWeekTemplate> selection = ScheduleControl.this.getAppointmentWeekTemplateSelection();
                if (selection.size() > 0) {
                    event.doit = true;
                    this.selection = selection.get(0);
                } else {
                    event.doit = false;
                    this.selection = null;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (WeekTransfert.getInstance().isSupportedType(event.dataType) && this.selection != null) {
                    String key = String.valueOf(this.selection.hashCode());
                    WeekTransfert.getInstance().put(key, (Object)this.selection);
                    event.data = key;
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = 90;
        this.btnNewWeek.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnNewWeek.getControl());
        data.width = 90;
        this.btnDeleteWeek.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnDeleteWeek.getControl());
        lblWeeks.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnNewWeek.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(50);
        this.tblWeeks.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tblWeeks);
        data.left = new FormAttachment(0);
        data.width = 90;
        this.btnNewDay.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tblWeeks);
        data.left = new FormAttachment(this.btnNewDay.getControl());
        data.width = 90;
        this.btnDeleteDay.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tblWeeks);
        data.left = new FormAttachment(this.btnDeleteDay.getControl());
        lblDays.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnNewDay.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.tblDays.setLayoutData((Object)data);
        toolkit.adapt((Composite)this);
        this.enable(true);
    }

    public void deselectAll() {
        this.tblWeeks.deselectAll();
        this.tblDays.deselectAll();
    }

    public void clearSelections() {
        this.tblDays.deselectAll();
        this.tblWeeks.deselectAll();
    }

    private void fillTableDay() {
        this.tblDays.clearAll();
        this.tblDays.setItemCount(0);
        EditableDataObjectList<XAppointmentDateTemplate> lstTemplates = this.getLstTemplates();
        Collections.sort(lstTemplates, new Comparator<XAppointmentDateTemplate>(){

            @Override
            public int compare(XAppointmentDateTemplate o1, XAppointmentDateTemplate o2) {
                return StringUtils.compareAscii((String)o1.getNote(), (String)o2.getNote());
            }
        });
        for (XAppointmentDateTemplate date : lstTemplates) {
            TableItem item = new TableItem((Table)this.tblDays, 0);
            item.setText((String[])dayLabelProvider.get((Object)date));
            item.setData((Object)date);
            if (!date.equals((Object)this.internal_dateTemplate)) continue;
            this.internal_dateTemplate = date;
            this.tblDays.setSelection(item);
        }
        if (!lstTemplates.contains(this.internal_dateTemplate)) {
            this.internal_dateTemplate = null;
        }
    }

    private void fillTableWeek() {
        this.tblWeeks.clearAll();
        this.tblWeeks.setItemCount(0);
        EditableDataObjectList<XAppointmentWeekTemplate> lstWeekTemplates = this.getLstWeekTemplates();
        Collections.sort(lstWeekTemplates, new Comparator<XAppointmentWeekTemplate>(){

            @Override
            public int compare(XAppointmentWeekTemplate o1, XAppointmentWeekTemplate o2) {
                return StringUtils.compareAscii((String)o1.getNote(), (String)o2.getNote());
            }
        });
        for (XAppointmentWeekTemplate week : lstWeekTemplates) {
            TableItem item = new TableItem((Table)this.tblWeeks, 0);
            item.setText((String[])weekLabelProvider.get((Object)week));
            item.setData((Object)week);
            if (!week.equals((Object)this.internal_weekTemplate)) continue;
            this.internal_weekTemplate = week;
            this.tblWeeks.setSelection(item);
        }
        if (!lstWeekTemplates.contains(this.internal_weekTemplate)) {
            this.internal_weekTemplate = null;
        }
    }

    private void enable(boolean enable) {
        this.tblDays.setEnabled(enable);
        this.tblWeeks.setEnabled(enable);
        this.btnDeleteDay.setEnabled(enable);
        this.btnNewDay.setEnabled(enable);
        this.btnDeleteWeek.setEnabled(enable);
        this.btnNewWeek.setEnabled(enable);
    }

    private void clearAll() {
        this.internal_dateTemplate = null;
        this.internal_weekTemplate = null;
        if (!this.isDisposed()) {
            this.tblDays.clearAll();
            this.tblWeeks.clearAll();
        }
    }

    private void deleteDaySelected() {
        int[] selectionIndices = this.tblDays.getSelectionIndices();
        if (selectionIndices != null && selectionIndices.length > 0) {
            ArrayList<XAppointmentDateTemplate> templates = new ArrayList<XAppointmentDateTemplate>(selectionIndices.length);
            int[] nArray = selectionIndices;
            int n = selectionIndices.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                templates.add((XAppointmentDateTemplate)this.tblDays.getItem(i).getData());
                ++n2;
            }
            for (XAppointmentDateTemplate t : templates) {
                this.deleteDateTemplate(t);
            }
            this.refresh();
        }
    }

    private void deleteWeekSelected() {
        int[] selectionIndices = this.tblWeeks.getSelectionIndices();
        if (selectionIndices != null && selectionIndices.length > 0) {
            ArrayList<XAppointmentWeekTemplate> weeks = new ArrayList<XAppointmentWeekTemplate>(selectionIndices.length);
            int[] nArray = selectionIndices;
            int n = selectionIndices.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                weeks.add((XAppointmentWeekTemplate)this.tblWeeks.getItem(i).getData());
                ++n2;
            }
            for (XAppointmentWeekTemplate w : weeks) {
                this.deleteWeekTemplate(w);
            }
            this.refresh();
        }
    }

    private final TableItem getTableItem(Table table, Object data) {
        TableItem[] items;
        if (data == null) {
            return null;
        }
        TableItem[] tableItemArray = items = table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (data.equals(item.getData())) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public void dispose() {
        this.clearAll();
        super.dispose();
    }

    public void refresh() {
        this.fillTableDay();
        this.fillTableWeek();
    }

    protected abstract void dateTemplateChanged(XAppointmentDateTemplate var1);

    protected abstract void weekTemplateChanged(XAppointmentWeekTemplate var1);

    protected abstract XAppointmentWeekTemplate createNewAppointmentWeekTemplate();

    protected abstract XAppointmentDateTemplate createNewAppointmentDateTemplate();

    protected abstract EditableDataObjectList<XAppointmentDateTemplate> getLstTemplates();

    protected abstract EditableDataObjectList<XAppointmentWeekTemplate> getLstWeekTemplates();

    protected abstract void deleteDateTemplate(XAppointmentDateTemplate var1);

    protected abstract void deleteWeekTemplate(XAppointmentWeekTemplate var1);

    protected List<XAppointmentDateTemplate> getAppointmentDateTemplateSelection() {
        TableItem[] selection = this.tblDays.getSelection();
        if (selection != null) {
            EditableDataObjectList<XAppointmentDateTemplate> lstTemplates = this.getLstTemplates();
            ArrayList<XAppointmentDateTemplate> list = new ArrayList<XAppointmentDateTemplate>(selection.length);
            int i = 0;
            while (i < selection.length) {
                int index = lstTemplates.indexOfByTag((IMinimalEditableDataObject)((XAppointmentDateTemplate)selection[i].getData()));
                if (index >= 0) {
                    list.add((XAppointmentDateTemplate)lstTemplates.get(index));
                }
                ++i;
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected List<XAppointmentWeekTemplate> getAppointmentWeekTemplateSelection() {
        TableItem[] selection = this.tblWeeks.getSelection();
        if (selection != null) {
            EditableDataObjectList<XAppointmentWeekTemplate> lstTemplates = this.getLstWeekTemplates();
            ArrayList<XAppointmentWeekTemplate> list = new ArrayList<XAppointmentWeekTemplate>(selection.length);
            int i = 0;
            while (i < selection.length) {
                int index = lstTemplates.indexOfByTag((IMinimalEditableDataObject)((XAppointmentWeekTemplate)selection[i].getData()));
                if (index >= 0) {
                    list.add((XAppointmentWeekTemplate)lstTemplates.get(index));
                }
                ++i;
            }
            return list;
        }
        return Collections.emptyList();
    }

    public void objectModified(Object object) {
        TableItem item;
        if (MiscUtil.areObjectsEquals((Object)object, (Object)this.internal_dateTemplate)) {
            TableItem item2 = this.getTableItem((Table)this.tblDays, this.internal_dateTemplate);
            if (item2 != null) {
                item2.setText((String[])dayLabelProvider.get((Object)((XAppointmentDateTemplate)object)));
            }
        } else if (MiscUtil.areObjectsEquals((Object)object, (Object)this.internal_weekTemplate) && (item = this.getTableItem((Table)this.tblWeeks, this.internal_weekTemplate)) != null) {
            item.setText((String[])weekLabelProvider.get((Object)((XAppointmentWeekTemplate)object)));
        }
    }
}

