/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;

public class AppointmentVisualStructureTimeManager {
    protected int startTimeMinute = -1;
    protected int endTimeMinute = -1;

    public int getStartHour(AppointmentVisualStructure vs) {
        int n = Integer.MAX_VALUE;
        n = Math.min(vs.getAppointmentDateTemplate().getStartHour() * 60, n);
        for (IAppointment iAppointment : vs.getAppointments()) {
            if (iAppointment.getPatientStatus() == XPatientStatus.CANCEL || iAppointment.getPatientStatus() == XPatientStatus.CANCEL_LESS_24H) {
                if (!vs.isShowCanceledAppointment()) continue;
                n = Math.min(iAppointment.getStartTime().shortValue(), n);
                continue;
            }
            if (Boolean.TRUE.equals(iAppointment.getIsDeleted())) {
                if (!vs.isShowDeletedAppointment()) continue;
                n = Math.min(iAppointment.getStartTime().shortValue(), n);
                continue;
            }
            n = Math.min(iAppointment.getStartTime().shortValue(), n);
        }
        for (XAppointmentPeriod xAppointmentPeriod : vs.getAppointmentDateTemplate().getPeriods().getNotDeleted()) {
            n = Math.min(xAppointmentPeriod.getStartTime(), n);
        }
        return n / 60;
    }

    public int getStartTimeMinute(AppointmentVisualStructure vs) {
        if (this.startTimeMinute == -1) {
            this.startTimeMinute = this.getStartHour(vs) * 60;
        }
        return this.startTimeMinute;
    }

    public int getEndHour(AppointmentVisualStructure vs) {
        int n = Integer.MIN_VALUE;
        n = Math.max(vs.getAppointmentDateTemplate().getEndHour() * 60, n);
        for (IAppointment iAppointment : vs.getAppointments()) {
            if (iAppointment.getPatientStatus() == XPatientStatus.CANCEL || iAppointment.getPatientStatus() == XPatientStatus.CANCEL_LESS_24H) {
                if (!vs.isShowCanceledAppointment()) continue;
                n = Math.max(iAppointment.getEndTime().shortValue(), n);
                continue;
            }
            if (Boolean.TRUE.equals(iAppointment.getIsDeleted())) {
                if (!vs.isShowDeletedAppointment()) continue;
                n = Math.max(iAppointment.getEndTime().shortValue(), n);
                continue;
            }
            n = Math.max(iAppointment.getEndTime().shortValue(), n);
        }
        for (XAppointmentPeriod xAppointmentPeriod : vs.getAppointmentDateTemplate().getPeriods().getNotDeleted()) {
            n = Math.max(xAppointmentPeriod.getEndTime(), n);
        }
        return n % 60 == 0 ? n / 60 : n / 60 + 1;
    }

    public int getEndTimeMinute(AppointmentVisualStructure vs) {
        if (this.endTimeMinute == -1) {
            this.endTimeMinute = this.getEndHour(vs) * 60;
        }
        return this.endTimeMinute;
    }

    public void clearCache() {
        this.startTimeMinute = -1;
        this.endTimeMinute = -1;
    }
}

