/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.util.math.NumberUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.logging.Logger;

public class AppointmentVisualStructureScaleManager {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructureScaleManager");
    private int internal_scale;

    public final int getScale(AppointmentVisualStructure vs) {
        vs.checkUsable();
        boolean triggerReset = this.internal_scale == 0;
        this.getScaleNoReset(vs);
        if (triggerReset) {
            vs.reset();
        }
        return this.internal_scale;
    }

    public void clearCache() {
        this.internal_scale = 0;
    }

    public final int getScaleNoReset(AppointmentVisualStructure vs) {
        if (this.internal_scale == 0) {
            this.internal_scale = this.computeScale(vs);
        }
        return this.internal_scale;
    }

    public int computeScale(AppointmentVisualStructure vs) {
        Short scale = null;
        XAppointmentDateTemplate template = vs.getAppointmentDateTemplate();
        XAppointmentDate date = vs.getAppointmentDate();
        if (date != null) {
            scale = this.computeScale(vs, date);
        } else if (template != null) {
            scale = this.computeScale(vs, template);
        }
        if (scale == null && template != null) {
            scale = template.getScale();
        }
        if (scale == null || scale.intValue() <= 0) {
            scale = 30;
            logger.warning("Using default scale of 30. was " + scale + ". for vs " + vs);
        }
        return scale.shortValue();
    }

    private Short computeScale(AppointmentVisualStructure vs, XAppointmentDate xdate) {
        Short scale = null;
        XAppointmentDateTemplate template = xdate.getDateTemplate();
        if (template != null) {
            Short templateScale;
            List appointments;
            IntArrayList lengthLst = new IntArrayList();
            Short templateScale2 = this.computeScale(vs, template);
            if (templateScale2 != null && templateScale2.intValue() != 0) {
                lengthLst.add((int)templateScale2.shortValue());
            }
            if ((appointments = vs.getContentProvider().getAppointments(xdate).getNotDeleted()) != null && !appointments.isEmpty()) {
                for (IAppointment appointment : appointments) {
                    Short time;
                    if (appointment == null || !vs.isShowDeletedAppointment() && Boolean.TRUE.equals(appointment.getIsDeleted()) || !vs.isShowCanceledAppointment() && (appointment.getPatientStatus() == XPatientStatus.CANCEL || appointment.getPatientStatus() == XPatientStatus.CANCEL_LESS_24H)) continue;
                    Integer length = appointment.getLength();
                    if (length != null && length != 0) {
                        lengthLst.add(length);
                    }
                    if ((time = appointment.getStartTime()) != null && time.intValue() != 0) {
                        lengthLst.add((int)time.shortValue());
                    }
                    if ((time = appointment.getEndTime()) == null || time.intValue() == 0) continue;
                    lengthLst.add((int)time.shortValue());
                }
            }
            if ((lengthLst.size() == 0 || templateScale2 == null) && (templateScale = template.getScale()) != null && templateScale.intValue() != 0) {
                lengthLst.add((int)templateScale.shortValue());
            }
            if (lengthLst.size() > 0) {
                scale = (short)NumberUtils.getGreatestCommonFactor((int[])lengthLst.toIntArray());
            }
        }
        return scale;
    }

    private Short computeScale(AppointmentVisualStructure vs, XAppointmentDateTemplate template) {
        List periods;
        Short scale = null;
        List list = periods = template.getPeriods() == null ? null : template.getPeriods().getNotDeleted();
        if (periods != null) {
            IntArrayList lengthLst = new IntArrayList(periods.size());
            Short hour = template.getStartHour();
            if (hour != null && hour.intValue() != 0) {
                lengthLst.add(hour * 60);
            }
            if ((hour = template.getEndHour()) != null && hour.intValue() != 0) {
                lengthLst.add(hour * 60);
            }
            if (!periods.isEmpty()) {
                for (XAppointmentPeriod period : periods) {
                    Integer time;
                    Integer sectionLength;
                    if (period == null) continue;
                    Integer length = period.getLength();
                    if (length != null && length != 0) {
                        lengthLst.add(length);
                    }
                    if ((sectionLength = period.getDefaultLength()) != null && sectionLength != 0) {
                        lengthLst.add(sectionLength);
                    }
                    if ((time = period.getStartTime()) != null && time != 0) {
                        lengthLst.add(time);
                    }
                    if ((time = period.getEndTime()) == null || time == 0) continue;
                    lengthLst.add(time);
                }
                scale = (short)NumberUtils.getGreatestCommonFactor((int[])lengthLst.toIntArray());
            }
        }
        return scale;
    }
}

