/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateDeGardeType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateMessageType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateStatistics2;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.control.AppointmentCalendarGridData;
import ca.infodata.ofys.ui.appointment.control.AppointmentDatePrintDialog;
import ca.infodata.ofys.ui.appointment.control.AppointmentTreeContentProvider;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.control.SendAppointmentsConfirmationDialog;
import ca.infodata.ofys.ui.appointment.control.StatisticCellRenderer;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditor;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditorInput;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.appointment.test.AppointmentRobotController;
import ca.infodata.ofys.ui.appointment.test.AppointmentRobotDialog;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlWrapper;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.calendar.grid.CalendarSelection;
import ca.infodata.ofys.ui.controls.calendar.grid.ICalendarGridData;
import ca.infodata.ofys.ui.controls.calendar.grid.SuperCalendarGrid;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.dnd.DayTransfert;
import ca.infodata.ofys.ui.controls.dnd.WeekTransfert;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.CellRenderer;
import ca.infodata.ofys.ui.controls.grid.CellRendererFactory;
import ca.infodata.ofys.ui.controls.util.IPreferenceListener;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.controls.windows.AbstractSingleInputWindows;
import ca.infodata.ofys.ui.controls.windows.TextInputDialog;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Predicate;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AppointmentCalendarGrid
implements IPreferenceListener,
IRefreshFont {
    private static final Logger logger = Logger.getLogger(AppointmentCalendarGrid.class.getName());
    private final SuperCalendarGrid calendar;
    private final StatisticCellRenderer statisticCellRenderer;
    private final AppointmentMainEditor editor;
    private AppointmentCalendarGridData calendarData;

    public AppointmentCalendarGrid(Composite parent, int style, final AppointmentMainEditor editor) {
        this.editor = editor;
        this.statisticCellRenderer = new StatisticCellRenderer();
        this.calendar = new SuperCalendarGrid(parent, style){

            public void setBackground(Color color) {
                super.setBackground(color);
                AppointmentCalendarGrid.this.setBackgroundOverride(color);
            }
        };
        this.calendar.getCellRendererFactory().unregisterCellRenderer("calendar");
        this.calendar.getCellRendererFactory().registerCellRenderer("calendar", (CellRenderer)this.statisticCellRenderer);
        this.calendar.setFixedCellWidth(false);
        this.calendar.setAutofocusPredicate(new Predicate(){

            public boolean evaluate() {
                return UI.hasFocus((IWorkbenchPart)editor);
            }
        });
        this.calendar.getCanvas().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                if (UI.hasFocus((IWorkbenchPart)editor)) {
                    AppointmentCalendarGrid.this.calendar.getCanvas().setFocus();
                }
            }
        });
        this.calendar.getCanvas().addMouseListener((MouseListener)new MouseAdapter(){
            boolean isValidForNormalLeftClick;

            public void mouseDown(MouseEvent e) {
                if (!AppointmentCalendarGrid.this.doit()) {
                    return;
                }
                if (UI.rightClick((MouseEvent)e) && AppointmentCalendarGrid.this.isMouseOnSelection(e)) {
                    AppointmentCalendarGrid.this.showContextMenu();
                }
                this.isValidForNormalLeftClick = UI.leftClick((MouseEvent)e);
            }

            public void mouseUp(MouseEvent e) {
                if (!AppointmentCalendarGrid.this.doit()) {
                    return;
                }
                if (this.isValidForNormalLeftClick) {
                    CalendarSelection selection = AppointmentCalendarGrid.this.calendar.getSelection();
                    if (selection.size() == 1) {
                        editor.setEditorStateTo_DATE((LocalDate)selection.first(), true);
                        AppointmentCalendarGrid.this.calendar.getCanvas().setFocus();
                    }
                    this.isValidForNormalLeftClick = false;
                }
            }
        });
        this.calendar.getCanvas().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CalendarSelection selection;
                if (!AppointmentCalendarGrid.this.doit()) {
                    return;
                }
                if (UI.CR((KeyEvent)e) && !(selection = AppointmentCalendarGrid.this.calendar.getSelection()).isEmpty()) {
                    editor.setEditorStateTo_DATE((LocalDate)selection.first(), true);
                }
            }
        });
        this.calendarData = new AppointmentCalendarGridData(this.getController());
        this.calendar.setData((ICalendarGridData)this.calendarData);
        SelectionAdapter buttonDateChangeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalendarSelection selection = AppointmentCalendarGrid.this.calendar.getSelection();
                if (selection.size() == 1) {
                    editor.setEditorStateTo_DATE((LocalDate)selection.first(), true);
                }
            }
        };
        this.calendar.getBtnToday().addSelectionListener((SelectionListener)buttonDateChangeListener);
        this.editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    AppointmentCalendarGrid.this.calendarData.setController(AppointmentCalendarGrid.this.getController());
                }
            }
        });
        DropTargetAdapter dropListener = new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 1;
                }
            }

            public void dragOver(DropTargetEvent event) {
                boolean draggingDay = DayTransfert.getInstance().isSupportedType(event.currentDataType);
                boolean draggingWeek = WeekTransfert.getInstance().isSupportedType(event.currentDataType);
                if (draggingDay || draggingWeek) {
                    event.feedback = 9;
                    Point mappedPoint = Display.getDefault().map(null, (Control)AppointmentCalendarGrid.this.calendar.getCanvas(), event.x, event.y);
                    LocalDate day = AppointmentCalendarGrid.this.calendar.getDateFromGCPoint(mappedPoint);
                    CalendarSelection selection = AppointmentCalendarGrid.this.calendar.getSelection();
                    if (draggingDay) {
                        if (day == null) {
                            selection.clear();
                            selection.finalizeSelection();
                        } else {
                            selection.clearAddAndFinalize((Object)day);
                        }
                    } else if (draggingWeek) {
                        if (day == null) {
                            selection.clear();
                            selection.finalizeSelection();
                        } else {
                            selection.clearAddWeekAndFinalize(day);
                        }
                    }
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 1;
                }
            }

            public void drop(DropTargetEvent event) {
                CalendarSelection selection;
                if (DayTransfert.getInstance().isSupportedType(event.currentDataType)) {
                    Point mappedPoint = Display.getDefault().map(null, (Control)AppointmentCalendarGrid.this.calendar.getCanvas(), event.x, event.y);
                    LocalDate day = AppointmentCalendarGrid.this.calendar.getDateFromGCPoint(mappedPoint);
                    if (day != null) {
                        XAppointmentDateTemplate dateTemplate = (XAppointmentDateTemplate)DayTransfert.getInstance().pop((String)event.data);
                        editor.assignDay(dateTemplate, day);
                        AppointmentCalendarGrid.this.calendar.redraw();
                    }
                } else if (WeekTransfert.getInstance().isSupportedType(event.currentDataType) && !(selection = AppointmentCalendarGrid.this.calendar.getSelection()).isEmpty()) {
                    XAppointmentWeekTemplate weekTemplate = (XAppointmentWeekTemplate)WeekTransfert.getInstance().pop((String)event.data);
                    editor.assignWeek(weekTemplate, (LocalDate)selection.first());
                    AppointmentCalendarGrid.this.calendar.redraw();
                }
            }
        };
        DropTarget target = new DropTarget((Control)this.calendar.getCanvas(), 17);
        target.setTransfer(new Transfer[]{DayTransfert.getInstance(), WeekTransfert.getInstance()});
        target.addDropListener((DropTargetListener)dropListener);
        PreferencesSettings.getInstance().addListener((IPreferenceListener)this);
        ResourceGetter.addListener((IRefreshFont)this);
    }

    private boolean isMouseOnSelection(MouseEvent e) {
        Point point = new Point(e.x, e.y);
        LocalDate day = this.calendar.getDateFromGCPoint(point);
        return day != null && this.calendar.getSelection().contains((Object)day);
    }

    private boolean doit() {
        return this.editor.getController().isUsable();
    }

    private void showContextMenu() {
        Collection<XBaseProfessionnal> lstProfessional;
        List workSites;
        if (!this.doit()) {
            return;
        }
        Menu menu = null;
        final CalendarSelection dates = this.calendar.getSelection();
        if (dates.size() <= 0) {
            return;
        }
        ArrayList<XBaseAppointmentDate> xdates = new ArrayList<XBaseAppointmentDate>(dates.size());
        for (LocalDate date : dates) {
            xdates.add(this.getController().getBaseAppointmentDate(date));
        }
        menu = new Menu((Control)this.calendar.getCanvas());
        XBaseProfessionnal currentProfessional = this.getController().getCurrentProfessional();
        if (currentProfessional != null) {
            MenuItem menu2 = new MenuItem(menu, 64);
            menu2.setText(Messages.getString((String)"ABSENCE(S)/MESSAGE", (String[])new String[0]));
            this.addAbsentMessageMenu(menu2, dates, xdates, Arrays.asList(currentProfessional));
        }
        if ((workSites = SitePlugin.getDefault().getWorkSites()).size() <= 1) {
            lstProfessional = this.getController().getLstProfessional();
            MenuItem menu3 = new MenuItem(menu, 64);
            menu3.setText(Messages.getString((String)"TOUS_LES_PROFESSIONNELS", (String[])new String[0]));
            this.addAbsentMessageMenu(menu3, dates, xdates, lstProfessional);
        } else {
            lstProfessional = new ArrayList<XBaseProfessionnal>(this.getController().getLstProfessional());
            XSite site = SitePlugin.getDefault().getContextSiteChecked();
            Iterator iterator = lstProfessional.iterator();
            while (iterator.hasNext()) {
                XBaseProfessionnal prof = (XBaseProfessionnal)iterator.next();
                if (prof.isAssociatedWithSite(site)) continue;
                iterator.remove();
            }
            MenuItem menu3 = new MenuItem(menu, 64);
            menu3.setText(String.valueOf(Messages.getString((String)"TOUS_LES_PROFESSIONNELS", (String[])new String[0])) + " (" + SitePlugin.getDefault().getContextSiteChecked().getNameCommon() + ")");
            this.addAbsentMessageMenu(menu3, dates, xdates, lstProfessional);
        }
        new MenuItem(menu, 2);
        if (currentProfessional != null) {
            MenuItem menu2 = new MenuItem(menu, 64);
            menu2.setText(Messages.getString((String)"DE_GARDE.MENU_TITRE", (String[])new String[0]));
            this.addAbsentDeGardeMenu(menu2, dates, xdates, Arrays.asList(currentProfessional));
        }
        new MenuItem(menu, 2);
        final MenuItem menuHoraires = new MenuItem(menu, 64);
        menuHoraires.setText(String.valueOf(Messages.getString((String)"AppointmentMultiProfEditor.PROFESSIONNELS_AVEC_HORAIRE", (String[])new String[0])) + " (" + SitePlugin.getDefault().getContextSiteChecked().getNameCommon() + ")");
        final boolean[] armed1 = new boolean[1];
        menuHoraires.addArmListener(new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                block9: {
                    if (!armed1[0]) {
                        final Menu submenu = new Menu(menuHoraires);
                        menuHoraires.setMenu(submenu);
                        JobCallback callback = null;
                        try {
                            try {
                                callback = new JobCallback(Messages.getString((String)"CHARGEMENT", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                                    public void responseReceived(final ReturnObject response) {
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                List lst = (List)response.getObj();
                                                ArrayList<XBaseProfessionnal> lstProfWithHoraire = new ArrayList<XBaseProfessionnal>();
                                                List<XBaseProfessionnal> lstAllProfs = AppointmentPlugin.getDefault().getProfessionnals();
                                                List items = ProfessionalBySiteCombo.toProfessionnalBySiteList(lstAllProfs);
                                                for (IPair xx : items) {
                                                    if (xx.getSecond() == null || !((XSite)xx.getSecond()).equals((Object)SitePlugin.getDefault().getContextSite()) || !lst.contains(((XBaseProfessionnal)xx.getFirst()).getId())) continue;
                                                    lstProfWithHoraire.add((XBaseProfessionnal)xx.getFirst());
                                                }
                                                Collections.sort(lstProfWithHoraire, new Comparator<XBaseProfessionnal>(){

                                                    @Override
                                                    public int compare(XBaseProfessionnal o1, XBaseProfessionnal o2) {
                                                        return o1.getNameBirthdateSex().compareTo(o2.getNameBirthdateSex());
                                                    }
                                                });
                                                for (final XBaseProfessionnal professionnal : lstProfWithHoraire) {
                                                    MenuItem item = new MenuItem(submenu, 8);
                                                    item.setText(professionnal.getName());
                                                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                                        public void widgetSelected(SelectionEvent e) {
                                                            AppointmentMainEditorInput input = null;
                                                            try {
                                                                Log.logOperation((String)"OpenAppointmentAction.openAppointmentEditor", (Object[])new Object[]{professionnal});
                                                                input = new AppointmentMainEditorInput("AppointmentMainEditor");
                                                                input.setProfessional(professionnal);
                                                                input.setMode(IAppointmentMode.Mode.APPOINTMENT);
                                                                input.setDate((LocalDate)dates.first());
                                                                BaseEditor.openEditor((IEditorInput)input, (String)AppointmentMainEditor.class.getName());
                                                            }
                                                            catch (Exception e1) {
                                                                logger.log(Level.SEVERE, "Failed to open appointment editor with input " + input, e1);
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    }
                                };
                                AppointmentAccessorClient.getInstance().getProfessionalsWithSchedule(this.hashCode(), Application.get().getGlobalInstances().getSession(), (LocalDate)dates.first(), (ICallback)callback);
                            }
                            catch (Exception e1) {
                                logger.log(Level.SEVERE, "Failed to open PROFESSIONNELS_AVEC_HORAIRE", e1);
                                if (callback != null) {
                                    callback.kill();
                                }
                                break block9;
                            }
                        }
                        catch (Throwable throwable) {
                            if (callback != null) {
                                callback.kill();
                            }
                            throw throwable;
                        }
                        if (callback != null) {
                            callback.kill();
                        }
                    }
                }
                armed1[0] = true;
            }
        });
        new MenuItem(menu, 2);
        if (this.getMode() == IAppointmentMode.Mode.SCHEDULE) {
            this.getController().moveBaseAppointmentDateCursor((LocalDate)dates.first(), (LocalDate)dates.last());
            if (dates.size() > 0) {
                MenuItem erase = new MenuItem(menu, 8);
                erase.setText(Messages.getString((String)"EFFACER_LA_JOURNEE", (String[])new String[0]));
                erase.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (MessageUtil.askAreYouSure((Shell)AppointmentCalendarGrid.this.editor.getSite().getShell())) {
                            AppointmentCalendarGrid.this.editor.deleteAppointmentDate(dates.toList());
                        }
                    }
                });
                MenuItem close = new MenuItem(menu, 8);
                close.setText(Messages.getString((String)"FERMER_TOUTES_LES_PERIODES_ET_MARQUEE_LES_RENDEZ_VOUS_COMME_A_DEPLACER", (String[])new String[0]));
                close.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (MessageUtil.askAreYouSure((Shell)AppointmentCalendarGrid.this.editor.getSite().getShell())) {
                            AppointmentCalendarGrid.this.editor.closeAppointmentDate(dates.toList());
                        }
                    }
                });
            }
        } else if (this.getMode() == IAppointmentMode.Mode.APPOINTMENT) {
            this.addPrintMenuItem(menu);
            if (dates.size() == 1) {
                final XAppointmentDate xapptDate = this.editor.getController().getAppointmentDate((LocalDate)dates.first());
                MenuItem erase = new MenuItem(menu, 8);
                erase.setText(Messages.getString((String)"MOVE_ALL_APPTS", (String[])new String[0]));
                erase.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractSingleInputWindows apptWindow = new AbstractSingleInputWindows(UI.getWorkbenchShell(), MessageFormat.format(Messages.getString((String)"MOVE_APPT", (String[])new String[0]), LocalDateFormat.format((LocalDate)xapptDate.getDate(), (String)FormatDateProvider.getFormatDate().toString())), null){
                            protected Set<IAppointment> checkedAppt;
                            MyCalendarText txtDate;
                            ProfessionalBySiteCombo cmbProfessionnal;
                            protected CheckboxTreeViewer list;
                            protected MyButton chkAM;
                            protected MyButton chkPM;
                            protected MyButton chkSoir;
                            protected boolean bAM;
                            protected boolean bPM;
                            protected boolean bSoir;
                            {
                                super($anonymous0, $anonymous1, $anonymous2);
                                this.checkedAppt = new HashSet<IAppointment>();
                                this.bAM = true;
                                this.bPM = true;
                                this.bSoir = true;
                            }

                            protected boolean btnPressed(int btnId) {
                                AppointmentCalendarGrid appointmentCalendarGrid = AppointmentCalendarGrid.this;
                                appointmentCalendarGrid.getClass();
                                CheckedApptContainer cont = appointmentCalendarGrid.new CheckedApptContainer(this.checkedAppt, this.cmbProfessionnal.getSelection(), this.txtDate.getDate());
                                this.input = cont;
                                return true;
                            }

                            protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
                                this.chkAM = new MyButton(parent, String.valueOf(Messages.getString((String)"Client.RDVS", (String[])new String[0])) + " - " + Messages.getString((String)"AM", (String[])new String[0]), 32, toolkit);
                                this.chkAM.setSelection(true);
                                this.chkAM.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        bAM = ((Button)e.widget).getSelection();
                                        list.refresh(true);
                                    }
                                });
                                this.chkPM = new MyButton(parent, String.valueOf(Messages.getString((String)"Client.RDVS", (String[])new String[0])) + " - " + Messages.getString((String)"PM", (String[])new String[0]), 32, toolkit);
                                this.chkPM.setSelection(true);
                                this.chkPM.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        bPM = ((Button)e.widget).getSelection();
                                        list.refresh(true);
                                    }
                                });
                                this.chkSoir = new MyButton(parent, String.valueOf(Messages.getString((String)"Client.RDVS", (String[])new String[0])) + " - " + Messages.getString((String)"SOIREE", (String[])new String[0]), 32, toolkit);
                                this.chkSoir.setSelection(true);
                                this.chkSoir.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        bSoir = ((Button)e.widget).getSelection();
                                        list.refresh(true);
                                    }
                                });
                                this.list = new CheckboxTreeViewer(parent, 2048){

                                    protected void handleDoubleSelect(SelectionEvent event) {
                                        super.handleDoubleSelect(event);
                                    }
                                };
                                this.list.setContentProvider((IContentProvider)new AppointmentTreeContentProvider());
                                this.list.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                                    public String getText(Object element) {
                                        IAppointment x = (IAppointment)element;
                                        return String.valueOf(Boolean.TRUE.equals(x.getIsDeleted()) ? "X " : "") + AppointmentCalendarGrid.this.formatAppointmentForSendMessage(x);
                                    }
                                });
                                ViewerFilter filter = new ViewerFilter(){

                                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                                        IAppointment x = (IAppointment)element;
                                        return Boolean.FALSE.equals(x.getIsDeleted());
                                    }
                                };
                                this.list.setFilters(new ViewerFilter[]{filter});
                                MyLabel lblMoveTo = new MyLabel(parent, Messages.getString((String)"MOVE_TO", (String[])new String[0]), 16384, toolkit);
                                MyLabel lblDate = new MyLabel(parent, Messages.getString((String)"DATE", (String[])new String[0]), 16384, toolkit);
                                this.txtDate = new MyCalendarText(parent, 0, toolkit, true);
                                this.txtDate.setDate((IPartialDate)xapptDate.getDate());
                                MyLabel lblProfessionnal = new MyLabel(parent, Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]), 16384, toolkit);
                                this.cmbProfessionnal = new ProfessionalBySiteCombo(parent, 65544, toolkit);
                                this.cmbProfessionnal.fill();
                                this.cmbProfessionnal.select(AppointmentCalendarGrid.this.getController().getCurrentProfessional());
                                IEditableDataObjectList<? extends IAppointment> lstAppt = AppointmentCalendarGrid.this.editor.getController().getAppointments(xapptDate);
                                if (lstAppt != null) {
                                    Collections.sort(lstAppt, new Comparator<IAppointment>(){

                                        @Override
                                        public int compare(IAppointment o1, IAppointment o2) {
                                            return o1.getStartTime().compareTo(o2.getStartTime());
                                        }
                                    });
                                    this.list.setInput(lstAppt);
                                }
                                this.list.setCheckStateProvider(new ICheckStateProvider(){

                                    public boolean isChecked(Object element) {
                                        IAppointment x = (IAppointment)element;
                                        boolean c = false;
                                        int start = x.getStartTime().intValue();
                                        c = start < 720 ? bAM : (start < 1080 ? bPM : bSoir);
                                        if (Boolean.FALSE.equals(x.getIsDeleted()) && c) {
                                            checkedAppt.add(x);
                                        } else {
                                            checkedAppt.remove(x);
                                        }
                                        return c;
                                    }

                                    public boolean isGrayed(Object element) {
                                        IAppointment x = (IAppointment)element;
                                        return Boolean.TRUE.equals(x.getIsDeleted());
                                    }
                                });
                                this.list.addCheckStateListener(new ICheckStateListener(){

                                    public void checkStateChanged(CheckStateChangedEvent event) {
                                        IAppointment x = (IAppointment)event.getElement();
                                        if (event.getChecked()) {
                                            checkedAppt.add(x);
                                        } else {
                                            checkedAppt.remove(x);
                                        }
                                    }
                                });
                                parent.setLayout((Layout)new FormLayout());
                                FormData data = new FormData();
                                data.top = new FormAttachment(0);
                                data.left = new FormAttachment(0);
                                data.right = new FormAttachment(100);
                                this.chkAM.setLayoutData((Object)data);
                                data = new FormData();
                                data.top = new FormAttachment(this.chkAM.getControl());
                                data.left = new FormAttachment(0);
                                data.right = new FormAttachment(100);
                                this.chkPM.setLayoutData((Object)data);
                                data = new FormData();
                                data.top = new FormAttachment(this.chkPM.getControl());
                                data.left = new FormAttachment(0);
                                data.right = new FormAttachment(100);
                                this.chkSoir.setLayoutData((Object)data);
                                data = new FormData();
                                data.top = new FormAttachment(this.chkSoir.getControl(), 5);
                                data.left = new FormAttachment(0);
                                data.right = new FormAttachment(100);
                                data.height = 300;
                                this.list.getTree().setLayoutData((Object)data);
                                data = new FormData();
                                data.top = new FormAttachment((Control)this.list.getTree(), 10);
                                data.left = new FormAttachment(0);
                                data.right = new FormAttachment(100);
                                lblMoveTo.setLayoutData((Object)data);
                                data = new FormData();
                                data.top = new FormAttachment(lblMoveTo.getControl(), 10);
                                data.left = new FormAttachment(0);
                                data.right = new FormAttachment(40);
                                lblDate.setLayoutData((Object)data);
                                data = new FormData();
                                data.top = new FormAttachment(lblMoveTo.getControl(), 10);
                                data.left = new FormAttachment(40, 5);
                                data.right = new FormAttachment(100);
                                this.txtDate.setLayoutData((Object)data);
                                data = new FormData();
                                data.top = new FormAttachment(lblDate.getControl(), 10);
                                data.left = new FormAttachment(0);
                                data.right = new FormAttachment(40);
                                lblProfessionnal.setLayoutData((Object)data);
                                data = new FormData();
                                data.top = new FormAttachment(lblDate.getControl(), 10);
                                data.left = new FormAttachment(40, 2);
                                data.right = new FormAttachment(100);
                                this.cmbProfessionnal.setLayoutData(data);
                                ControlWrapper control = new ControlWrapper((Control)this.list.getTree());
                                return control;
                            }
                        };
                        int repUri = apptWindow.open();
                        if (repUri == 0) {
                            Set<IAppointment> items;
                            final XBaseProfessionnal prevProf = AppointmentCalendarGrid.this.getController().getCurrentProfessional();
                            final CheckedApptContainer container = (CheckedApptContainer)apptWindow.getInput();
                            if (container != null && (items = container.checkedAppt).size() > 0 && container.prof != null && container.date != null && MessageDialog.openConfirm((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"QUESTION", (String[])new String[0]), (String)Messages.getString((String)"CONFIRMER_DEPLACEMENT_RDVS", (String[])new String[0]))) {
                                final StatusException[] statusException = new StatusException[1];
                                ProgressMonitorDialog dialog = new ProgressMonitorDialog(UI.getWorkbenchShell());
                                try {
                                    dialog.run(true, false, new IRunnableWithProgress(){

                                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                            monitor.beginTask(MessageFormat.format(Messages.getString((String)"MOVE_APPT", (String[])new String[0]), String.valueOf(Messages.getString((String)"DATE", (String[])new String[0]).toLowerCase()) + " " + xapptDate.getDate().formatHyphen()), items.size() + 10);
                                            try {
                                                monitor.worked(1);
                                                Display.getDefault().syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        AppointmentCalendarGrid.this.getController().setCurrentProfessional(container.prof);
                                                    }
                                                });
                                                monitor.worked(6);
                                                XAppointmentDate date = AppointmentCalendarGrid.this.getController().getAppointmentDate(container.date);
                                                monitor.worked(3);
                                                for (IAppointment appointment : items) {
                                                    monitor.subTask(MessageFormat.format(Messages.getString((String)"MOVE_APPT", (String[])new String[0]), ": " + AppointmentCalendarGrid.this.formatAppointmentForSendMessage(appointment)));
                                                    AppointmentCalendarGrid.this.getController().moveApppointmentToApppointmentDate(appointment, date);
                                                    monitor.worked(1);
                                                    Thread.sleep(50L);
                                                }
                                                Display.getDefault().syncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        AppointmentCalendarGrid.this.getController().setCurrentProfessional(prevProf);
                                                    }
                                                });
                                            }
                                            catch (StatusException e) {
                                                statusException[0] = e;
                                            }
                                            catch (Exception e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                    });
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                }
                                catch (InterruptedException interruptedException) {}
                                if (statusException[0] != null) {
                                    MessageUtil.show((Shell)UI.getWorkbenchShell(), (IStatus)statusException[0].getStatus());
                                }
                            }
                        }
                    }
                });
                MenuItem sendConfirmationEmails = new MenuItem(menu, 8);
                sendConfirmationEmails.setText(Messages.getString((String)"RVDateControl.SEND_CONFIRMS_EMAIL", (String[])new String[0]));
                sendConfirmationEmails.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent s) {
                        SendAppointmentsConfirmationDialog dialog = new SendAppointmentsConfirmationDialog(UI.getWorkbenchShell(), xapptDate.getDate(), AppointmentCalendarGrid.this.getController());
                        dialog.open();
                    }
                });
            }
            if (Application.get().getGlobalInstances().inDebugMode()) {
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Executer le robot de modifications");
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new AppointmentRobotDialog(UI.getWorkbenchShell(), new AppointmentRobotController(AppointmentCalendarGrid.this.editor.getController()));
                    }
                });
            }
        }
        menu.setVisible(true);
    }

    private void addAbsentMessageMenu(MenuItem parent, final CalendarSelection dates, List<XBaseAppointmentDate> xdates, final Collection<XBaseProfessionnal> profs) {
        Menu mChoices = new Menu(parent);
        parent.setMenu(mChoices);
        this.addMessageChoiceListener(mChoices, dates, xdates, profs, XAppointmentDateMessageType.ABSENT_ALL_DAY);
        this.addMessageChoiceListener(mChoices, dates, xdates, profs, XAppointmentDateMessageType.ABSENT_AM);
        this.addMessageChoiceListener(mChoices, dates, xdates, profs, XAppointmentDateMessageType.ABSENT_PM);
        this.addMessageChoiceListener(mChoices, dates, xdates, profs, XAppointmentDateMessageType.ABSENT_EVE);
        new MenuItem(mChoices, 2);
        this.addMessageChoiceListener(mChoices, dates, xdates, profs, XAppointmentDateMessageType.PLAIN);
        new MenuItem(mChoices, 2);
        MenuItem mCancel = new MenuItem(mChoices, 8);
        mCancel.setText(Messages.getString((String)"ANNULER_ABSENCE(S)/MESSAGE", (String[])new String[0]));
        mCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentCalendarGrid.this.changeAppointmentDateMessage(dates, profs, null, null);
            }
        });
        mChoices.setVisible(true);
    }

    private void addAbsentDeGardeMenu(MenuItem parent, final CalendarSelection dates, final List<XBaseAppointmentDate> xdates, final Collection<XBaseProfessionnal> profs) {
        Menu mChoices = new Menu(parent);
        parent.setMenu(mChoices);
        MenuItem mAllDay = new MenuItem(mChoices, 8);
        mAllDay.setText(Messages.getString((String)"DE_GARDE.AM_MP_SOIR", (String[])new String[0]));
        mAllDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<XAppointmentDateDeGardeType> l = new ArrayList<XAppointmentDateDeGardeType>(3);
                l.add(XAppointmentDateDeGardeType.AM);
                l.add(XAppointmentDateDeGardeType.PM);
                l.add(XAppointmentDateDeGardeType.SOIR);
                AppointmentCalendarGrid.this.changeAppointmentDateDeGardeType(dates, (Collection<XBaseProfessionnal>)profs, l, (List<XBaseAppointmentDate>)xdates);
            }
        });
        this.addDeGardeChoiceListener(mChoices, dates, xdates, profs, XAppointmentDateDeGardeType.AM);
        this.addDeGardeChoiceListener(mChoices, dates, xdates, profs, XAppointmentDateDeGardeType.PM);
        this.addDeGardeChoiceListener(mChoices, dates, xdates, profs, XAppointmentDateDeGardeType.SOIR);
        new MenuItem(mChoices, 2);
        MenuItem mCancel = new MenuItem(mChoices, 8);
        mCancel.setText(Messages.getString((String)"APPOINTMENT_MENU.ANNULER_DE_GARDE", (String[])new String[0]));
        mCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentCalendarGrid.this.changeAppointmentDateDeGardeType(dates, (Collection<XBaseProfessionnal>)profs, null, (List<XBaseAppointmentDate>)xdates);
            }
        });
        if (dates.size() == 1) {
            new MenuItem(mChoices, 2);
            final MenuItem mList = new MenuItem(mChoices, 64);
            mList.setText(Messages.getString((String)"APPOINTMENT_MENU.LIST", (String[])new String[0]));
            mList.addArmListener(new ArmListener(){

                public void widgetArmed(ArmEvent arg0) {
                    ArrayList date = new ArrayList(dates);
                    AppointmentCalendarGrid.this.listAppointmentDateDeGardeProfessionnal((LocalDate)date.get(0), mList);
                }
            });
        }
        mChoices.setVisible(true);
    }

    private void listAppointmentDateDeGardeProfessionnal(LocalDate date, MenuItem parent) {
        block4: {
            final Menu menu = new Menu(parent);
            parent.setMenu(menu);
            Callback callback = new Callback(){

                public void responseReceived(ReturnObject response) {
                    if (response != null && response.getObj() != null) {
                        ArrayList res = (ArrayList)response.getObj();
                        if (res.size() == 0) {
                            MenuItem mi = new MenuItem(menu, 10);
                            mi.setEnabled(false);
                            mi.setText(Messages.getString((String)"APPOITNMENT_MENU.NO_ONE_ONCALL", (String[])new String[0]));
                        }
                        for (XBaseAppointmentDate xbd : res) {
                            MenuItem mi = new MenuItem(menu, 8);
                            mi.setText(xbd.getDeGardeTypes() + " - " + PersonUiPlugin.getDefault().getBaseProfessionnal(xbd.getProfessional()).getName());
                        }
                    }
                }
            };
            try {
                XSession session = Application.get().getGlobalInstances().getSession();
                AppointmentAccessorClient.getInstance().getBaseAppointmentDatesDeGarde(session, (ICallback)callback, date);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                Log.severe((Throwable)e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private void addMessageChoiceListener(Menu parent, final CalendarSelection selection, List<XBaseAppointmentDate> xdates, final Collection<XBaseProfessionnal> profs, final XAppointmentDateMessageType type) {
        MenuItem mChoice = new MenuItem(parent, 32);
        final String message = this.computeCommonMessage(xdates, profs.size() > 1);
        final boolean selected = XAppointmentDateMessageType.PLAIN.equals((Object)type) ? StringUtils.isNotBlank((CharSequence)message) : (profs.size() > 1 ? this.shouldSelectChoiceAll(xdates, type) : this.shouldSelectChoice(xdates, type));
        mChoice.setSelection(selected);
        mChoice.setText(type.toString());
        mChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!selected || XAppointmentDateMessageType.PLAIN.equals((Object)type)) {
                    TextInputDialog dialog = new TextInputDialog();
                    dialog.setParent(AppointmentCalendarGrid.this.editor.getSite().getShell());
                    dialog.setTitle(Messages.getString((String)"MESSAGE", (String[])new String[0]));
                    dialog.setWaitForWindowToClose(true);
                    dialog.setText(message);
                    dialog.open();
                    if (dialog.isOk()) {
                        XAppointmentDateMessageType tt = StringUtils.isEmpty((CharSequence)dialog.getText()) ? null : type;
                        String theText = StringUtils.isEmpty((CharSequence)dialog.getText()) ? null : dialog.getText();
                        AppointmentCalendarGrid.this.changeAppointmentDateMessage(selection, profs, tt, theText);
                    }
                } else {
                    switch (type) {
                        case PLAIN: 
                        case ABSENT_ALL_DAY: {
                            AppointmentCalendarGrid.this.changeAppointmentDateMessage(selection, profs, null, null);
                            break;
                        }
                        case ABSENT_AM: 
                        case ABSENT_PM: 
                        case ABSENT_EVE: {
                            AppointmentCalendarGrid.this.changeAppointmentDateMessage(selection, profs, type, message);
                        }
                    }
                }
            }
        });
    }

    protected String formatAppointmentForSendMessage(IAppointment a) {
        IPatient patient = a.getPatientOrAdhoc((IJsonReader)Application.get().getGsonProcessor());
        return String.format("%s %s %s ", a.getStartTimeInString(), a.getDuree(), patient == null ? "<G>" : patient.getName());
    }

    private void addDeGardeChoiceListener(Menu parent, final CalendarSelection selection, final List<XBaseAppointmentDate> xdates, final Collection<XBaseProfessionnal> profs, final XAppointmentDateDeGardeType type) {
        MenuItem mChoice = new MenuItem(parent, 32);
        boolean selected = this.shouldSelectChoice(xdates, type);
        mChoice.setSelection(selected);
        mChoice.setText(type.toString());
        mChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AppointmentCalendarGrid.this.changeAppointmentDateDeGardeType(selection, (Collection<XBaseProfessionnal>)profs, type, (List<XBaseAppointmentDate>)xdates);
            }
        });
    }

    private String computeCommonMessage(List<XBaseAppointmentDate> xdates, boolean allProfs) {
        String message = null;
        boolean sameMessage = true;
        for (XBaseAppointmentDate xdate : xdates) {
            if (xdate != null) continue;
            sameMessage = false;
            break;
        }
        if (sameMessage) {
            message = allProfs ? xdates.get(0).getMessageAll() : xdates.get(0).getMessage();
            for (XBaseAppointmentDate xdate : xdates) {
                if (MiscUtil.areObjectsEquals((Object)message, (Object)(allProfs ? xdate.getMessageAll() : xdate.getMessage()))) continue;
                sameMessage = false;
                break;
            }
        }
        if (!sameMessage) {
            message = null;
        }
        return message;
    }

    private boolean shouldSelectChoice(List<XBaseAppointmentDate> xdates, XAppointmentDateMessageType type) {
        boolean selected = true;
        for (XBaseAppointmentDate xdate : xdates) {
            if (xdate != null && xdate.getMessageTypes() != null && xdate.getMessageTypes().contains(type)) continue;
            selected = false;
            break;
        }
        return selected;
    }

    private boolean shouldSelectChoiceAll(List<XBaseAppointmentDate> xdates, XAppointmentDateMessageType type) {
        boolean selected = true;
        for (XBaseAppointmentDate xdate : xdates) {
            if (xdate != null && xdate.getMessageTypesAll() != null && xdate.getMessageTypesAll().contains(type)) continue;
            selected = false;
            break;
        }
        return selected;
    }

    private boolean shouldSelectChoice(List<XBaseAppointmentDate> xdates, XAppointmentDateDeGardeType type) {
        boolean selected = true;
        for (XBaseAppointmentDate xdate : xdates) {
            if (xdate != null && xdate.getDeGardeTypes() != null && xdate.getDeGardeTypes().contains(type)) continue;
            selected = false;
            break;
        }
        return selected;
    }

    private void changeAppointmentDateMessage(CalendarSelection selection, Collection<XBaseProfessionnal> profs, XAppointmentDateMessageType type, String message) {
        IntArrayList professionnals = EditableDataObject.getIds(profs);
        ArrayList dates = new ArrayList(selection);
        try {
            AppointmentAccessorClient.getInstance().changeAppointmentDateMessage(Application.get().getGlobalInstances().getSession(), dates, (List)professionnals, message, type);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg((Shell)this.getCanvas().getShell());
        }
        catch (Exception e1) {
            MessageUtil.show((Shell)this.getCanvas().getShell(), (Exception)e1);
        }
    }

    private void changeAppointmentDateDeGardeType(CalendarSelection selection, Collection<XBaseProfessionnal> profs, final XAppointmentDateDeGardeType type, final List<XBaseAppointmentDate> xdates) {
        IntArrayList professionnals = EditableDataObject.getIds(profs);
        ArrayList dates = new ArrayList(selection);
        try {
            Callback callback = new Callback(){

                public void responseReceived(ReturnObject response) {
                    if (response.getStatus().isOK()) {
                        for (XBaseAppointmentDate x : xdates) {
                            EnumSet types;
                            if (type == null) {
                                x.setDeGardeTypes(null);
                            }
                            if (type == null) {
                                x.setDeGardeTypes(null);
                                continue;
                            }
                            if (x.getDeGardeTypes() == null) {
                                x.setDeGardeTypes(EnumSet.noneOf(XAppointmentDateDeGardeType.class));
                            }
                            if ((types = x.getDeGardeTypes()).contains(type)) {
                                types.remove(type);
                                continue;
                            }
                            types.add(type);
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                AppointmentCalendarGrid.this.editor.getCalendar().redraw();
                            }
                        });
                    }
                }
            };
            AppointmentAccessorClient.getInstance().changeAppointmentDateDeGardeType(Application.get().getGlobalInstances().getSession(), dates, (List)professionnals, type, (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg((Shell)this.getCanvas().getShell());
        }
        catch (Exception e1) {
            MessageUtil.show((Shell)this.getCanvas().getShell(), (Exception)e1);
        }
    }

    private void changeAppointmentDateDeGardeType(CalendarSelection selection, Collection<XBaseProfessionnal> profs, final List<XAppointmentDateDeGardeType> types, final List<XBaseAppointmentDate> xdates) {
        IntArrayList professionnals = EditableDataObject.getIds(profs);
        ArrayList dates = new ArrayList(selection);
        try {
            Callback callback = new Callback(){

                public void responseReceived(ReturnObject response) {
                    if (response.getStatus().isOK()) {
                        for (XBaseAppointmentDate dd : xdates) {
                            if (types == null || types.isEmpty()) {
                                dd.setDeGardeTypes(null);
                                continue;
                            }
                            if (dd.getDeGardeTypes() == null) {
                                dd.setDeGardeTypes(EnumSet.noneOf(XAppointmentDateDeGardeType.class));
                            }
                            dd.getDeGardeTypes().clear();
                            for (XAppointmentDateDeGardeType x : types) {
                                dd.getDeGardeTypes().add(x);
                            }
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                AppointmentCalendarGrid.this.editor.getCalendar().redraw();
                            }
                        });
                    }
                }
            };
            AppointmentAccessorClient.getInstance().changeAppointmentDateDeGardeTypes(Application.get().getGlobalInstances().getSession(), dates, (List)professionnals, types, (ICallback)callback);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            MessageUtil.cannotConnectToServerExceptionMsg((Shell)this.getCanvas().getShell());
        }
        catch (Exception e1) {
            MessageUtil.show((Shell)this.getCanvas().getShell(), (Exception)e1);
        }
    }

    private void addPrintMenuItem(Menu menu) {
        CalendarSelection selection = this.calendar.getSelection();
        if (!selection.isEmpty()) {
            final ArrayList<XBaseAppointmentDate> dates = new ArrayList<XBaseAppointmentDate>(selection.size());
            for (LocalDate date : selection) {
                XAppointmentDateStatistics2 statistic;
                XBaseAppointmentDate xdate = this.calendarData.getStatistic(date);
                if (xdate == null || (statistic = xdate.getStatistic()) == null || statistic.appointments.size() <= 0 && statistic.periods.size() <= 0) continue;
                dates.add(xdate);
            }
            if (!dates.isEmpty()) {
                MenuItem item = new MenuItem(menu, 8);
                item.setText(Messages.getString((String)"IMPRIMER", (String[])new String[0]));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AppointmentDatePrintDialog dialog = new AppointmentDatePrintDialog(AppointmentCalendarGrid.this.editor.getSite().getShell(), dates);
                        UI.centerComposite((Composite)dialog.getShell(), (Composite)AppointmentCalendarGrid.this.editor.getSite().getShell());
                        dialog.open();
                    }
                });
            }
        }
    }

    private AppointmentMainController getController() {
        return this.editor.getController();
    }

    public IAppointmentMode.Mode getMode() {
        return this.statisticCellRenderer.getMode();
    }

    public void setMode(IAppointmentMode.Mode mode) {
        this.statisticCellRenderer.setMode(mode);
    }

    public void dispose() {
        ResourceGetter.removeListener((IRefreshFont)this);
        PreferencesSettings.getInstance().removeListener((IPreferenceListener)this);
        this.calendar.dispose();
    }

    public Composite getCanvas() {
        return this.calendar;
    }

    public Cell getCellFromGCPoint(Point gcPoint) {
        return this.calendar.getCellFromGCPoint(gcPoint);
    }

    public CellRendererFactory getCellRendererFactory() {
        return this.calendar.getCellRendererFactory();
    }

    public ICalendarGridData getData() throws IllegalStateException {
        return this.calendar.getData();
    }

    public LocalDate getDateFromGCPoint(Point gcPoint) {
        return this.calendar.getDateFromGCPoint(gcPoint);
    }

    public void redraw() {
        this.calendar.redraw();
    }

    public void reveal(LocalDate date) {
        this.calendar.reveal(date);
    }

    public void revealMonth(LocalDate dateInTheMonth) {
        this.calendar.revealMonth(dateInTheMonth);
    }

    public void selectLine(int weekLine) {
        this.calendar.selectLine(weekLine);
    }

    public void setCellRendererFactory(CellRendererFactory cellRendererFactory) {
        this.calendar.setCellRendererFactory(cellRendererFactory);
    }

    public void setData(ICalendarGridData data) {
        this.calendar.setData(data);
    }

    public CalendarSelection getSelection() {
        return this.calendar.getSelection();
    }

    public void changed(String preferenceId, String oldValue, String newValue) {
        if (("appointment/calendar.stats.excluded.period.types".equals(preferenceId) || "appointment/calendar.stats.include.appointment.outside.period".equals(preferenceId) || "appointment/calendar.stats.include.appointment.overbooking".equals(preferenceId)) && this.calendar != null) {
            this.calendar.getDisplay().asyncExec(() -> this.calendar.redraw());
        }
    }

    public void validChange(String preferenceId, String oldValue, String newValue, MultiStatus status) {
    }

    public void refreshFont() {
        this.calendar.redraw();
    }

    public void setBackgroundOverride(Color color) {
    }

    protected class CheckedApptContainer {
        protected final Set<IAppointment> checkedAppt;
        protected final XBaseProfessionnal prof;
        protected final LocalDate date;

        public CheckedApptContainer(Set<IAppointment> checkedAppt, XBaseProfessionnal prof, LocalDate date) {
            this.checkedAppt = checkedAppt;
            this.prof = prof;
            this.date = date;
        }
    }
}

