/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.billing;

import ca.infodata.factramq.AutoCode;
import ca.infodata.factramq.AutoMod;
import ca.infodata.factramq.CodeModAuto;
import ca.infodata.factramq.FacturationE;
import ca.infodata.factramq.FacturationP;
import ca.infodata.factramq.WSFactRamqClient;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.person.DefaultNamValidatorService;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.ISearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCodeClassification;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.appointment.billing.FacturationRamq;
import ca.infodata.ofys.ui.controls.CodeSearchComposite;
import ca.infodata.ofys.ui.controls.CodeSearchTextAccessor;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.NoSessionWarningComposite;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MySearchText;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.CharUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DoBillingRamqDialog {
    private static final Logger logger = Logger.getLogger(DoBillingRamqDialog.class.getName());
    private static final String OK = Messages.getString((String)"OK", (String[])new String[0]);
    private static final String ANNULER = Messages.getString((String)"ANNULER", (String[])new String[0]);
    private static final String MEDECIN = "M\u00e9decin : ";
    private static final String CODE = "Code (cim9)";
    private static final String DESCR = "Renseignements compl\u00e9mentaires";
    private static final String INFO_DX = "(Laissez la case \"Code\" vide si vous voulez que MED-Office reprenne le dernier diagnostic de facturation du patient)";
    private static final String NOTE = "Note";
    private static final String NOTE_TTT = "Pr\u00e9c\u00e9dez les lignes \u00e0 mettre dans les renseignements compl\u00e9mentaires par un caract\u00e8re @";
    private static final String CODES = "Codes";
    private static final String MODIF = "Modificateurs";
    private static final String TO_COMPLETE = "Demande de paiement \u00e0 valider manuellement dans MED-Office";
    private static final String TXT_CODE_TTT = "Vous pouvez saisir une lettre correspondant \u00e0 un code automatique ou plusieurs lettres. Vous pouvez aussi saisir le code en chiffres. Veuillez s\u00e9parer les codes en chiffres par un espace.";
    private static final String TXT_MOD_TTT = "Vous pouvez saisir une lettre correspondant \u00e0 un modificateur automatique ou mettre le modificateur directement en chiffres. Veuillez mettre un maximum de 1 modificateur ici (une lettre ou un chiffre, p.ex. 019).";
    private static final String NAM_INVALIDE = "Le patient du rendez-vous doit avoir un nam valide pour pouvoir facturer";
    private final Shell dialog;
    private MySearchText txtDxCode;
    private MyText txtDxDescr;
    private MyText txtNotes;
    private Combo cmbCodeAuto1;
    private Combo cmbCodeAuto2;
    private Combo cmbCodeAuto3;
    private Combo cmbModAuto1;
    private Combo cmbModAuto2;
    private Combo cmbModAuto3;
    private MyMaskedText txtCode1;
    private MyMaskedText txtMod1;
    private MyMaskedText txtCode2;
    private MyMaskedText txtMod2;
    private MyMaskedText txtCode3;
    private MyMaskedText txtMod3;
    private MyButton chkToComplete;
    private FormToolkit toolkit;
    private final IAppointment appointment;
    private final IPatient patient;
    private final XBaseProfessionnal professionnal;

    public DoBillingRamqDialog(Shell parent, IAppointment appointment, IPatient patient) {
        if (appointment == null) {
            throw new NullPointerException("appointment");
        }
        if (appointment.getId() == null) {
            throw new NullPointerException("appointment.getId()");
        }
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        BaseAccessorClient.validThatServerIsAccessible((IConnectionInfo)Application.get().getGlobalInstances().getConnectionInfo());
        this.patient = patient;
        this.professionnal = PersonUiPlugin.getDefault().getBaseProfessionnal(appointment.getIdProfessional());
        this.appointment = appointment;
        this.dialog = new Shell(parent, 2144);
        this.dialog.setText("Facturation RAMQ de " + this.patient.getName() + " le " + DateUtil.format((LocalDate)this.appointment.getDate()));
        Color white = ResourceGetter.getColor((int)255, (int)255, (int)255);
        ResourceGetter.linkResourceWithWidgetLife((Object)white, (Widget)this.dialog);
        this.dialog.setBackground(white);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.spacing = 5;
        this.dialog.setLayout((Layout)layout);
        this.toolkit = UI.createToolKit((Widget)this.dialog);
        this.createChilds(this.dialog);
    }

    public static boolean valid(IPatient patient) {
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        DefaultNamValidatorService validator = new DefaultNamValidatorService();
        validator.setDoValidNb(true);
        validator.setDoValidQc(true);
        IStatus status = validator.valid(patient);
        if (!status.isLessSevereThan(IStatus.Severity.WARNING)) {
            MessageUtil.warningMsg((Shell)UI.getWorkbenchShell(), (String)(String.valueOf(patient.getNameBirthdateSex()) + '\r' + NAM_INVALIDE));
            return false;
        }
        return true;
    }

    private void createChilds(final Shell parent) {
        MyMask codeMask = new MyMask(MyMask.toLength((char)'!', (int)30), 16);
        MyMask modMask = new MyMask(MyMask.toLength((char)'!', (int)3), 16);
        MyLabel lblMedecin = new MyLabel((Composite)parent, MEDECIN + this.professionnal.getName() + " (" + StringUtils.trim((String)this.professionnal.getCode()) + ")", 0, this.toolkit);
        MyLabel lblDxCode = new MyLabel((Composite)parent, CODE, 0, this.toolkit);
        final MyLabel lblCodeDesc = new MyLabel((Composite)parent, null, 64, this.toolkit);
        this.txtDxCode = new MySearchText((Composite)parent, 8192, this.toolkit);
        this.txtDxCode.setSearchTextAccessor((ISearchTextAccessor)new CodeSearchTextAccessor(XCodeClassification.CIM9));
        this.txtDxCode.getBtnSearch().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell shell = new Shell(parent.getShell(), 65616);
                shell.setLayout((Layout)new FillLayout());
                if (Application.get().getGlobalInstances().getSession() == null) {
                    new NoSessionWarningComposite((Composite)shell, 0);
                } else {
                    CodeSearchComposite searhComposite = new CodeSearchComposite((Composite)shell, 0){

                        public void close() {
                            shell.close();
                        }
                    };
                    searhComposite.setClassification(XCodeClassification.CIM9, false);
                    searhComposite.setReferenceControl((Object)DoBillingRamqDialog.this.txtDxCode);
                }
                UI.packAsParentDialog((Shell)shell);
                UI.centerComposite((Composite)shell, (Composite)shell.getParent());
                shell.open();
            }
        });
        this.txtDxCode.setLabelProvider((ProviderAR)new ProviderAR<IDataObject, String>(){

            public String get(IDataObject object) {
                if (object == null) {
                    return "";
                }
                XCode d = (XCode)object;
                return d.getDescriptionLong();
            }
        });
        this.txtDxCode.setTextProvider((ProviderAR)new ProviderAR<IDataObject, String>(){

            public String get(IDataObject object) {
                if (object == null) {
                    return "";
                }
                XCode d = (XCode)object;
                return d.getCode();
            }
        });
        this.txtDxCode.addSearchTextListener(new ISearchTextListener(){

            public void objectReceived(IDataObject dataObject) {
                if (dataObject != null && dataObject instanceof XCode) {
                    lblCodeDesc.setText(((XCode)dataObject).getDescriptionLong());
                    lblCodeDesc.getParent().layout(new Control[]{lblCodeDesc.getControl()});
                }
            }
        });
        MyLabel lblDxMsg = new MyLabel((Composite)parent, INFO_DX, 64, this.toolkit);
        lblDxMsg.setForeground(new Color((Device)Display.getDefault(), 70, 50, 50));
        MyLabel lblDxDescr = new MyLabel((Composite)parent, DESCR, 0, this.toolkit);
        this.txtDxDescr = new MyText((Composite)parent, this.toolkit, 2114);
        this.txtDxDescr.setTextLimit(200);
        Label codeSeparator = this.toolkit.createSeparator((Composite)parent, 256);
        MyLabel lblNotes = new MyLabel((Composite)parent, NOTE, 0, this.toolkit);
        this.txtNotes = new MyText((Composite)parent, this.toolkit, 2114);
        this.txtNotes.setTextLimit(200);
        this.txtNotes.setToolTipText(NOTE_TTT);
        MyLabel lblCode = new MyLabel((Composite)parent, CODES, 0, this.toolkit);
        MyLabel lblMod = new MyLabel((Composite)parent, MODIF, 0, this.toolkit);
        this.cmbCodeAuto1 = new Combo((Composite)parent, 8);
        this.txtCode1 = new MyMaskedText((Composite)parent, this.toolkit);
        this.txtCode1.setMask(codeMask);
        this.txtCode1.setToolTipText(TXT_CODE_TTT);
        this.cmbModAuto1 = new Combo((Composite)parent, 8);
        this.txtMod1 = new MyMaskedText((Composite)parent, this.toolkit);
        this.txtMod1.setMask(modMask);
        this.txtMod1.setToolTipText(TXT_MOD_TTT);
        this.cmbCodeAuto2 = new Combo((Composite)parent, 8);
        this.txtCode2 = new MyMaskedText((Composite)parent, this.toolkit);
        this.txtCode2.setMask(codeMask);
        this.txtCode2.setToolTipText(TXT_CODE_TTT);
        this.cmbModAuto2 = new Combo((Composite)parent, 8);
        this.txtMod2 = new MyMaskedText((Composite)parent, this.toolkit);
        this.txtMod2.setMask(modMask);
        this.txtMod2.setToolTipText(TXT_MOD_TTT);
        this.cmbCodeAuto3 = new Combo((Composite)parent, 8);
        this.txtCode3 = new MyMaskedText((Composite)parent, this.toolkit);
        this.txtCode3.setMask(codeMask);
        this.txtCode3.setToolTipText(TXT_CODE_TTT);
        this.cmbModAuto3 = new Combo((Composite)parent, 8);
        this.txtMod3 = new MyMaskedText((Composite)parent, this.toolkit);
        this.txtMod3.setMask(codeMask);
        this.txtMod3.setToolTipText(TXT_MOD_TTT);
        this.chkToComplete = new MyButton((Composite)parent, TO_COMPLETE, 32, this.toolkit);
        MyButton btnOk = new MyButton((Composite)parent, OK, 8, this.toolkit);
        MyButton btnCancel = new MyButton((Composite)parent, ANNULER, 8, this.toolkit);
        this.cmbCodeAuto1.addSelectionListener((SelectionListener)new ComboCodeSelectionListener(this.txtCode1));
        this.cmbCodeAuto2.addSelectionListener((SelectionListener)new ComboCodeSelectionListener(this.txtCode2));
        this.cmbCodeAuto3.addSelectionListener((SelectionListener)new ComboCodeSelectionListener(this.txtCode3));
        this.cmbModAuto1.addSelectionListener((SelectionListener)new ComboSelectionListener(this.txtMod1));
        this.cmbModAuto2.addSelectionListener((SelectionListener)new ComboSelectionListener(this.txtMod2));
        this.cmbModAuto3.addSelectionListener((SelectionListener)new ComboSelectionListener(this.txtMod3));
        this.txtCode1.addModifyListener((ModifyListener)new TxtModifyListener(this.txtMod1));
        this.txtCode2.addModifyListener((ModifyListener)new TxtModifyListener(this.txtMod2));
        this.txtCode3.addModifyListener((ModifyListener)new TxtModifyListener(this.txtMod3));
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DoBillingRamqDialog.this.ok();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DoBillingRamqDialog.this.cancel();
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        lblMedecin.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblMedecin.getControl());
        data.left = new FormAttachment(0, 5);
        lblDxCode.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblDxCode.getControl());
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(30);
        data.width = 100;
        this.txtDxCode.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblDxCode.getControl());
        data.left = new FormAttachment((Control)this.txtDxCode, 5);
        data.right = new FormAttachment(100, -5);
        lblDxMsg.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblDxMsg.getControl());
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        lblCodeDesc.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblCodeDesc.getControl());
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        codeSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)codeSeparator);
        data.left = new FormAttachment(0, 5);
        lblDxDescr.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblDxDescr.getControl());
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.height = 80;
        this.txtDxDescr.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDxDescr.getControl(), 10);
        data.left = new FormAttachment(0, 5);
        lblNotes.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblNotes.getControl());
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.height = 80;
        this.txtNotes.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtNotes.getControl(), 10);
        data.left = new FormAttachment(0, 5);
        lblCode.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtNotes.getControl(), 10);
        data.left = new FormAttachment(60);
        lblMod.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblCode.getControl(), UI.getAjustedPosition());
        data.left = new FormAttachment(0, 5);
        data.width = 100;
        this.cmbCodeAuto1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblCode.getControl());
        data.left = new FormAttachment((Control)this.cmbCodeAuto1, 5);
        data.right = new FormAttachment(60, -5);
        this.txtCode1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblCode.getControl(), UI.getAjustedPosition());
        data.left = new FormAttachment(60);
        data.width = 100;
        this.cmbModAuto1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblCode.getControl());
        data.left = new FormAttachment((Control)this.cmbModAuto1, 5);
        data.right = new FormAttachment(100, -5);
        this.txtMod1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMod1.getControl(), UI.getAjustedPosition());
        data.left = new FormAttachment(0, 5);
        data.width = 100;
        this.cmbCodeAuto2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMod1.getControl());
        data.left = new FormAttachment((Control)this.cmbCodeAuto1, 5);
        data.right = new FormAttachment(60, -5);
        this.txtCode2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMod1.getControl(), UI.getAjustedPosition());
        data.left = new FormAttachment(60);
        data.width = 100;
        this.cmbModAuto2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMod1.getControl());
        data.left = new FormAttachment((Control)this.cmbModAuto1, 5);
        data.right = new FormAttachment(100, -5);
        this.txtMod2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMod2.getControl(), UI.getAjustedPosition());
        data.left = new FormAttachment(0, 5);
        data.width = 100;
        this.cmbCodeAuto3.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMod2.getControl());
        data.left = new FormAttachment((Control)this.cmbCodeAuto1, 5);
        data.right = new FormAttachment(60, -5);
        this.txtCode3.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMod2.getControl(), UI.getAjustedPosition());
        data.left = new FormAttachment(60);
        data.width = 100;
        this.cmbModAuto3.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtMod2.getControl());
        data.left = new FormAttachment((Control)this.cmbModAuto1, 5);
        data.right = new FormAttachment(100, -5);
        this.txtMod3.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtCode3.getControl());
        data.left = new FormAttachment(0, 5);
        data.bottom = new FormAttachment(btnOk.getControl(), -10);
        this.chkToComplete.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(btnCancel.getControl());
        data.bottom = new FormAttachment(100);
        data.width = 100;
        btnOk.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100);
        data.width = 100;
        btnCancel.setLayoutData((Object)data);
        CodeModAuto getCodeModMd = FacturationRamq.getCodeModMd(this.professionnal.getNoAgenceRamq(), StringUtils.trim((String)this.professionnal.getCode()), new Integer(this.appointment.getDate().dayFrom1970), this.appointment.getId());
        if (getCodeModMd != null) {
            List lstCodes = getCodeModMd.getLstAutoCode();
            AutoCode ac = new AutoCode();
            ac.setDescription("");
            ac.setLettreCode("");
            List lstMods = getCodeModMd.getLstAutoMod();
            if (lstCodes != null) {
                for (AutoCode autoCode : lstCodes) {
                    this.cmbCodeAuto1.add(String.valueOf(autoCode.getLettreCode()) + ": " + autoCode.getDescription());
                    this.cmbCodeAuto2.add(String.valueOf(autoCode.getLettreCode()) + ": " + autoCode.getDescription());
                    this.cmbCodeAuto3.add(String.valueOf(autoCode.getLettreCode()) + ": " + autoCode.getDescription());
                }
            }
            if (lstMods != null) {
                for (AutoMod m : lstMods) {
                    this.cmbModAuto1.add(String.valueOf(m.getLettreMod()) + ": " + m.getDescription());
                    this.cmbModAuto2.add(String.valueOf(m.getLettreMod()) + ": " + m.getDescription());
                    this.cmbModAuto3.add(String.valueOf(m.getLettreMod()) + ": " + m.getDescription());
                }
            }
            if (getCodeModMd.getFacturation() != null) {
                FacturationP fact = getCodeModMd.getFacturation();
                this.fillValue(fact);
            }
        }
    }

    private void fillValue(FacturationP f) {
        this.txtDxCode.getMyText().setText(f.getDxCode());
        this.txtDxCode.doSearch();
        this.txtDxDescr.setText(f.getDxDescr());
        this.txtNotes.setText(f.getNoteFact());
        this.chkToComplete.setSelection(f.getToComplete() == 1);
        List lstFe = f.getLstFacturationE();
        String[] codes = new String[]{"", "", ""};
        String[] mods = new String[]{"", "", ""};
        String lastMod = "";
        int i = 0;
        boolean firstBoucle = true;
        for (FacturationE fe : lstFe) {
            String m = StringUtils.defaultString((String)fe.getModFact(), (String)"").trim();
            if (firstBoucle) {
                firstBoucle = false;
                lastMod = m;
                mods[i] = m;
            }
            if (m.equals(lastMod)) {
                int n = i;
                codes[n] = String.valueOf(codes[n]) + fe.getCodeFact() + " ";
                continue;
            }
            lastMod = m;
            int n = ++i;
            codes[n] = String.valueOf(codes[n]) + fe.getCodeFact() + " ";
            int n2 = i;
            mods[n2] = String.valueOf(mods[n2]) + fe.getModFact() + " ";
        }
        this.txtCode1.setText(codes[0].trim());
        this.txtCode2.setText(codes[1].trim());
        this.txtCode3.setText(codes[2].trim());
        this.txtMod1.setText(mods[0].trim());
        this.txtMod2.setText(mods[1].trim());
        this.txtMod3.setText(mods[2].trim());
    }

    private void cancel() {
        this.dialog.close();
    }

    private void ok() {
        FacturationE fe;
        String c;
        int n;
        int n2;
        String[] stringArray;
        String mod;
        String[] codes;
        WSFactRamqClient ws = FacturationRamq.getInstanceWsc();
        FacturationP fp = new FacturationP();
        fp.setIdAppointment(this.appointment.getId());
        fp.setDateFact(new Integer(this.appointment.getDate().dayFrom1970));
        XCode xcode = (XCode)this.txtDxCode.getDataObject();
        if (xcode != null) {
            fp.setDxCode(xcode.getCode());
        }
        fp.setDxDescr(this.txtDxDescr.getText());
        fp.setFirstName(this.patient.getFirstName());
        fp.setLastName(this.patient.getLastName());
        fp.setGender(this.patient.getGender());
        fp.setNam(this.patient.getHealthInsuranceNumber());
        fp.setToComplete(this.chkToComplete.getSelection() ? new Integer(1) : new Integer(0));
        if (this.patient.getBirthDate() != null) {
            fp.setBirthDay(Long.valueOf(this.patient.getBirthDate().toTimeInMillisUTC()));
        }
        if (this.patient.getAddress1() != null) {
            fp.setAdresse1(StringUtils.truncate((String)this.patient.getStreet(), (int)30));
            if (this.patient.getCity() == null) {
                fp.setAdresse2(null);
            } else {
                fp.setAdresse2(StringUtils.truncate((String)this.patient.getCity().getName(), (int)30));
            }
            String postalCode = this.patient.getPostalCode();
            if (postalCode == null || postalCode.length() <= 6) {
                fp.setCp(postalCode);
            } else if ((postalCode = postalCode.replace(" ", "").replace("-", "")).length() > 6) {
                fp.setCp(null);
            } else {
                fp.setCp(postalCode);
            }
        }
        fp.setNoteFact(this.txtNotes.getText());
        ArrayList<FacturationE> lstFe = new ArrayList<FacturationE>();
        if (this.txtCode1.getText().trim().length() > 0) {
            codes = this.getAllLettersAndCodes(this.txtCode1.getText());
            mod = this.txtMod1.getText().trim();
            stringArray = codes;
            n2 = codes.length;
            n = 0;
            while (n < n2) {
                c = stringArray[n];
                fe = new FacturationE();
                fe.setCodeFact(c);
                fe.setModFact(mod);
                lstFe.add(fe);
                ++n;
            }
        }
        if (this.txtCode2.getText().trim().length() > 0) {
            codes = this.getAllLettersAndCodes(this.txtCode2.getText());
            mod = this.txtMod2.getText().trim();
            stringArray = codes;
            n2 = codes.length;
            n = 0;
            while (n < n2) {
                c = stringArray[n];
                fe = new FacturationE();
                fe.setCodeFact(c);
                fe.setModFact(mod);
                lstFe.add(fe);
                ++n;
            }
        }
        if (this.txtCode3.getText().trim().length() > 0) {
            codes = this.getAllLettersAndCodes(this.txtCode3.getText());
            mod = this.txtMod3.getText().trim();
            stringArray = codes;
            n2 = codes.length;
            n = 0;
            while (n < n2) {
                c = stringArray[n];
                fe = new FacturationE();
                fe.setCodeFact(c);
                fe.setModFact(mod);
                lstFe.add(fe);
                ++n;
            }
        }
        fp.getLstFacturationE().addAll(lstFe);
        Boolean result = ws.addFacturationRamq(this.professionnal.getNoAgenceRamq(), StringUtils.trim((String)this.professionnal.getCode()), fp);
        System.out.println(result);
        this.dialog.close();
    }

    public boolean open() {
        this.dialog.setSize(561, 600);
        UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
        this.dialog.open();
        UI.waitForWindowToClose((Shell)this.dialog);
        return true;
    }

    private String[] getAllLettersAndCodes(String s) {
        String[] ret = new String[]{};
        ArrayList<String> lst = new ArrayList<String>();
        if (s.length() > 0) {
            char[] codes = s.toCharArray();
            String cc = "";
            char[] cArray = codes;
            int n = codes.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (CharUtils.isAsciiNumeric((char)c)) {
                    cc = String.valueOf(cc) + String.valueOf(c);
                } else if (CharUtils.isAsciiAlpha((char)c)) {
                    if (cc.length() > 0) {
                        lst.add(cc);
                        cc = "";
                    }
                    lst.add(String.valueOf(c));
                } else if (cc.length() > 0) {
                    lst.add(cc);
                    cc = "";
                }
                ++n2;
            }
            if (cc.length() > 0) {
                lst.add(cc);
            }
            ret = new String[lst.size()];
            int i = 0;
            while (i < lst.size()) {
                ret[i] = (String)lst.get(i);
                ++i;
            }
        }
        return ret;
    }

    class ComboCodeSelectionListener
    extends SelectionAdapter {
        MyMaskedText txtCode;

        public ComboCodeSelectionListener(MyMaskedText txtMod) {
            this.txtCode = txtMod;
        }

        public void widgetSelected(SelectionEvent e) {
            Combo c = (Combo)e.getSource();
            try {
                String l = c.getText().substring(0, 1);
                String t = this.txtCode.getText();
                this.txtCode.setText(String.valueOf(t.trim().length() == 0 ? "" : t.trim()) + l + " ");
                int start = this.txtCode.getText().length();
                this.txtCode.setSelection(start, start);
            }
            catch (Exception err) {
                String errStringHelper = "Combo selected text/index: '" + c.getText() + "'/" + c.getSelectionIndex();
                logger.log(Level.SEVERE, "Erreur dans DoBillingRamqDialog : \n" + errStringHelper, err);
            }
        }
    }

    class ComboSelectionListener
    extends SelectionAdapter {
        MyMaskedText txtMod;

        public ComboSelectionListener(MyMaskedText txtMod) {
            this.txtMod = txtMod;
        }

        public void widgetSelected(SelectionEvent e) {
            Combo c = (Combo)e.getSource();
            String l = c.getText().substring(0, 1);
            this.txtMod.setText(l);
        }
    }

    class TxtModifyListener
    implements ModifyListener {
        MyMaskedText txtMod;
        boolean inModify = false;

        public TxtModifyListener(MyMaskedText txtMod) {
            this.txtMod = txtMod;
        }

        public void modifyText(ModifyEvent e) {
            String[] m;
            Text text = (Text)e.widget;
            String ss = text.getText().trim();
            String[] cds = ss.split(" ");
            if (cds.length > 1 && (m = this.txtMod.getText().split(" ")).length > 1) {
                this.txtMod.setText(m[0]);
            }
        }
    }
}

