/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util.kryoserializers;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.util.MiscUtil;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EditableDataObjectSerializer<T extends EditableDataObject>
extends Serializer<T> {
    private static final Logger logger = Logger.getLogger(EditableDataObjectSerializer.class.getName());
    private final Constructor<? extends EditableDataObject> _constructor;

    public EditableDataObjectSerializer(Class<? extends EditableDataObject> clazz) {
        try {
            this._constructor = clazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T read(Kryo k, Input input, Class<? extends T> t) {
        Integer tag = MiscUtil.toInt(input.readInt());
        Integer version = MiscUtil.toInt(input.readInt());
        EditableDataObject obj = null;
        try {
            obj = this._constructor.newInstance(new Object[0]);
            obj.setTag(tag);
            obj.setVersion(version);
            obj.modificationStatus.plain_set(ModificationStatus.from(Integer.valueOf(input.readByte())));
            k.reference((Object)obj);
            return (T)obj;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return (T)obj;
        }
    }

    public void write(Kryo k, Output output, T s) {
        output.writeInt(MiscUtil.fromInt(((EditableDataObject)s).getTag()));
        output.writeInt(MiscUtil.fromInt(((EditableDataObject)s).getVersion()));
        output.writeByte(((EditableDataObject)s).getModificationStatus().getValue());
    }
}

