/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.status;

import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.util1.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class MultiStatus
extends Status {
    private static final long serialVersionUID = 1L;
    private List<IStatus> childrens = new ArrayList<IStatus>();

    public List<IStatus> getChildrens() {
        return this.childrens;
    }

    public MultiStatus() {
        this("", null);
    }

    public MultiStatus(String message) {
        this(message, null);
    }

    public MultiStatus(String message, Throwable exception) {
        super(IStatus.Severity.OK, message, exception);
    }

    public IStatus[] getChildren() {
        return this.childrens.toArray(new IStatus[this.childrens.size()]);
    }

    public void add(IStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("status cant be null");
        }
        if (status == this) {
            throw new IllegalArgumentException("status cant be this");
        }
        this.childrens.add(status);
    }

    @Override
    public void setData(Serializable data) {
        super.setData(data);
    }

    @Override
    public IStatus.Severity getSeverity() {
        IStatus.Severity s = IStatus.Severity.OK;
        for (IStatus child : this.childrens) {
            s = MultiStatus.max(s, child.getSeverity());
        }
        return s;
    }

    private static IStatus.Severity max(IStatus.Severity s1, IStatus.Severity s2) {
        if (s1.compareTo(s2) < 0) {
            return s2;
        }
        return s1;
    }

    public Serializable getRootData() {
        return super.getData();
    }

    public String getRootCode() {
        return super.getCode();
    }

    public Throwable getRootException() {
        return super.getException();
    }

    public IStatus.Severity getRootSeverity() {
        return super.getSeverity();
    }

    public String getRootMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        ArrayList<String> messages = new ArrayList<String>(this.childrens.size() + 1);
        String message = super.getMessage();
        if (message.length() != 0) {
            messages.add(message);
            messages.add("");
        }
        for (IStatus child : this.childrens) {
            if (child.isOK() || (message = child.getMessage()) == null || message.length() == 0) continue;
            messages.add(message);
        }
        return StringUtils.join(messages, (String)"\r\n");
    }

    @Override
    public boolean isOK() {
        boolean ok = true;
        for (IStatus child : this.childrens) {
            if (!(ok &= child.isOK())) break;
        }
        return ok;
    }

    @Override
    public boolean isOkToProceed() {
        boolean okToProceed = true;
        if (this.childrens != null) {
            for (IStatus child : this.childrens) {
                if (okToProceed = okToProceed && child.isOkToProceed()) continue;
                break;
            }
        }
        return okToProceed;
    }

    public boolean hasCode(String code) {
        if (code == null) {
            return false;
        }
        return code.equals(this.getCode()) || this.getChildByCode(code) != null;
    }

    @Override
    public IStatus getStatus(String code) {
        return this.getChildByCode(code);
    }

    public IStatus getChildByCode(String code) {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        for (IStatus child : this.childrens) {
            if (child instanceof MultiStatus) {
                IStatus res = ((MultiStatus)child).getChildByCode(code);
                if (res == null) continue;
                return res;
            }
            if (!code.equals(child.getCode())) continue;
            return child;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultiStatus ");
        sb.append(super.getCode()).append(", ");
        sb.append(super.getMessage()).append(", ");
        sb.append(this.getException()).append(", [");
        int size = this.childrens.size();
        for (int i = 0; i < size; ++i) {
            IStatus child = this.childrens.get(i);
            if (child == OK_STATUS || child.isOK()) continue;
            sb.append(child);
            if (i >= size - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public List<IStatus> getFlattenedNonOKChildren() {
        return this.getFlattenedNonOKChildren(this);
    }

    private List<IStatus> getFlattenedNonOKChildren(MultiStatus child) {
        ArrayList<IStatus> newChildren = new ArrayList<IStatus>(this.childrens.size());
        for (IStatus status : child.childrens) {
            if (status instanceof MultiStatus) {
                newChildren.addAll(this.getFlattenedNonOKChildren((MultiStatus)status));
                continue;
            }
            if (status.isOK()) continue;
            newChildren.add(status);
        }
        return newChildren;
    }

    @Override
    public IStatus getStatus(IStatus.Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException();
        }
        if (severity == IStatus.Severity.OK) {
            for (IStatus child : this.childrens) {
                if (!child.isOK()) continue;
                return child;
            }
        }
        for (IStatus child : this.childrens) {
            IStatus status = child.getStatus(severity);
            if (status == null) continue;
            return status;
        }
        return null;
    }

    public void setChildrens(List<IStatus> childrens) {
        this.childrens = childrens;
    }
}

