/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.scan;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.util1.date.LocalDateRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class XScanImageContainer
implements Serializable {
    private static final long serialVersionUID = -1177988178851198194L;
    private transient XBaseProfessionnal professionnal;
    private Integer idProfessionnal;
    private transient IPatient patient;
    private Integer idPatient;
    private EnumSet<XPatientImageProfessionnalStatus> status;
    private List<XLabelDef> labels;
    private boolean allLabelDefs = false;
    private Set<XPatientImageResultType> results;
    private LocalDateRange documentDateRange;
    private LocalDateRange creationDateRange;
    private Integer idUser;
    private String sortBy;
    private Integer offsetPage;
    private Integer nbResultByPage;
    private String name;
    private EditableDataObjectList<XPatientImage> images = new EditableDataObjectList();
    private XBasePatientImage[] baseImages = new XBasePatientImage[0];
    private boolean getFuturAppts;
    public Boolean hasNextPage;

    public XScanImageContainer(int nbResultByPage) {
        try {
            this.setNbResultByPage(nbResultByPage);
        }
        catch (Exception e) {
            throw new NullPointerException(e.getMessage());
        }
    }

    public XScanImageContainer cloneWithoutObject() {
        XScanImageContainer c = new XScanImageContainer(this.nbResultByPage);
        c.allLabelDefs = this.allLabelDefs;
        c.creationDateRange = this.creationDateRange;
        c.documentDateRange = this.documentDateRange;
        c.idPatient = this.idPatient;
        c.idProfessionnal = this.idProfessionnal;
        c.idUser = this.idUser;
        c.sortBy = this.sortBy;
        c.offsetPage = this.offsetPage;
        c.name = this.name;
        c.nbResultByPage = this.nbResultByPage;
        if (this.status != null) {
            c.status = EnumSet.copyOf(this.status);
        }
        if (this.labels != null) {
            c.labels = new ArrayList<XLabelDef>(this.labels.size());
            for (XLabelDef labels : this.labels) {
                c.labels.add(labels);
            }
        }
        return c;
    }

    public EnumSet<XPatientImageProfessionnalStatus> getStatus() {
        return this.status;
    }

    public void addStatus(XPatientImageProfessionnalStatus status) {
        if (this.getStatus() == null) {
            this.setStatus(EnumSet.noneOf(XPatientImageProfessionnalStatus.class));
        }
        this.getStatus().add(status);
    }

    public void setStatus(EnumSet<XPatientImageProfessionnalStatus> status) {
        this.status = status;
    }

    public void addLabelDef(XLabelDef type) {
        if (type != null) {
            if (this.getLabelDefs() == null) {
                this.setLabelDefs(new ArrayList<XLabelDef>());
            }
            this.getLabelDefs().add(type);
        }
    }

    public List<XLabelDef> getLabelDefs() {
        return this.labels;
    }

    public void setLabelDefs(List<XLabelDef> types) {
        this.labels = types;
    }

    public Set<XPatientImageResultType> getResults() {
        return this.results;
    }

    public void setResults(Set<XPatientImageResultType> results) {
        this.results = results;
    }

    public void addResult(XPatientImageResultType result) {
        if (this.getResults() == null) {
            this.setResults(new HashSet<XPatientImageResultType>());
        }
        this.getResults().add(result);
    }

    public LocalDateRange getDocumentDateRange() {
        return this.documentDateRange;
    }

    public void setDocumentDateRange(LocalDateRange documentDateRange) {
        this.documentDateRange = documentDateRange;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<XLabelDef> getLabels() {
        return this.labels;
    }

    public void setLabels(List<XLabelDef> labels) {
        this.labels = labels;
    }

    public boolean isAllLabelDefs() {
        return this.allLabelDefs;
    }

    public void setAllLabelDefs(boolean allLabelDefs) {
        this.allLabelDefs = allLabelDefs;
    }

    public LocalDateRange getCreationDateRange() {
        return this.creationDateRange;
    }

    public void setCreationDateRange(LocalDateRange creationDateRange) {
        this.creationDateRange = creationDateRange;
    }

    public Integer getIdUser() {
        return this.idUser;
    }

    public void setIdUser(Integer idUser) {
        this.idUser = idUser;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void setPatient(IPatient patient) {
        this.patient = patient;
        this.idPatient = patient == null ? null : patient.getId();
    }

    public XBaseProfessionnal getProfessionnal() {
        return this.professionnal;
    }

    public void setProfessionnal(XBaseProfessionnal professionnal) {
        this.professionnal = professionnal;
        this.idProfessionnal = professionnal == null ? null : professionnal.getId();
    }

    public EditableDataObjectList<XPatientImage> getImages() {
        return this.images;
    }

    public void setImages(EditableDataObjectList<XPatientImage> images) {
        this.images = images;
    }

    public XBasePatientImage[] getBaseImages() {
        return this.baseImages;
    }

    public void setBaseImages(XBasePatientImage[] baseImages) {
        this.baseImages = baseImages;
    }

    public boolean getFuturAppts() {
        return this.getFuturAppts;
    }

    public void setFuturAppts(boolean getFuturAppts) {
        this.getFuturAppts = getFuturAppts;
    }

    public String toString() {
        StringBuilder st = new StringBuilder().append("[name=").append(this.getName());
        st.append(", orderby=").append(this.getSortBy());
        st.append(", creationDateRange=").append(this.getCreationDateRange());
        st.append(", status=").append(this.getStatus() == null ? "-" : Integer.valueOf(this.getStatus().size())).append("{");
        if (this.getStatus() != null) {
            Object[] objs = this.getStatus().toArray();
            for (int i = 0; i < this.getStatus().size(); ++i) {
                if (i != 0) {
                    st.append(", ");
                }
                st.append(objs[i].toString());
            }
        }
        st.append("}, idUser=").append(this.getIdUser()).append(", patient=").append(this.getPatient());
        return st.toString();
    }

    public Integer getOffsetPage() {
        return this.offsetPage;
    }

    public void setOffsetPage(Integer offsetPage) {
        this.offsetPage = offsetPage;
    }

    public Integer getNbResultByPage() {
        return this.nbResultByPage;
    }

    public void setNbResultByPage(Integer nbResultByPage) throws RuntimeException {
        this.nbResultByPage = nbResultByPage;
    }

    public Integer getIdProfessionnal() {
        return this.idProfessionnal;
    }

    public void setIdProfessionnal(Integer idProfessionnal) {
        this.idProfessionnal = idProfessionnal;
    }

    public Integer getIdPatient() {
        return this.idPatient;
    }

    public void setIdPatient(Integer idPatient) {
        this.idPatient = idPatient;
    }
}

