/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.medication;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableCompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public final class XDrugStrength
extends EditableDataObject
implements IEditableCompletionComboItem {
    private static final long serialVersionUID = 1L;
    public static final String type = "drugstrength";
    public Integer id;
    public String strength;
    public Integer din;
    public Set<String> ahfs;
    public Boolean isDeleted;
    public String name;
    public String searchName;
    public String baseName;
    public XDrugType drugType;
    public String searchBaseName;
    private String completeName;

    public XDrugStrength() {
        this.strength = "";
        this.isDeleted = false;
    }

    public XDrugStrength(String name) {
        this.strength = name;
        this.isDeleted = false;
    }

    @Override
    @Deprecated
    public void initialize() {
        this.setNew();
        this.strength = "";
        this.isDeleted = false;
    }

    @Override
    public String getText() {
        String n = this.getName();
        if (n == null) {
            n = this.getBaseName();
        }
        return n == null ? "" : n;
    }

    @Override
    public boolean isActive() {
        return Boolean.TRUE.equals(this.getIsDeleted());
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XDrugStrength) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XDrugStrength" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public XDrugStrength clone() {
        XDrugStrength c = (XDrugStrength)super.clone();
        c.id = this.id;
        c.din = this.din;
        c.strength = this.strength;
        c.isDeleted = this.isDeleted;
        c.name = this.name;
        c.baseName = this.baseName;
        c.searchName = this.searchName;
        c.searchBaseName = this.searchBaseName;
        c.ahfs = this.ahfs == null ? new LinkedHashSet<String>(0) : new LinkedHashSet<String>(this.ahfs);
        return c;
    }

    public String getCommercialName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setUpdated();
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    @Override
    public String getType() {
        return type;
    }

    public Integer getDin() {
        return this.din;
    }

    public void setDin(Integer din) {
        this.din = din;
        this.setUpdated();
    }

    public XDrugType getDrugType() {
        return this.drugType;
    }

    public void setDrugType(XDrugType drugType) {
        this.drugType = drugType;
        this.setUpdated();
    }

    public String getStrength() {
        return this.strength;
    }

    public void setStrength(String strength) {
        this.strength = strength;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getGenericName() {
        return this.baseName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public String getSearchBaseName() {
        return this.searchBaseName;
    }

    public void setSearchBaseName(String searchBaseName) {
        this.searchBaseName = searchBaseName;
    }

    @Override
    public String toString() {
        return String.format("XDrugStrength [id=%s, strength=%s, din=%s, ahfs=%s, isDeleted=%s, name=%s, baseName=%s]", this.id, this.strength, this.din, this.ahfs, this.isDeleted, this.name, this.baseName);
    }

    public Set<String> getAhfs() {
        return this.ahfs;
    }

    public void setAhfs(Set<String> ahfs) {
        this.ahfs = ahfs;
        this.setUpdated();
    }

    public String getCompleteName() {
        if (this.completeName == null) {
            ArrayList<String> list = new ArrayList<String>(2);
            if (!StringUtils.isBlank((CharSequence)this.name)) {
                list.add(this.name);
            }
            if (!StringUtils.isBlank((CharSequence)this.baseName)) {
                list.add(this.baseName);
            }
            if (list.size() == 1) {
                return (String)list.get(0);
            }
            if (list.size() == 2) {
                if (this.baseName.toUpperCase().equals(this.name.toUpperCase())) {
                    return this.baseName;
                }
                this.completeName = StringUtils.join(list, (String)", ");
            }
        }
        return this.completeName;
    }

    public void setCommercialName(String commercial) {
        this.setName(commercial);
    }

    public void setGenericName(String generic) {
        this.setBaseName(generic);
    }

    public void setCompleteName(String completeName2) {
        this.completeName = completeName2;
    }
}

