/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.laboresults;

import ca.infodata.ofys.data.middle.dataobjects.encounter.AHFS;
import ca.infodata.ofys.data.middle.dataobjects.encounter.DIN;
import ca.infodata.ofys.data.middle.dataobjects.encounter.ICode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCodeClassification;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class XLaboResultsCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Integer idPatient;
    public LocalDateRange dateRange;
    public boolean onlyAbnormal;
    public String typeCode;
    public String specificTypeCode;
    public String specificLoincCode;
    public List<ICode> codes;
    public Set<String> labTypeNames;
    public Set<AHFS> medicationAhfs;
    public Set<DIN> medicationDins;

    public List<ICode> getCodes(XCodeClassification c) {
        ArrayList<ICode> list = new ArrayList<ICode>();
        if (this.codes != null) {
            for (ICode code : this.codes) {
                if (code.getClassification() != c) continue;
                list.add(code);
            }
        }
        return list;
    }

    public boolean contains(ICode code) {
        if (code == null) {
            return false;
        }
        if (this.codes != null) {
            for (ICode e : this.codes) {
                if (e.getClassification() != code.getClassification() || !e.getCode().equals(code.getCode())) continue;
                return true;
            }
        }
        if (this.labTypeNames != null) {
            return this.labTypeNames.contains(code.getDescription());
        }
        return false;
    }

    public String toString() {
        return "XLaboResultsCriteria [idPatient=" + this.idPatient + ", dateRange=" + this.dateRange + ", onlyAbnormal=" + this.onlyAbnormal + ", typeCode=" + this.typeCode + ", specificTypeCode=" + this.specificTypeCode + ", codes=" + this.codes + ", labTypeNames=" + this.labTypeNames + ", medicationAhfs=" + this.medicationAhfs + ", medicationDins=" + this.medicationDins + "]";
    }

    public int hashCode() {
        String result = (this.idPatient == null ? "" : this.idPatient.toString()) + (this.dateRange == null ? "" : (this.dateRange.start == null ? "startnull" : ((LocalDate)this.dateRange.start).dayFrom1970 + "") + (this.dateRange.end == null ? "endnull" : ((LocalDate)this.dateRange.end).dayFrom1970 + "")) + (this.onlyAbnormal ? "abn" : "") + (this.typeCode == null ? "typeCode" : this.typeCode) + (this.specificTypeCode == null ? "specificTypeCode" : this.specificTypeCode) + (this.codes == null ? "codes" : new JoinList("", this.codes)) + (this.labTypeNames == null ? "labTypeNames" : new JoinList("", this.labTypeNames)) + (this.medicationAhfs == null ? "medicationAhfs" : new JoinList("", this.medicationAhfs)) + (this.medicationDins == null ? "medicationDins" : new JoinList("", this.medicationDins));
        return result.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }
}

