/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart;

import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Age;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.GrowChartPdfUtil;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Language;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.SEX_N_LANGUAGE;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.Sex;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LFA_WFA024 {
    private String fullname;
    private LocalDate birthdate;
    private String recordnumber;
    private String motherHeight;
    private String fatherHeight;
    private String gestionalAgeAtBirth;
    private int nbJrsPremature = 0;
    private Sex sex;
    private Language language;
    private boolean blackAndWhite;
    private List<Data> datas;

    public byte[] render() throws Exception {
        float rx;
        float dayStart;
        float ry;
        if (this.datas == null) {
            throw new NullPointerException("datas");
        }
        Collections.sort(this.datas, new Comparator<Data>(){

            @Override
            public int compare(Data o1, Data o2) {
                return o1.date.compareTo((IPartialDate)o2.date);
            }
        });
        byte[] pdf = GrowChartPdfUtil.readFile("LFA-WFA_Birth-24", this.getSex(), this.getLanguage(), this.isBlackAndWhite());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PdfReader reader = new PdfReader(pdf);
        PdfStamper stamper = new PdfStamper(reader, (OutputStream)output);
        boolean page = true;
        PdfContentByte overContent = stamper.getOverContent(1);
        BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        overContent.setFontAndSize(font, 10.0f);
        overContent.beginText();
        SEX_N_LANGUAGE sexLang = this.getSexLang();
        float x = 0.0f;
        float y = 0.0f;
        if (this.fullname != null) {
            switch (sexLang) {
                case BOYS_EN: {
                    x = 400.0f;
                    y = 730.0f;
                    break;
                }
                case BOYS_FR: {
                    x = 390.0f;
                    y = 735.0f;
                    break;
                }
                case GIRLS_EN: {
                    x = 400.0f;
                    y = 730.0f;
                    break;
                }
                case GIRLS_FR: {
                    x = 390.0f;
                    y = 729.0f;
                }
            }
            overContent.showTextAligned(0, this.fullname, x, y, 0.0f);
        }
        if (this.birthdate != null) {
            switch (sexLang) {
                case BOYS_EN: {
                    x = 395.0f;
                    y = 716.0f;
                    break;
                }
                case BOYS_FR: {
                    x = 385.0f;
                    y = 721.0f;
                    break;
                }
                case GIRLS_EN: {
                    x = 395.0f;
                    y = 716.0f;
                    break;
                }
                case GIRLS_FR: {
                    x = 385.0f;
                    y = 715.5f;
                }
            }
            overContent.showTextAligned(0, this.birthdate.formatSlash(), x, y, 0.0f);
        }
        if (this.recordnumber != null) {
            switch (sexLang) {
                case BOYS_EN: {
                    x = 526.0f;
                    y = 716.0f;
                    break;
                }
                case BOYS_FR: {
                    x = 526.0f;
                    y = 721.0f;
                    break;
                }
                case GIRLS_EN: {
                    x = 526.0f;
                    y = 716.0f;
                    break;
                }
                case GIRLS_FR: {
                    x = 526.0f;
                    y = 715.5f;
                }
            }
            overContent.showTextAligned(0, this.recordnumber, x, y, 0.0f);
        }
        if (this.motherHeight != null) {
            x = 320.0f;
            y = 178.0f;
            overContent.showTextAligned(0, this.motherHeight, x, y, 0.0f);
        }
        if (this.fatherHeight != null) {
            x = 320.0f;
            y = 166.5f;
            overContent.showTextAligned(0, this.fatherHeight, x, y, 0.0f);
        }
        if (this.gestionalAgeAtBirth != null) {
            x = 510.0f;
            y = 166.5f;
            overContent.showTextAligned(0, this.gestionalAgeAtBirth, x, y, 0.0f);
        }
        float xStart = 255.5f;
        float yStart = 72.0f;
        float xEnd = 571.5f;
        float yEnd = 150.0f;
        float dateXSize = 56.0f;
        float ageXSize = 60.0f;
        float lengthXSize = 57.0f;
        float weightXSize = 60.0f;
        overContent.setFontAndSize(font, 6.0f);
        int reportTextLinesNumber = 9;
        int datasOffset = Math.max(0, this.datas.size() - 9);
        boolean skipFirstLine = this.datas.size() > 0 && this.datas.get((int)(0 + datasOffset)).date != this.birthdate;
        int i = 0;
        while (i + datasOffset < this.datas.size()) {
            Data data = this.datas.get(i + datasOffset);
            y = skipFirstLine ? yEnd - 6.0f - (float)(i + 1) * 7.75f : yEnd - 6.0f - (float)i * 7.75f;
            x = xStart + 5.0f;
            overContent.showTextAligned(0, data.date.formatSlash(), x, y, 0.0f);
            if (data.date != this.birthdate) {
                x = xStart + 56.0f + 5.0f;
                overContent.showTextAligned(0, Age.formatMonthDay(this.getBirthdate(), data.date), x, y, 0.0f);
            }
            if (data.height != null) {
                x = xStart + 56.0f + 60.0f + 5.0f;
                overContent.showTextAligned(0, String.valueOf(data.height) + " cm", x, y, 0.0f);
            }
            if (data.weight != null) {
                x = xStart + 56.0f + 60.0f + 57.0f + 5.0f;
                overContent.showTextAligned(0, String.valueOf(data.weight.floatValue() / 1000.0f) + " kg", x, y, 0.0f);
            }
            if (data.comments != null) {
                x = xStart + 56.0f + 60.0f + 57.0f + 60.0f + 5.0f;
                overContent.showTextAligned(0, data.comments, x, y, 0.0f);
            }
            ++i;
        }
        switch (sexLang) {
            case BOYS_EN: {
                xStart = 125.0f;
                yStart = 251.5f;
                xEnd = 516.7f;
                yEnd = 689.0f;
                break;
            }
            case BOYS_FR: {
                xStart = 125.1f;
                yStart = 252.5f;
                xEnd = 516.7f;
                yEnd = 690.1f;
                break;
            }
            case GIRLS_EN: {
                xStart = 125.0f;
                yStart = 251.5f;
                xEnd = 516.7f;
                yEnd = 689.0f;
                break;
            }
            case GIRLS_FR: {
                xStart = 125.0f;
                yStart = 251.5f;
                xEnd = 516.7f;
                yEnd = 689.0f;
            }
        }
        float minYValue = this.getSex() == Sex.BOYS ? 17.0f : 17.0f;
        float maxYValue = this.getSex() == Sex.BOYS ? 102.0f : 102.0f;
        float minXValue = 0.0f;
        float maxXValue = 730.0f;
        ArrayList<Point> dots = new ArrayList<Point>();
        for (Data data : this.datas) {
            if (data.height == null) continue;
            ry = (data.height.floatValue() - minYValue) / (maxYValue - minYValue);
            dayStart = (float)(data.date.dayFrom1970 - this.birthdate.dayFrom1970 - this.getNbJrsPremature()) - minXValue;
            dayStart = dayStart < 0.0f ? 0.0f : dayStart;
            rx = dayStart / (maxXValue - minXValue);
            y = yStart + (yEnd - yStart) * ry;
            x = xStart + (xEnd - xStart) * rx;
            overContent.circle(x, y, 2.0f);
            dots.add(new Point(x, y));
        }
        for (int i2 = dots.size() - 1; i2 >= 0; --i2) {
            overContent.lineTo(((Point)dots.get((int)i2)).x, ((Point)dots.get((int)i2)).y);
        }
        switch (sexLang) {
            case BOYS_EN: {
                xStart = 125.0f;
                yStart = 72.0f;
                xEnd = 517.0f;
                yEnd = 524.0f;
                break;
            }
            case BOYS_FR: {
                xStart = 125.1f;
                yStart = 73.0f;
                xEnd = 516.7f;
                yEnd = 525.0f;
                break;
            }
            case GIRLS_EN: {
                xStart = 125.0f;
                yStart = 72.0f;
                xEnd = 517.0f;
                yEnd = 524.0f;
                break;
            }
            case GIRLS_FR: {
                xStart = 125.0f;
                yStart = 72.0f;
                xEnd = 516.7f;
                yEnd = 524.0f;
            }
        }
        minYValue = this.getSex() == Sex.BOYS ? 400.0f : 400.0f;
        maxYValue = this.getSex() == Sex.BOYS ? 18000.0f : 18000.0f;
        minXValue = 0.0f;
        maxXValue = 730.0f;
        dots = new ArrayList();
        for (Data data : this.datas) {
            if (data.weight == null) continue;
            ry = (data.weight.floatValue() - minYValue) / (maxYValue - minYValue);
            dayStart = (float)(data.date.dayFrom1970 - this.birthdate.dayFrom1970 - this.getNbJrsPremature()) - minXValue;
            dayStart = dayStart < 0.0f ? 0.0f : dayStart;
            rx = dayStart / (maxXValue - minXValue);
            y = yStart + (yEnd - yStart) * ry;
            x = xStart + (xEnd - xStart) * rx;
            overContent.circle(x, y, 2.0f);
            dots.add(new Point(x, y));
        }
        for (int i3 = dots.size() - 1; i3 >= 0; --i3) {
            overContent.lineTo(((Point)dots.get((int)i3)).x, ((Point)dots.get((int)i3)).y);
        }
        overContent.stroke();
        overContent.endText();
        stamper.close();
        return output.toByteArray();
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public LocalDate getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(LocalDate birthdate) {
        this.birthdate = birthdate;
    }

    public String getRecordnumber() {
        return this.recordnumber;
    }

    public void setRecordnumber(String recordnumber) {
        this.recordnumber = recordnumber;
    }

    public String getMotherHeight() {
        return this.motherHeight;
    }

    public void setMotherHeight(String motherHeight) {
        this.motherHeight = motherHeight;
    }

    public String getFatherHeight() {
        return this.fatherHeight;
    }

    public void setFatherHeight(String fatherHeight) {
        this.fatherHeight = fatherHeight;
    }

    public String getGestionalAgeAtBirth() {
        return this.gestionalAgeAtBirth;
    }

    public void setGestionalAgeAtBirth(String gestionalAgeAtBirth) {
        this.gestionalAgeAtBirth = gestionalAgeAtBirth;
    }

    public final int getNbJrsPremature() {
        return this.nbJrsPremature;
    }

    public final void setNbJrsPremature(int nbJrsPremature) {
        this.nbJrsPremature = nbJrsPremature;
    }

    public List<Data> getDatas() {
        return this.datas;
    }

    public void setDatas(List<Data> datas) {
        this.datas = datas;
    }

    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public boolean isBlackAndWhite() {
        return this.blackAndWhite;
    }

    public void setBlackAndWhite(boolean blackAndWhite) {
        this.blackAndWhite = blackAndWhite;
    }

    private SEX_N_LANGUAGE getSexLang() throws Exception {
        if (this.getLanguage() == Language.EN) {
            if (this.getSex() == Sex.BOYS) {
                return SEX_N_LANGUAGE.BOYS_EN;
            }
            if (this.getSex() == Sex.GIRLS) {
                return SEX_N_LANGUAGE.GIRLS_EN;
            }
        }
        if (this.getLanguage() == Language.FR) {
            if (this.getSex() == Sex.BOYS) {
                return SEX_N_LANGUAGE.BOYS_FR;
            }
            if (this.getSex() == Sex.GIRLS) {
                return SEX_N_LANGUAGE.GIRLS_FR;
            }
        }
        throw new Exception("unsupported combinaison of sex and language " + (Object)((Object)this.getSex()) + ", " + (Object)((Object)this.getLanguage()));
    }

    public static void main(String[] args) throws Exception {
        String name = "Steeve St-Laurent";
        LocalDate birthdate = Age.parse("2011/08/14");
        String recordnumber = "00015";
        String motherHeight = "150 cm";
        String fatherHeight = "170 cm";
        String gestionalAgeAtBirth = "40";
        ArrayList<Data> datas = new ArrayList<Data>();
        datas.add(new Data(Age.parse("2012/01/01"), Float.valueOf(2000.0f), Float.valueOf(45.0f), "bebe"));
        datas.add(new Data(Age.parse("2012/02/01"), Float.valueOf(3000.0f), Float.valueOf(50.0f), "mignon"));
        datas.add(new Data(Age.parse("2012/03/01"), Float.valueOf(4000.0f), Float.valueOf(55.0f), "joue"));
        datas.add(new Data(Age.parse("2012/04/01"), Float.valueOf(5000.0f), Float.valueOf(65.0f), "dort"));
        datas.add(new Data(Age.parse("2012/04/01"), Float.valueOf(6000.0f), Float.valueOf(70.0f), "rie"));
        datas.add(new Data(Age.parse("2012/05/01"), Float.valueOf(7000.0f), Float.valueOf(75.0f), "pleure"));
        datas.add(new Data(Age.parse("2012/06/01"), Float.valueOf(8000.0f), Float.valueOf(80.0f), "boie"));
        datas.add(new Data(Age.parse("2012/07/01"), Float.valueOf(9000.0f), Float.valueOf(81.0f), "crie"));
        datas.add(new Data(Age.parse("2012/08/01"), Float.valueOf(10000.0f), Float.valueOf(83.0f), "sourie"));
        datas.add(new Data(Age.parse("2012/09/01"), Float.valueOf(12000.0f), Float.valueOf(87.0f), "marche"));
        datas.add(new Data(Age.parse("2012/10/01"), Float.valueOf(14000.0f), Float.valueOf(90.0f), "tombe"));
        datas.add(new Data(Age.parse("2012/11/01"), Float.valueOf(16000.0f), Float.valueOf(102.0f), "attape"));
        datas.add(new Data(Age.parse("2012/11/01"), null, null, null));
        LFA_WFA024 report = new LFA_WFA024();
        report.setBirthdate(birthdate);
        report.setFatherHeight("170 cm");
        report.setMotherHeight("150 cm");
        report.setGestionalAgeAtBirth("40");
        report.setRecordnumber("00015");
        report.setFullname("Steeve St-Laurent");
        report.setDatas(datas);
        report.setSex(Sex.GIRLS);
        report.setLanguage(Language.EN);
        report.setBlackAndWhite(false);
        byte[] pdf = report.render();
        GrowChartPdfUtil.showWithExternalViewer(pdf);
    }

    public static class Data {
        public Float weight;
        public Float height;
        public LocalDate date;
        public String comments;

        public Data(LocalDate date, Float weightInGrams, Float heightInCm, String comments) {
            this.date = date;
            this.height = heightInCm;
            this.weight = weightInGrams;
            this.comments = comments;
        }
    }

    private static class Point {
        float x;
        float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

