/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.chat;

import ca.infodata.ofys.data.middle.dataobjects.XPersonType;
import ca.infodata.ofys.data.middle.dataobjects.chat.XCourrielDossier;
import ca.infodata.ofys.data.middle.dataobjects.chat.XCourrielTexte;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPerson;

public class XCourrielDest
extends EditableDataObject
implements Comparable<XCourrielDest> {
    private static final long serialVersionUID = 228224991578445851L;
    public static String[] fields = new String[]{"id", "idPerson", "personTypeInt", "readDate", "courrielDossierInt", "courrielTexteInt", "deleted", "toIdPat", "toIdProf", "toIdEmpl", "toNamePlus"};
    private int hashCode = Integer.MIN_VALUE;
    public Integer id;
    public Integer idPerson;
    public IPerson person;
    public Integer personTypeInt;
    public XPersonType personType;
    public Long readDate;
    public Integer courrielDossierInt;
    public XCourrielDossier courrielDossier;
    public Integer courrielTexteInt;
    public XCourrielTexte courrielTexte;
    public Boolean deleted;
    public String toNamePlus;
    public Integer toIdPat;
    public Integer toIdProf;
    public Integer toIdEmpl;

    public XCourrielDest() {
    }

    public XCourrielDest(Integer id) {
        this.setId(id);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.hashCode = Integer.MIN_VALUE;
    }

    public Integer getIdPerson() {
        return this.idPerson;
    }

    public void setIdPerson(Integer idPerson, XPersonType t) {
        this.idPerson = idPerson;
        if (t != null) {
            this.setPersonType(t);
            if (XPersonType.EMP.equals(t)) {
                this.setToIdEmpl(idPerson);
            } else if (XPersonType.PROF.equals(t)) {
                this.setToIdProf(idPerson);
            } else if (XPersonType.PAT.equals(t)) {
                this.setToIdPat(idPerson);
            } else if (XPersonType.SYST.equals(t)) {
                // empty if block
            }
        }
        this.setUpdated();
    }

    public void setIdPerson(Integer idPerson) {
        if (this.getPersonType() != null) {
            this.setIdPerson(idPerson, this.getPersonType());
        } else {
            this.idPerson = idPerson;
            this.setUpdated();
        }
    }

    public IPerson getPerson() {
        return this.person;
    }

    public void setPerson(IPerson person) {
        this.person = person;
        this.setUpdated();
    }

    public Integer getPersonTypeInt() {
        return this.personTypeInt;
    }

    public void setPersonTypeInt(Integer personTypeInt) {
        this.personTypeInt = personTypeInt;
        this.personType = XPersonType.from(personTypeInt);
    }

    public XPersonType getPersonType() {
        return this.personType;
    }

    public void setPersonType(XPersonType personType) {
        this.personType = personType;
        if (personType != null) {
            this.personTypeInt = personType.getValue();
        }
        this.setUpdated();
    }

    public String getToNamePlus() {
        return this.toNamePlus;
    }

    public void setToNamePlus(String toNamePlus) {
        this.toNamePlus = toNamePlus;
        this.setUpdated();
    }

    public Integer getToIdProf() {
        return this.toIdProf;
    }

    public void setToIdProf(Integer toIdProf) {
        this.toIdProf = toIdProf;
        this.setUpdated();
    }

    public Integer getToIdEmpl() {
        return this.toIdEmpl;
    }

    public void setToIdEmpl(Integer toIdEmpl) {
        this.toIdEmpl = toIdEmpl;
        this.setUpdated();
    }

    public Integer getToIdPat() {
        return this.toIdPat;
    }

    public void setToIdPat(Integer toIdPat) {
        this.toIdPat = toIdPat;
        this.setUpdated();
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public XCourrielDossier getCourrielDossier() {
        return this.courrielDossier;
    }

    public void setCourrielDossier(XCourrielDossier courrielDossier) {
        this.courrielDossier = courrielDossier;
        if (courrielDossier != null) {
            this.courrielDossierInt = courrielDossier.getValue();
        }
        this.setUpdated();
    }

    public Integer getCourrielTexteInt() {
        return this.courrielTexteInt;
    }

    public void setCourrielTexteInt(Integer courrielTexteInt) {
        this.courrielTexteInt = courrielTexteInt;
        this.setUpdated();
    }

    public XCourrielTexte getCourrielTexte() {
        return this.courrielTexte;
    }

    public void setCourrielTexte(XCourrielTexte courrielTexte) {
        this.courrielTexte = courrielTexte;
        this.courrielTexteInt = courrielTexte == null ? null : courrielTexte.getId();
        this.setUpdated();
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
        this.setUpdated();
    }

    public Long getReadDate() {
        return this.readDate;
    }

    public void setReadDate(Long readModificationEntryDate) {
        this.readDate = readModificationEntryDate;
        this.setUpdated();
    }

    public Integer getCourrielDossierInt() {
        return this.courrielDossierInt;
    }

    public void setCourrielDossierInt(Integer courrielDossierInt) {
        this.courrielDossierInt = courrielDossierInt;
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof XCourrielDest)) {
            return false;
        }
        XCourrielDest message = (XCourrielDest)obj;
        if (null == this.getId() || null == message.getId()) {
            return false;
        }
        return this.getId().equals(message.getId());
    }

    @Override
    public int hashCode() {
        if (Integer.MIN_VALUE == this.hashCode) {
            if (null == this.getId()) {
                return super.hashCode();
            }
            String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
            this.hashCode = hashStr.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(XCourrielDest o) {
        IPerson p1 = this.getPerson();
        IPerson p2 = o.getPerson();
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 != null && p2 == null) {
            return -1;
        }
        if (p1 == null && p2 != null) {
            return 1;
        }
        return p1.getName().compareToIgnoreCase(p2.getName());
    }
}

