/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.IImportance;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformationOrigin;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

public final class XAddress
extends EditableDataObject
implements KryoSerializable,
IImportance {
    public static String[] fields = new String[]{"id", "version", "importance", "street", "postalCode", "note", "city.id\u0131name", "province.id\u0131name", "country.id\u0131name"};
    private static final long serialVersionUID = -7917627366771128307L;
    public Integer id;
    public String street;
    public String postalCode;
    public Short importance;
    public String note;
    public XCountry country;
    public XCity city;
    public XProvince province;
    public XContactInformationOrigin origin;

    @Override
    public void write(Kryo k, Output out) {
        out.writeInt(MiscUtil.fromInt(this.id));
        out.writeString(MiscUtil.fromString(this.street));
        out.writeString(MiscUtil.fromString(this.postalCode));
        out.writeString(MiscUtil.fromString(this.note));
        out.writeShort((int)MiscUtil.fromShort(this.importance));
        if (this.city == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(MiscUtil.fromInt(this.city.id));
            out.writeString(MiscUtil.fromString(this.city.getName()));
        }
        if (this.province == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(MiscUtil.fromInt(this.province.id));
            out.writeString(MiscUtil.fromString(this.province.getName()));
        }
        if (this.country == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeInt(MiscUtil.fromInt(this.country.id));
            out.writeString(MiscUtil.fromString(this.country.getName()));
        }
        super.write(k, out);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.id = MiscUtil.toInt(in.readInt());
        this.street = MiscUtil.toString(in.readString());
        this.postalCode = MiscUtil.toString(in.readString());
        this.note = MiscUtil.toString(in.readString());
        this.importance = MiscUtil.toShort(in.readShort());
        if (in.readByte() == 1) {
            this.city = new XCity(MiscUtil.toInt(in.readInt()), MiscUtil.toString(in.readString()));
        }
        if (in.readByte() == 1) {
            this.province = new XProvince(MiscUtil.toInt(in.readInt()), MiscUtil.toString(in.readString()));
        }
        if (in.readByte() == 1) {
            this.country = new XCountry(MiscUtil.toInt(in.readInt()), MiscUtil.toString(in.readString()));
        }
        super.read(k, in);
    }

    @Override
    public void initialize() {
        this.setStreet("");
        this.setPostalCode("");
        this.setNote("");
        this.setCity(null);
        this.setProvince(null);
        this.setCountry(new XCountry("CANADA"));
        this.setImportance((short)0);
        this.setNeutral();
        this.setNew();
        assert (this.isNew());
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty() || this.country != null && this.country.isDirty() || this.city != null && this.city.isDirty() || this.province != null && this.province.isDirty();
        return dirty;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
        this.setUpdated();
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        this.setUpdated();
    }

    public String getFormattedPostalCode() {
        String postalCode = this.getPostalCode();
        if (postalCode != null && postalCode.length() == 6) {
            postalCode = postalCode.substring(0, 3) + " " + postalCode.substring(3);
        }
        return postalCode;
    }

    @Override
    public Short getImportance() {
        return this.importance;
    }

    @Override
    public void setImportance(Short importance) {
        this.importance = importance;
        this.setUpdatedOrder();
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.setUpdated();
    }

    public XCountry getCountry() {
        return this.country;
    }

    public void setCountry(XCountry country) {
        this.country = country;
        this.setUpdated();
    }

    public XCity getCity() {
        return this.city;
    }

    public void setCity(XCity city) {
        this.city = city;
        this.setUpdated();
    }

    public XProvince getProvince() {
        return this.province;
    }

    public void setProvince(XProvince province) {
        this.province = province;
        this.setUpdated();
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XAddress" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XAddress) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public String toString() {
        return "Importance: " + this.getImportance() + ", " + this.getStreet() + ", " + (this.getCity() == null ? "" : this.getCity().getName()) + ", " + (this.getProvince() == null ? "" : this.getProvince().getName()) + ", " + (this.getPostalCode() == null ? "" : this.getPostalCode() + ", ") + (this.getCountry() == null ? "" : this.getCountry().getName()) + ", " + this.getNote() + ", id = " + this.getId();
    }

    @Override
    public XAddress clone() {
        XAddress c = (XAddress)super.clone();
        c.id = this.id;
        c.street = this.street;
        c.postalCode = this.postalCode;
        c.importance = this.importance;
        c.note = this.note;
        if (this.country != null) {
            c.country = this.country.clone();
        }
        if (this.city != null) {
            c.city = this.city.clone();
        }
        if (this.province != null) {
            c.province = this.province.clone();
        }
        return c;
    }

    public static String complete(XAddress ad) {
        String street = ad.getStreet();
        String city = ad.getCity() == null ? null : ad.getCity().getName();
        String province = ad.getProvince() == null ? null : ad.getProvince().getName();
        String country = ad.getCountry() == null ? null : ad.getCountry().getName();
        String postalCode = ad.getPostalCode();
        if (postalCode != null && postalCode.length() == 6) {
            postalCode = postalCode.substring(0, 3) + " " + postalCode.substring(3);
        }
        JoinList list = new JoinList(", ", 3);
        list.setTrim(true);
        list.add((CharSequence)street);
        list.add((CharSequence)city);
        list.add((CharSequence)province);
        list.add((CharSequence)country);
        list.add((CharSequence)postalCode);
        return list.toString();
    }

    public XContactInformationOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(XContactInformationOrigin origin) {
        this.setUpdated();
        this.origin = origin;
    }

    public String getIsoCode3166_1() {
        if (this.country == null) {
            return null;
        }
        if (this.province == null) {
            return null;
        }
        String countryName = this.country.getName().trim().toLowerCase();
        if (!countryName.equals("canada") && !countryName.equals("ca")) {
            return null;
        }
        String part1 = "CA";
        return part1;
    }

    public void setIsoCode3166_2(String isoCode) throws IllegalArgumentException {
        String[] split = isoCode.split("-", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("unsupported iso code " + isoCode);
        }
        String countryCode = split[0].trim().toLowerCase();
        if (!countryCode.equals("ca")) {
            throw new IllegalArgumentException("unsupported iso code " + isoCode);
        }
        this.setCountry(new XCountry("CANADA"));
        String provinceCode = split[1].trim().toLowerCase();
        if (provinceCode.equals("qc")) {
            this.setProvince(new XProvince("QC"));
        } else if (provinceCode.equals("on")) {
            this.setProvince(new XProvince("ON"));
        } else if (provinceCode.equals("ns")) {
            this.setProvince(new XProvince("NS"));
        } else if (provinceCode.equals("nb")) {
            this.setProvince(new XProvince("NB"));
        } else if (provinceCode.equals("ab")) {
            this.setProvince(new XProvince("AB"));
        } else if (provinceCode.equals("bc")) {
            this.setProvince(new XProvince("BC"));
        } else if (provinceCode.equals("mb")) {
            this.setProvince(new XProvince("MB"));
        } else if (provinceCode.equals("NL")) {
            this.setProvince(new XProvince("NL"));
        } else if (provinceCode.equals("PE")) {
            this.setProvince(new XProvince("PE"));
        } else if (provinceCode.equals("SK")) {
            this.setProvince(new XProvince("SK"));
        } else {
            throw new IllegalArgumentException("unsupported iso code " + isoCode);
        }
    }

    public String getIsoCode3166_2() {
        if (this.country == null) {
            return null;
        }
        if (this.province == null) {
            return null;
        }
        String countryName = this.country.getName().trim().toLowerCase();
        if (!countryName.equals("canada") && !countryName.equals("ca")) {
            return null;
        }
        String part1 = "CA";
        String part2 = null;
        String provinceName = StringUtils.convertNonAscii((String)this.province.getName().trim().toLowerCase());
        if (provinceName.equals("qc") || provinceName.equals("quebec")) {
            part2 = "QC";
        }
        if (provinceName.equals("on") || provinceName.equals("ontario")) {
            part2 = "ON";
        }
        if (provinceName.equals("ns") || provinceName.equals("nova scotia") || provinceName.equals("nouvelle-ecosse")) {
            part2 = "NS";
        } else if (provinceName.equals("nb") || provinceName.equals("new brunswick") || provinceName.equals("nouveau-brunswick")) {
            part2 = "NB";
        } else if (provinceName.equals("ab") || provinceName.equals("alberta")) {
            part2 = "AB";
        } else if (provinceName.equals("bc") || provinceName.equals("british columbia") || provinceName.equals("colombie-britannique")) {
            part2 = "BC";
        } else if (provinceName.equals("mb") || provinceName.equals("manitoba")) {
            part2 = "MB";
        } else if (provinceName.equals("nl") || provinceName.equals("newfoundland and labrador") || provinceName.equals("terre-neuve-et-labrador")) {
            part2 = "NL";
        } else if (provinceName.equals("pe") || provinceName.equals("prince edward island") || provinceName.equals("ile-du-prince-edouard") || provinceName.equals("pei") || provinceName.equals("ipe")) {
            part2 = "PE";
        } else if (provinceName.equals("sk") || provinceName.equals("saskatchewan")) {
            part2 = "SK";
        }
        if (part2 == null) {
            return null;
        }
        return part1 + "-" + part2;
    }
}

