/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqThreadFactory;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.library.UI;
import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.MqttClientTransportConfigBuilder;
import com.hivemq.client.mqtt.MqttProxyConfig;
import com.hivemq.client.mqtt.MqttProxyConfigBuilder;
import com.hivemq.client.mqtt.MqttProxyProtocol;
import com.hivemq.client.mqtt.MqttWebSocketConfig;
import com.hivemq.client.mqtt.MqttWebSocketConfigBuilder;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishBuilder;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3SubscriptionBuilder;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3UnsubscribeBuilder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class RabbitMqConnectionMqtt
implements Consumer<Mqtt3Publish> {
    private static final Logger logger = Logger.getLogger(RabbitMqConnectionMqtt.class.getName());
    private static final String mqUser = "ofysMqttWs" + (UI.OS_MAC ? "Mac" : (UI.OS_WINDOWS ? "Win" : "Lin"));
    private static final String mqPswd = "mqdWrt56LLlsZ174g";
    private static final String exchange = "ofys_app";
    private ExecutorService bindingExecutor;
    private Mqtt3AsyncClient client;
    private final ReentrantLock publishChannelLock = new ReentrantLock();
    private final ReentrantLock consumeChannelLock = new ReentrantLock();
    private final String queueName;
    private final XSession session;
    private volatile boolean active;

    public RabbitMqConnectionMqtt(XSession session) throws Exception {
        this.session = session;
        int sessionId = session.id;
        String userName = session.user.name;
        String clientCode = session.getClient().getClientCode();
        this.queueName = String.valueOf(clientCode) + "_" + userName + "_" + sessionId;
        this.createConnexion(this.session);
        this.bindingExecutor = Executors.newCachedThreadPool(new RabbitMqThreadFactory("rabbitmq-binding"));
    }

    abstract void onConnexionSuccess();

    private void createConnexion(XSession session) {
        try {
            String subProt = "ws";
            boolean isSsl = false;
            TrustManagerFactory trustManagerFactory = null;
            String mqIsSsl = System.getProperty("mq_ssl");
            String proxyHost = System.getProperty("http.proxyHost");
            String proxyPorts = System.getProperty("http.proxyPort");
            if (StringUtils.isEmpty((CharSequence)proxyHost)) {
                proxyHost = System.getProperty("proxyHost");
            }
            if (StringUtils.isEmpty((CharSequence)proxyPorts)) {
                proxyPorts = System.getProperty("proxyPort");
            }
            if ("true".equals(mqIsSsl)) {
                String p;
                subProt = "wss";
                isSsl = true;
                String h = System.getProperty("https.proxyHost");
                if (StringUtils.isNotEmpty((CharSequence)h)) {
                    proxyHost = h;
                }
                if (StringUtils.isNotEmpty((CharSequence)(p = System.getProperty("https.proxyPort")))) {
                    proxyPorts = p;
                }
            }
            int proxyPort = 0;
            if (StringUtils.isNotEmpty((CharSequence)proxyPorts)) {
                try {
                    proxyPort = Integer.parseInt(proxyPorts);
                }
                catch (Exception exception2) {}
            }
            if (isSsl) {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null, null);
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
            }
            MqttProxyConfig proxy = null;
            if (proxyPort > 0) {
                proxy = ((MqttProxyConfigBuilder)((MqttProxyConfigBuilder)((MqttProxyConfigBuilder)MqttProxyConfig.builder().host(proxyHost)).port(proxyPort)).protocol(MqttProxyProtocol.HTTP)).build();
            }
            MqttWebSocketConfig ws = ((MqttWebSocketConfigBuilder)((MqttWebSocketConfigBuilder)MqttWebSocketConfig.builder().serverPath("/ws")).subprotocol(subProt)).build();
            String address = Application.get().getGlobalInstances().getMessageQueueConnectionInfo().getAddress();
            int mqPort = Application.get().getGlobalInstances().getMessageQueueConnectionInfo().getMqPort();
            MqttClientTransportConfigBuilder webSocketConfig = (MqttClientTransportConfigBuilder)((MqttClientTransportConfigBuilder)((MqttClientTransportConfigBuilder)((MqttClientTransportConfigBuilder)MqttClientTransportConfig.builder().proxyConfig(proxy)).serverHost(address)).serverPort(mqPort)).webSocketConfig(ws);
            if (isSsl) {
                ArrayList<String> lstProt = new ArrayList<String>(1);
                lstProt.add("wss");
                ((MqttClientSslConfigBuilder.Nested)((MqttClientSslConfigBuilder.Nested)((MqttClientSslConfigBuilder.Nested)((MqttClientSslConfigBuilder.Nested)webSocketConfig.sslConfig().trustManagerFactory(trustManagerFactory)).keyManagerFactory(null)).hostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                })).protocols(lstProt)).applySslConfig();
            }
            MqttClientTransportConfig tsp = webSocketConfig.build();
            this.client = ((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)Mqtt3Client.builder().identifier(this.queueName)).automaticReconnectWithDefaultConfig()).addConnectedListener(new MqttClientConnectedListener(){

                public void onConnected(MqttClientConnectedContext context) {
                    System.out.println("Connected! " + context.getClientConfig().getConnectionConfig().toString());
                    RabbitMqConnectionMqtt.this.active = true;
                    RabbitMqConnectionMqtt.this.onConnexionSuccess();
                }
            })).addDisconnectedListener(new MqttClientDisconnectedListener(){

                public void onDisconnected(MqttClientDisconnectedContext context) {
                    System.out.println("DISConnected! " + context.getClientConfig().getConnectionConfig().toString());
                    RabbitMqConnectionMqtt.this.active = false;
                }
            })).transportConfig(tsp)).buildAsync();
            ((CompletableFuture)((Mqtt3ConnectBuilder.Send)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)this.client.connectWith().simpleAuth().username(mqUser)).password(mqPswd.getBytes())).applySimpleAuth()).send()).whenComplete((ack, exception) -> {
                if (exception == null) {
                    logger.info("conneciont: success -> " + ack);
                    this.active = true;
                } else {
                    logger.log(Level.SEVERE, "conneciont: failure", (Throwable)exception);
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "createConnexion - newConnection error ", e);
        }
    }

    protected abstract void onFailure();

    private synchronized void fail() {
        if (this.isActive()) {
            logger.info("RabbitMqConnection.fail()");
            this.close(false);
            this.onFailure();
        } else {
            logger.info("RabbitMqConnection already has failed.");
        }
    }

    private void setInactive() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void basicPublish(String routingKey, Properties properties, byte[] body) throws Exception {
        block6: {
            if (this.isActive()) {
                try {
                    logger.info("basic publish to " + routingKey);
                    this.publishChannelLock.lock();
                    ((Mqtt3PublishBuilder.Send.Complete)((Mqtt3PublishBuilder.Send.Complete)((Mqtt3PublishBuilder.Send.Complete)this.client.publishWith().topic(routingKey)).payload(body)).qos(MqttQos.AT_LEAST_ONCE)).send();
                    break block6;
                }
                finally {
                    this.publishChannelLock.unlock();
                }
            }
            logger.log(Level.SEVERE, "Failed to publish on channel with binding " + routingKey + " to exchange " + exchange + " because connection has failed");
        }
    }

    public void queueBindAsync(String bindingKey) {
        if (this.isActive()) {
            this.bindingExecutor.submit(new QueueBindRunnable(bindingKey));
        } else {
            logger.log(Level.SEVERE, "Failed to ADD bindingKey " + bindingKey + " to queue " + this.queueName + " because connection has failed");
        }
    }

    public void queueUnbindAsync(String bindingKey) {
        if (this.isActive()) {
            this.bindingExecutor.submit(new QueueUnbindRunnable(bindingKey));
        } else {
            logger.log(Level.SEVERE, "Failed to REMOVE bindingKey " + bindingKey + " from queue " + this.queueName + " because connection has failed");
        }
    }

    public void applicationShudown() {
        this.setInactive();
        if (this.client != null) {
            logger.log(Level.INFO, "Close: Connection abort");
            try {
                try {
                    this.client.disconnect();
                }
                catch (Exception exception) {
                    this.client = null;
                }
            }
            finally {
                this.client = null;
            }
        }
    }

    public void close(boolean deleteQueue) {
        logger.log(Level.FINE, "RabbitMqConnection.close");
        this.setInactive();
        if (this.client != null) {
            logger.log(Level.INFO, "Close: Connection abort");
            try {
                try {
                    this.client.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.client = null;
                }
            }
            finally {
                this.client = null;
            }
        }
    }

    private final class QueueBindRunnable
    implements Runnable {
        private final String bindingKey;

        private QueueBindRunnable(String bindingKey) {
            this.bindingKey = bindingKey;
        }

        @Override
        public void run() {
            try {
                try {
                    RabbitMqConnectionMqtt.this.consumeChannelLock.lock();
                    logger.log(Level.INFO, "Would add bindingKey " + this.bindingKey + " to queue " + RabbitMqConnectionMqtt.this.queueName);
                    ((Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Complete)((Mqtt3SubscriptionBuilder.Nested.Complete)((Mqtt3SubscriptionBuilder.Nested.Complete)RabbitMqConnectionMqtt.this.client.subscribeWith().addSubscription().topicFilter(this.bindingKey)).qos(MqttQos.AT_LEAST_ONCE)).applySubscription()).callback((Consumer)RabbitMqConnectionMqtt.this).send().whenComplete((ack, exception) -> {
                        if (exception == null) {
                            logger.info("subscribe: success -> " + ack);
                        } else {
                            logger.log(Level.SEVERE, "subscribe: failure", (Throwable)exception);
                        }
                    });
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to ADD bindingKey " + this.bindingKey + " to queue " + RabbitMqConnectionMqtt.this.queueName, e);
                    RabbitMqConnectionMqtt.this.consumeChannelLock.unlock();
                }
            }
            finally {
                RabbitMqConnectionMqtt.this.consumeChannelLock.unlock();
            }
        }
    }

    private final class QueueUnbindRunnable
    implements Runnable {
        private final String bindingKey;

        private QueueUnbindRunnable(String bindingKey) {
            this.bindingKey = bindingKey;
        }

        @Override
        public void run() {
            try {
                try {
                    RabbitMqConnectionMqtt.this.consumeChannelLock.lock();
                    ((Mqtt3UnsubscribeBuilder.Send.Complete)RabbitMqConnectionMqtt.this.client.unsubscribeWith().addTopicFilter(this.bindingKey)).send();
                    logger.log(Level.INFO, "REMOVED bindingKey " + this.bindingKey + " from queue " + RabbitMqConnectionMqtt.this.queueName);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to REMOVE bindingKey " + this.bindingKey + " from queue " + RabbitMqConnectionMqtt.this.queueName, e);
                    RabbitMqConnectionMqtt.this.consumeChannelLock.unlock();
                }
            }
            finally {
                RabbitMqConnectionMqtt.this.consumeChannelLock.unlock();
            }
        }
    }
}

