/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.callback;

import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Callback
implements ICallback {
    private static final Logger logger = Logger.getLogger(Callback.class.getName());
    private String functionName = "";
    protected boolean wasUsedOnServer = false;
    private final IStatusHandler statusHandler;
    protected boolean killed = false;
    protected boolean processMessages;
    private Exception exception;
    public boolean showMessage = true;

    public Callback() {
        this(BaseAccessorClient.defaultStatusHandler);
    }

    public Callback(IStatusHandler statusHandler) {
        if (statusHandler == null) {
            throw new NullPointerException("statusHandler");
        }
        this.statusHandler = statusHandler;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public final void response(ReturnObject response) {
        this.wasUsedOnServer = true;
        BaseAccessorClient.serverResponseReceived(this.functionName);
        if (response == null) {
            logger.log(Level.FINE, "response is null. " + this.toString());
        }
        if (this.handleStatus(response)) {
            try {
                this.responseReceived(response);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in Callback response. " + this.toString(), e);
            }
        }
    }

    protected boolean handleStatus(ReturnObject response) {
        try {
            IStatusHandler handler = this.getStatusHandler();
            if (response != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "handler=" + String.valueOf(handler) + " status=" + String.valueOf(response.getStatus()));
                }
                handler.handle((IStatus)response.getStatus());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in Callback status handling. " + this.toString(), e);
        }
        return true;
    }

    public void responseReceived(ReturnObject response) {
    }

    @Override
    public void setFunctionName(String name) {
        this.functionName = name;
    }

    @Override
    public void kill() {
        this.killed = true;
    }

    public boolean killed() {
        return this.killed;
    }

    public String toString() {
        return String.format("%s {functionName=%s, killed=%s, wasUsedOnServer=%s}", this.getClass().getSimpleName(), this.getFunctionName(), this.killed(), this.wasUsedOnServer);
    }

    public IStatusHandler getStatusHandler() {
        return this.statusHandler;
    }

    @Override
    public void exception(Exception e) {
        this.exception = e;
        this.kill();
        if (this.showMessage) {
            MessageUtil.show(e);
        }
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

