/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IUserAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XBasePerson;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.signatures.XUserSignatures;
import ca.infodata.ofys.ui.library.log.Log;
import java.util.List;
import java.util.logging.Level;

public class UserAccessorClient
extends BaseAccessorClient {
    private static UserAccessorClient instance;
    private final IUserAccessor accessor;

    public static UserAccessorClient getInstance() throws CannotConnectToServerException {
        return UserAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static UserAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new UserAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private UserAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getUserAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void getUserDashboardDocsLabosOnlyCounts(XSession session, final Integer idProf, final Boolean excludeMySeen, final ICallback callback) {
        if (this.isOkToCallFunction("UserAccessorClient.getUserDashboardDocsLabosOnlyCounts", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject ret = instance.accessor.getUserDashboardDocsLabosOnlyCounts(idProf, excludeMySeen);
                            callback.response(ret);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            UserAccessorClient.this.functionCallEnded("UserAccessorClient.getUserDashboardDocsLabosOnlyCounts", callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded("UserAccessorClient.getUserDashboardDocsLabosOnlyCounts", callback);
                    }
                    return callback;
                }
            };
        } else {
            callback.kill();
        }
    }

    public void getUserDashboardCountsTaskMsg(XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("UserAccessorClient.getUserDashboardCountsTaskMsg", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject ret = instance.accessor.getUserDashboardCountsTaskMsg();
                            callback.response(ret);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            UserAccessorClient.this.functionCallEnded("UserAccessorClient.getUserDashboardCountsTaskMsg", callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded("UserAccessorClient.getUserDashboardCountsTaskMsg", callback);
                    }
                    return callback;
                }
            };
        } else {
            callback.kill();
        }
    }

    public void getUserDashboardCountsAllButSafir(XSession session, final Integer idProf, final Boolean excludeMySeen, final ICallback callback) {
        if (this.isOkToCallFunction("UserAccessorClient.getUserDashboardCountsAllButSafir", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject ret = instance.accessor.getUserDashboardCountsAllButSafir(idProf, excludeMySeen);
                            callback.response(ret);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            UserAccessorClient.this.functionCallEnded("UserAccessorClient.getUserDashboardCountsAllButSafir", callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded("UserAccessorClient.getUserDashboardCountsAllButSafir", callback);
                    }
                    return callback;
                }
            };
        } else {
            callback.kill();
        }
    }

    public void getActiveUsers(final ICallback callback, XSession session) {
        if (this.isOkToCallFunction("UserAccessorClient.getActiveUsers", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getActiveUsers());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            UserAccessorClient.this.functionCallEnded("UserAccessorClient.getActiveUsers", callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded("UserAccessorClient.getActiveUsers", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public List<XBasePerson> getBlockedUsers() throws Exception {
        if (this.isOkToCallFunction("UserAccessorClient.getBlockedUsers")) {
            try {
                ReturnObject returnObject = UserAccessorClient.instance.accessor.getBlockedUsers();
                List list = (List)(returnObject == null ? null : returnObject.getObj());
                return list;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get blocked xbaseUser ", e);
                throw e;
            }
            finally {
                this.functionCallEnded("UserAccessorClient.getBlockedUsers");
            }
        }
        return null;
    }

    public XBaseUser getBaseUserSync(XSession session, Integer userId) throws Exception {
        String function = "UserAccessorClient.getBaseUser" + userId;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = UserAccessorClient.instance.accessor.getBaseUser(userId.intValue());
                XBaseUser xBaseUser = (XBaseUser)(returnObject == null ? null : returnObject.getObj());
                return xBaseUser;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get base user " + userId, e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public XBaseUser getBaseUserByIdPersonSync(XSession session, Integer idPerson) throws Exception {
        String function = "UserAccessorClient.getBaseUserByIdPerson" + idPerson;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = UserAccessorClient.instance.accessor.getBaseUserByIdPerson(idPerson.intValue());
                XBaseUser xBaseUser = (XBaseUser)(returnObject == null ? null : returnObject.getObj());
                return xBaseUser;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get base user by id person" + idPerson, e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public XUserSignatures getUserSignatures(XSession session, Integer idUserAnchor) throws Exception {
        String function = "UserAccessorClient.getUserSignatures" + idUserAnchor;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = UserAccessorClient.instance.accessor.getUserSignatures(idUserAnchor.intValue());
                XUserSignatures xUserSignatures = (XUserSignatures)(returnObject == null ? null : returnObject.getObj());
                return xUserSignatures;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to getUserSignatures for idUserAnchor " + idUserAnchor, e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public void getUserSignatures(final ICallback callback, XSession session, final Integer idUserAnchor) {
        if (this.isOkToCallFunction("UserAccessorClient.getUserSignatures" + idUserAnchor, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.getUserSignatures(idUserAnchor.intValue());
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            UserAccessorClient.this.functionCallEnded("UserAccessorClient.getUserSignatures", callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded("UserAccessorClient.getUserSignatures", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void changePasswordUser(final ICallback callback, XSession session, final String oldPassword, final String newPassword) {
        if (this.isOkToCallFunction("UserAccessorClient.changePasswordUser", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.changePasswordUser(oldPassword, newPassword));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            UserAccessorClient.this.functionCallEnded("UserAccessorClient.changePasswordUser", callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded("UserAccessorClient.changePasswordUser", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void unblockUser(final ICallback callback, XSession session, final int idUser) {
        final String function = "UserAccessorClient.unblockUser" + idUser;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.unblockUser(idUser));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            UserAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getAllUsers(final ICallback callback, XSession session) {
        if (this.isOkToCallFunction("UserAccessorClient.getAllUsersClients", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getAllUsers());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            UserAccessorClient.this.functionCallEnded("UserAccessorClient.getAllUsersClients", callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded("UserAccessorClient.getAllUsersClients", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void listUsersForSelection(final ICallback callback, XSession session) {
        if (this.isOkToCallFunction("UserAccessorClient.listUsersForSelection", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.listUsersForSelection());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            UserAccessorClient.this.functionCallEnded("UserAccessorClient.getAllUsersClients", callback);
                        }
                    }
                    finally {
                        UserAccessorClient.this.functionCallEnded("UserAccessorClient.getAllUsersClients", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void listUsersForSelectionSync(ICallback callback, XSession session) {
        if (this.isOkToCallFunction("UserAccessorClient.listUsersForSelection", callback)) {
            try {
                try {
                    callback.response(UserAccessorClient.instance.accessor.listUsersForSelection());
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("UserAccessorClient.getAllUsersClients", callback);
                }
            }
            finally {
                this.functionCallEnded("UserAccessorClient.getAllUsersClients", callback);
            }
        }
    }

    protected IUserAccessor getAccessor() {
        return this.accessor;
    }
}

