/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.oe.OEC0313Svc;

import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.PrescriptionDeviceDetails;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;

public final class CreateDevicePrescriptionCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ICandidate candidate;
    private final PrescriptionDeviceDetails prescription;

    public CreateDevicePrescriptionCriteria(ICandidate candidate, PrescriptionDeviceDetails prescription) {
        this.candidate = candidate;
        this.prescription = prescription;
    }

    void valid() throws NullPointerException, IllegalArgumentException {
        if (this.candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (this.candidate.getNiu() == null) {
            throw new NullPointerException("candidate.getNiu()");
        }
        if (this.candidate.getFirstName() == null) {
            throw new NullPointerException("candidate.getFirstName()");
        }
        if (this.candidate.getLastName() == null) {
            throw new NullPointerException("candidate.getLastName()");
        }
        if (this.prescription.prescriber == null) {
            throw new NullPointerException("prescription.prescriber");
        }
        if (this.prescription.prescriber.getFirstName() == null) {
            throw new NullPointerException("prescription.prescriber.getFirstName()");
        }
        if (this.prescription.prescriber.getLastName() == null) {
            throw new NullPointerException("prescription.prescriber.getLastName()");
        }
        if (this.prescription == null) {
            throw new NullPointerException("prescription");
        }
        if (this.prescription.device == null) {
            throw new NullPointerException("prescription.device");
        }
        if (Helper.isBlank(this.prescription.device.name)) {
            throw new IllegalArgumentException("prescription.device.name is blank");
        }
        if (Helper.isNonNullAndLowerOrEqualsZero(this.prescription.device.devicePackageQuantity)) {
            throw new IllegalArgumentException("prescription.device.devicePackageQuantity is not > 0");
        }
        if (this.prescription.reasons != null) {
            for (TherapeuticIntent reason : this.prescription.reasons) {
                if (reason == null) {
                    throw new NullPointerException("reason");
                }
                if (!Helper.isBlank(reason.otherIndicationText)) continue;
                throw new IllegalArgumentException("reason.text is blank, other field are not supported in output");
            }
        }
        if (this.prescription.supplyRequestTotalDaysSupply == null && this.prescription.supplyRequestTotalQuantity == null) {
            throw new IllegalArgumentException("prescription.supplyRequestTotalQuantity and prescription.supplyRequestTotalDaysSupply cant be both null");
        }
        if (Helper.isNonNullAndLowerOrEqualsZero(this.prescription.supplyRequestFillQuantity)) {
            throw new IllegalArgumentException("prescription.supplyRequestFillQuantity is not > 0");
        }
        if (Helper.isNonNullAndLowerOrEqualsZero(this.prescription.supplyRequestNumberOfFills)) {
            throw new IllegalArgumentException("prescription.supplyRequestNumberOfFills is not > 0");
        }
        if (Helper.isNonNullAndLowerOrEqualsZero(this.prescription.supplyRequestTotalDaysSupply)) {
            throw new IllegalArgumentException("prescription.supplyRequestTotalDaysSupply is not > 0");
        }
        if (Helper.isNonNullAndLowerOrEqualsZero(this.prescription.supplyRequestTotalQuantity)) {
            throw new IllegalArgumentException("prescription.supplyRequestTotalQuantity is not > 0");
        }
        if (this.prescription.supplyRequestLocation != null) {
            if (this.prescription.supplyRequestLocation.getNIU() == null) {
                throw new NullPointerException("prescription.supplyRequestLocation.getNIU()");
            }
            if (Helper.isBlank(this.prescription.supplyRequestLocation.getName())) {
                throw new IllegalArgumentException("prescription.supplyRequestLocation.getName() is blank");
            }
            if (this.prescription.supplyRequestLocation.getAddress() == null) {
                throw new NullPointerException("prescription.supplyRequestLocation.getAddress()");
            }
            if (Helper.isBlank(this.prescription.supplyRequestLocation.getAddress().telecom)) {
                throw new IllegalArgumentException("prescription.supplyRequestLocation.getAddress().telecom is blank");
            }
        }
    }

    public ICandidate getCandidate() {
        return this.candidate;
    }

    public PrescriptionDeviceDetails getPrescriptionDeviceDetails() {
        return this.prescription;
    }

    public String toString() {
        return "CreateDevicePrescriptionCriteria [candidate=" + this.candidate + ", prescription=" + this.prescription + "]";
    }
}

