/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import org.ejml.data.DMatrixSparse;
import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.linsol.LinearSolverSparse;

public class LinearSolverSparseSafe<S extends DMatrixSparse, D extends ReshapeMatrix>
implements LinearSolverSparse<S, D> {
    private LinearSolverSparse<S, D> alg;
    private S A;
    private D B;
    private S Bsparse;

    public LinearSolverSparseSafe(LinearSolverSparse<S, D> alg) {
        this.alg = alg;
    }

    @Override
    public boolean setA(S A) {
        if (this.alg.modifiesA()) {
            if (this.A == null) {
                this.A = (DMatrixSparse)A.copy();
            } else {
                if (this.A.getNumRows() != A.getNumRows() || this.A.getNumCols() != A.getNumCols()) {
                    this.A.reshape(A.getNumRows(), A.getNumCols(), 1);
                }
                this.A.set((Matrix)A);
            }
            return this.alg.setA(this.A);
        }
        return this.alg.setA(A);
    }

    @Override
    public double quality() {
        return this.alg.quality();
    }

    @Override
    public void solve(D B, D X2) {
        if (this.alg.modifiesB()) {
            if (this.B == null) {
                this.B = (ReshapeMatrix)B.copy();
            } else {
                if (this.B.getNumRows() != B.getNumRows() || this.B.getNumCols() != B.getNumCols()) {
                    this.B.reshape(this.A.getNumRows(), B.getNumCols());
                }
                this.B.set((Matrix)B);
            }
            B = this.B;
        }
        this.alg.solve(B, X2);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public <D extends DecompositionInterface> D getDecomposition() {
        return this.alg.getDecomposition();
    }

    @Override
    public void solveSparse(S B, S X2) {
        this.alg.solveSparse(B, X2);
    }

    @Override
    public void setStructureLocked(boolean locked) {
        this.alg.setStructureLocked(locked);
    }

    @Override
    public boolean isStructureLocked() {
        return this.alg.isStructureLocked();
    }
}

