/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.List;
import java.util.Random;
import org.ddogleg.clustering.kmeans.InitializeKMeans_F64;
import org.ddogleg.clustering.kmeans.StandardKMeans_F64;
import org.ddogleg.struct.GrowQueue_F64;

public class InitializePlusPlus
implements InitializeKMeans_F64 {
    Random rand;
    GrowQueue_F64 distance = new GrowQueue_F64(1);
    double totalDistance;

    @Override
    public void init(int pointDimension, long randomSeed) {
        this.rand = new Random(randomSeed);
    }

    @Override
    public void selectSeeds(List<double[]> points, List<double[]> seeds) {
        int i;
        if (seeds.size() > points.size()) {
            throw new IllegalArgumentException("More seeds requested than points!");
        }
        this.distance.resize(points.size());
        double[] seed = points.get(this.rand.nextInt(points.size()));
        InitializePlusPlus.copyInto(seed, seeds.get(0));
        this.totalDistance = 0.0;
        for (i = 0; i < points.size(); ++i) {
            double d;
            double[] p = points.get(i);
            this.distance.data[i] = d = StandardKMeans_F64.distanceSq(p, seed);
            this.totalDistance += d;
        }
        for (i = 1; i < seeds.size(); ++i) {
            if (this.totalDistance == 0.0) {
                InitializePlusPlus.copyInto(seed, seeds.get(i));
                continue;
            }
            double target = this.rand.nextDouble();
            InitializePlusPlus.copyInto(this.selectNextSeed(points, target), seeds.get(i));
            this.updateDistances(points, seeds.get(i));
        }
    }

    protected final double[] selectNextSeed(List<double[]> points, double target) {
        double sum = 0.0;
        for (int i = 0; i < this.distance.size(); ++i) {
            double fraction = (sum += this.distance.get(i)) / this.totalDistance;
            if (!(fraction >= target)) continue;
            return points.get(i);
        }
        throw new RuntimeException("This shouldn't happen");
    }

    protected final void updateDistances(List<double[]> points, double[] clusterNew) {
        this.totalDistance = 0.0;
        for (int i = 0; i < this.distance.size(); ++i) {
            double dOld = this.distance.get(i);
            double dNew = StandardKMeans_F64.distanceSq(points.get(i), clusterNew);
            if (dNew < dOld) {
                this.distance.data[i] = dNew;
                this.totalDistance += dNew;
                continue;
            }
            this.totalDistance += dOld;
        }
    }

    private static void copyInto(double[] src, double[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }
}

