/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.flow;

public class ImageFlow {
    public int width;
    public int height;
    public D[] data = new D[0];

    public ImageFlow(int width, int height) {
        this.reshape(width, height);
    }

    public void reshape(int width, int height) {
        int N = width * height;
        if (this.data.length < N) {
            D[] tmp = new D[N];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            for (int i = this.data.length; i < N; ++i) {
                tmp[i] = new D();
            }
            this.data = tmp;
        }
        this.width = width;
        this.height = height;
    }

    public void invalidateAll() {
        int N = this.width * this.height;
        for (int i = 0; i < N; ++i) {
            this.data[i].x = Float.NaN;
        }
    }

    public void fillZero() {
        int N = this.width * this.height;
        for (int i = 0; i < N; ++i) {
            D d = this.data[i];
            d.y = 0.0f;
            d.x = 0.0f;
        }
    }

    public D get(int x, int y) {
        if (!this.isInBounds(x, y)) {
            throw new IllegalArgumentException("Requested pixel is out of bounds: " + x + " " + y);
        }
        return this.data[y * this.width + x];
    }

    public D unsafe_get(int x, int y) {
        return this.data[y * this.width + x];
    }

    public final boolean isInBounds(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setTo(ImageFlow flow) {
        int N = this.width * this.height;
        for (int i = 0; i < N; ++i) {
            this.data[i].set(flow.data[i]);
        }
    }

    public static class D {
        public float x;
        public float y;

        public void set(D d) {
            this.x = d.x;
            this.y = d.y;
        }

        public void set(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public void markInvalid() {
            this.x = Float.NaN;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public boolean isValid() {
            return !Float.isNaN(this.x);
        }
    }
}

