/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.transform.pyramid.impl.ImplPyramidOps;
import boofcv.alg.transform.pyramid.impl.ImplPyramidOps_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;
import java.lang.reflect.Array;

public class PyramidOps {
    public static <O extends ImageGray<O>> O[] declareOutput(ImagePyramid<?> pyramid, Class<O> outputType) {
        ImageGray[] ret = (ImageGray[])Array.newInstance(outputType, pyramid.getNumLayers());
        for (int i = 0; i < ret.length; ++i) {
            int w = pyramid.getWidth(i);
            int h = pyramid.getHeight(i);
            ret[i] = GeneralizedImageOps.createSingleBand(outputType, w, h);
        }
        return ret;
    }

    public static <O extends ImageGray<O>> void reshapeOutput(ImagePyramid<?> pyramid, O[] output) {
        for (int i = 0; i < output.length; ++i) {
            int w = pyramid.getWidth(i);
            int h = pyramid.getHeight(i);
            ((ImageGray)output[i]).reshape(w, h);
        }
    }

    public static <I extends ImageGray<I>, O extends ImageGray<O>> void filter(ImagePyramid<I> input, FilterImageInterface<I, O> filter, O[] output) {
        for (int i = 0; i < input.getNumLayers(); ++i) {
            ImageGray imageIn = (ImageGray)input.getLayer(i);
            filter.process(imageIn, output[i]);
        }
    }

    public static <I extends ImageGray<I>, O extends ImageGray<O>> void gradient(ImagePyramid<I> input, ImageGradient<I, O> gradient, O[] derivX, O[] derivY) {
        for (int i = 0; i < input.getNumLayers(); ++i) {
            ImageGray imageIn = (ImageGray)input.getLayer(i);
            gradient.process(imageIn, derivX[i], derivY[i]);
        }
    }

    public static <I extends ImageGray<I>, O extends ImageGray<O>> void hessian(O[] derivX, O[] derivY, ImageHessian<O> hessian, O[] derivXX, O[] derivYY, O[] derivXY) {
        for (int i = 0; i < derivX.length; ++i) {
            hessian.process(derivX[i], derivY[i], derivXX[i], derivYY[i], derivXY[i]);
        }
    }

    public static <T extends ImageGray<T>> void scaleDown2(T input, T output) {
        if (input instanceof GrayF32) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplPyramidOps_MT.scaleDown2((GrayF32)input, (GrayF32)output);
            } else {
                ImplPyramidOps.scaleDown2((GrayF32)input, (GrayF32)output);
            }
        } else if (input instanceof GrayU8) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplPyramidOps_MT.scaleDown2((GrayU8)input, (GrayU8)output);
            } else {
                ImplPyramidOps.scaleDown2((GrayU8)input, (GrayU8)output);
            }
        } else {
            throw new IllegalArgumentException("Image type not yet supported");
        }
    }

    public static <T extends ImageGray<T>> void scaleImageUp(T input, T output, int scale, InterpolatePixelS<T> interp) {
        if (scale <= 1) {
            throw new IllegalArgumentException("Scale must be >= 2");
        }
        if (input instanceof GrayF32) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplPyramidOps_MT.scaleImageUp((GrayF32)input, (GrayF32)output, scale, interp);
            } else {
                ImplPyramidOps.scaleImageUp((GrayF32)input, (GrayF32)output, scale, interp);
            }
        } else if (input instanceof GrayU8) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplPyramidOps_MT.scaleImageUp((GrayU8)input, (GrayU8)output, scale, interp);
            } else {
                ImplPyramidOps.scaleImageUp((GrayU8)input, (GrayU8)output, scale, interp);
            }
        } else {
            throw new IllegalArgumentException("Image type not yet supported");
        }
    }
}

