/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation;

import boofcv.struct.feature.ColorQueue_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public abstract class ComputeRegionMeanColor<T extends ImageBase<T>> {
    T image;
    int numBands;
    FastQueue<float[]> regionSums;

    public ComputeRegionMeanColor(int numBands) {
        this.numBands = numBands;
        this.regionSums = new ColorQueue_F32(numBands);
    }

    public void process(T image, GrayS32 pixelToRegion, GrowQueue_I32 regionMemberCount, FastQueue<float[]> regionColor) {
        int i;
        if (((ImageBase)image).getImageType().getFamily() != ImageType.Family.GRAY) {
            this.numBands = ((ImageMultiBand)image).getNumBands();
            this.regionSums = new ColorQueue_F32(this.numBands);
        }
        this.image = image;
        this.regionSums.resize(regionColor.size);
        for (i = 0; i < this.regionSums.size; ++i) {
            float[] v = this.regionSums.get(i);
            for (int j = 0; j < v.length; ++j) {
                v[j] = 0.0f;
            }
        }
        for (int y = 0; y < ((ImageBase)image).height; ++y) {
            int indexImg = ((ImageBase)image).startIndex + y * ((ImageBase)image).stride;
            int indexRgn = pixelToRegion.startIndex + y * pixelToRegion.stride;
            int x = 0;
            while (x < ((ImageBase)image).width) {
                int region = pixelToRegion.data[indexRgn];
                float[] sum = this.regionSums.get(region);
                this.addPixelValue(indexImg, sum);
                ++x;
                ++indexRgn;
                ++indexImg;
            }
        }
        for (i = 0; i < this.regionSums.size; ++i) {
            float N = regionMemberCount.get(i);
            float[] sum = this.regionSums.get(i);
            float[] average = regionColor.get(i);
            for (int j = 0; j < this.numBands; ++j) {
                average[j] = sum[j] / N;
            }
        }
    }

    protected abstract void addPixelValue(int var1, float[] var2);

    public static class PL_F32
    extends ComputeRegionMeanColor<Planar<GrayF32>> {
        public PL_F32(int numBands) {
            super(numBands);
        }

        @Override
        protected void addPixelValue(int index, float[] sum) {
            for (int i = 0; i < this.numBands; ++i) {
                int n = i;
                sum[n] = sum[n] + ((GrayF32[])((Planar)this.image).bands)[i].data[index];
            }
        }
    }

    public static class PL_U8
    extends ComputeRegionMeanColor<Planar<GrayU8>> {
        public PL_U8(int numBands) {
            super(numBands);
        }

        @Override
        protected void addPixelValue(int index, float[] sum) {
            for (int i = 0; i < this.numBands; ++i) {
                int n = i;
                sum[n] = sum[n] + (float)(((GrayU8[])((Planar)this.image).bands)[i].data[index] & 0xFF);
            }
        }
    }

    public static class F32
    extends ComputeRegionMeanColor<GrayF32> {
        public F32() {
            super(1);
        }

        @Override
        protected void addPixelValue(int index, float[] sum) {
            sum[0] = sum[0] + ((GrayF32)this.image).data[index];
        }
    }

    public static class U8
    extends ComputeRegionMeanColor<GrayU8> {
        public U8() {
            super(1);
        }

        @Override
        protected void addPixelValue(int index, float[] sum) {
            sum[0] = sum[0] + (float)(((GrayU8)this.image).data[index] & 0xFF);
        }
    }
}

