/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoM;

public class ResidualsTriangulateMetricSimple
implements FunctionNtoM {
    private List<Point2D_F64> observations;
    private List<Se3_F64> motionGtoC;
    private Point3D_F64 point = new Point3D_F64();
    private Point3D_F64 transformed = new Point3D_F64();

    public void setObservations(List<Point2D_F64> observations, List<Se3_F64> motionGtoC) {
        if (observations.size() != motionGtoC.size()) {
            throw new IllegalArgumentException("Different size lists");
        }
        this.observations = observations;
        this.motionGtoC = motionGtoC;
    }

    @Override
    public int getNumOfInputsN() {
        return 3;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.observations.size() * 2;
    }

    @Override
    public void process(double[] input, double[] output) {
        this.point.x = input[0];
        this.point.y = input[1];
        this.point.z = input[2];
        int indexOut = 0;
        for (int i = 0; i < this.observations.size(); ++i) {
            Point2D_F64 p = this.observations.get(i);
            Se3_F64 m = this.motionGtoC.get(i);
            SePointOps_F64.transform(m, this.point, this.transformed);
            output[indexOut++] = this.transformed.x / this.transformed.z - p.x;
            output[indexOut++] = this.transformed.y / this.transformed.z - p.y;
        }
    }
}

