/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.TriangulateNViewsProjective;
import boofcv.abst.geo.triangulate.TriangulateRefineProjectiveLS;
import boofcv.alg.geo.trifocal.TrifocalExtractGeometries;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple4D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class DistanceTrifocalReprojectionSq
implements DistanceFromModel<TrifocalTensor, AssociatedTriple> {
    DMatrixRMaj P1 = CommonOps_DDRM.identity(3, 4);
    DMatrixRMaj P2 = new DMatrixRMaj(3, 4);
    DMatrixRMaj P3 = new DMatrixRMaj(3, 4);
    List<DMatrixRMaj> cameraMatrices = new ArrayList<DMatrixRMaj>();
    List<Point2D_F64> observations = new ArrayList<Point2D_F64>();
    TrifocalExtractGeometries extractor = new TrifocalExtractGeometries();
    TriangulateNViewsProjective triangulator = FactoryMultiView.triangulateNView(ConfigTriangulation.DLT);
    TriangulateRefineProjectiveLS refiner;
    Point4D_F64 X = new Point4D_F64();
    Point2D_F64 pixel = new Point2D_F64();

    public DistanceTrifocalReprojectionSq(double gtol, int maxIterations) {
        this();
        this.refiner = new TriangulateRefineProjectiveLS(gtol, maxIterations);
    }

    public DistanceTrifocalReprojectionSq() {
        this.cameraMatrices.add(this.P1);
        this.cameraMatrices.add(this.P2);
        this.cameraMatrices.add(this.P3);
        this.observations.add(null);
        this.observations.add(null);
        this.observations.add(null);
    }

    @Override
    public void setModel(TrifocalTensor trifocalTensor) {
        this.extractor.setTensor(trifocalTensor);
        this.extractor.extractCamera(this.P2, this.P3);
    }

    @Override
    public double computeDistance(AssociatedTriple pt) {
        this.observations.set(0, pt.p1);
        this.observations.set(1, pt.p2);
        this.observations.set(2, pt.p3);
        if (!this.triangulator.triangulate(this.observations, this.cameraMatrices, this.X)) {
            return 1.0E200;
        }
        if (this.refiner != null) {
            this.refiner.process(this.observations, this.cameraMatrices, this.X, this.X);
        }
        double error = 0.0;
        GeometryMath_F64.mult(this.P1, (GeoTuple4D_F64)this.X, this.pixel);
        error += this.pixel.distance2(pt.p1);
        GeometryMath_F64.mult(this.P2, (GeoTuple4D_F64)this.X, this.pixel);
        error += this.pixel.distance2(pt.p2);
        GeometryMath_F64.mult(this.P3, (GeoTuple4D_F64)this.X, this.pixel);
        return error += this.pixel.distance2(pt.p3);
    }

    @Override
    public void computeDistance(List<AssociatedTriple> observations, double[] distance) {
        for (int i = 0; i < observations.size(); ++i) {
            distance[i] = this.computeDistance(observations.get(i));
        }
    }

    @Override
    public Class<AssociatedTriple> getPointType() {
        return AssociatedTriple.class;
    }

    @Override
    public Class<TrifocalTensor> getModelType() {
        return TrifocalTensor.class;
    }
}

