/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.geo.impl.ImplRectifyImageOps_F32;
import boofcv.alg.geo.impl.ImplRectifyImageOps_F64;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.alg.geo.rectify.RectifyFundamental;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDimension;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import javax.annotation.Nullable;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public class RectifyImageOps {
    public static RectifyCalibrated createCalibrated() {
        return new RectifyCalibrated();
    }

    public static RectifyFundamental createUncalibrated() {
        return new RectifyFundamental();
    }

    public static void fullViewLeft(CameraPinholeBrown paramLeft, @Nullable DMatrixRMaj rectifiedR, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, DMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        ImplRectifyImageOps_F64.fullViewLeft(paramLeft, rectifiedR, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
    }

    public static void fullViewLeft(CameraPinholeBrown paramLeft, @Nullable FMatrixRMaj rectifiedR, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight, FMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        ImplRectifyImageOps_F32.fullViewLeft(paramLeft, rectifiedR, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
    }

    public static void fullViewLeft(int imageWidth, int imageHeight, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight) {
        ImplRectifyImageOps_F64.fullViewLeft(imageWidth, imageHeight, rectifyLeft, rectifyRight);
    }

    public static void fullViewLeft(int imageWidth, int imageHeight, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight) {
        ImplRectifyImageOps_F32.fullViewLeft(imageWidth, imageHeight, rectifyLeft, rectifyRight);
    }

    public static void allInsideLeft(CameraPinholeBrown paramLeft, @Nullable DMatrixRMaj rectifiedR, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight, DMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        ImplRectifyImageOps_F64.allInsideLeft(paramLeft, rectifiedR, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
    }

    public static void allInsideLeft(CameraPinholeBrown paramLeft, @Nullable FMatrixRMaj rectifiedR, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight, FMatrixRMaj rectifyK, @Nullable ImageDimension rectifiedSize) {
        if (rectifiedSize == null) {
            rectifiedSize = new ImageDimension();
        }
        ImplRectifyImageOps_F32.allInsideLeft(paramLeft, rectifiedR, rectifyLeft, rectifyRight, rectifyK, rectifiedSize);
    }

    public static void allInsideLeft(int imageWidth, int imageHeight, DMatrixRMaj rectifyLeft, DMatrixRMaj rectifyRight) {
        ImplRectifyImageOps_F64.allInsideLeft(imageWidth, imageHeight, rectifyLeft, rectifyRight);
    }

    public static void allInsideLeft(int imageWidth, int imageHeight, FMatrixRMaj rectifyLeft, FMatrixRMaj rectifyRight) {
        ImplRectifyImageOps_F32.allInsideLeft(imageWidth, imageHeight, rectifyLeft, rectifyRight);
    }

    public static Point2Transform2_F64 transformRectToPixel(CameraPinholeBrown param, DMatrixRMaj rectify) {
        return ImplRectifyImageOps_F64.transformRectToPixel(param, rectify);
    }

    public static Point2Transform2_F32 transformRectToPixel(CameraPinholeBrown param, FMatrixRMaj rectify) {
        return ImplRectifyImageOps_F32.transformRectToPixel(param, rectify);
    }

    public static Point2Transform2_F64 transformPixelToRect(CameraPinholeBrown param, DMatrixRMaj rectify) {
        return ImplRectifyImageOps_F64.transformPixelToRect(param, rectify);
    }

    public static Point2Transform2_F32 transformPixelToRect(CameraPinholeBrown param, FMatrixRMaj rectify) {
        return ImplRectifyImageOps_F32.transformPixelToRect(param, rectify);
    }

    public static Point2Transform2_F64 transformPixelToRectNorm(CameraPinholeBrown param, DMatrixRMaj rectify, DMatrixRMaj rectifyK) {
        return ImplRectifyImageOps_F64.transformPixelToRectNorm(param, rectify, rectifyK);
    }

    public static Point2Transform2_F32 transformPixelToRectNorm(CameraPinholeBrown param, FMatrixRMaj rectify, FMatrixRMaj rectifyK) {
        return ImplRectifyImageOps_F32.transformPixelToRectNorm(param, rectify, rectifyK);
    }

    public static <T extends ImageGray<T>> ImageDistort<T, T> rectifyImage(FMatrixRMaj rectify, BorderType borderType, Class<T> imageType) {
        boolean skip;
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        InterpolatePixelS<T> interp = FactoryInterpolation.bilinearPixelS(imageType, borderType);
        FMatrixRMaj rectifyInv = new FMatrixRMaj(3, 3);
        CommonOps_FDRM.invert(rectify, rectifyInv);
        PointTransformHomography_F32 rectifyTran = new PointTransformHomography_F32(rectifyInv);
        ImageDistort<T, T> ret = FactoryDistort.distortSB(false, interp, imageType);
        ret.setRenderAll(!skip);
        ret.setModel(new PointToPixelTransform_F32(rectifyTran));
        return ret;
    }

    public static <T extends ImageBase<T>> ImageDistort<T, T> rectifyImage(CameraPinholeBrown param, FMatrixRMaj rectify, BorderType borderType, ImageType<T> imageType) {
        boolean skip;
        boolean bl = skip = borderType == BorderType.SKIP;
        if (skip) {
            borderType = BorderType.EXTENDED;
        }
        InterpolatePixel<T> interp = FactoryInterpolation.createPixel(0.0, 255.0, InterpolationType.BILINEAR, borderType, imageType);
        ImageDistort<T, T> ret = FactoryDistort.distort(true, interp, imageType);
        ret.setRenderAll(!skip);
        Point2Transform2_F32 transform = RectifyImageOps.transformRectToPixel(param, rectify);
        ret.setModel(new PointToPixelTransform_F32(transform));
        return ret;
    }

    public static void applyMask(GrayF32 disparity, GrayU8 mask, int radius) {
        if (disparity.isSubimage() || mask.isSubimage()) {
            throw new RuntimeException("Input is subimage. Currently not support but no reason why it can't be. Ask for it");
        }
        int N = disparity.width * disparity.height;
        for (int i = 0; i < N; ++i) {
            if (mask.data[i] != 0) continue;
            disparity.data[i] = 255.0f;
        }
        if (radius > 0) {
            int r;
            for (int y = r = radius; y < mask.height - r - 1; ++y) {
                int indexMsk = y * mask.stride + r;
                int x = r;
                while (x < mask.width - r - 1) {
                    int deltaX = mask.data[indexMsk] - mask.data[indexMsk + 1];
                    int deltaY = mask.data[indexMsk] - mask.data[indexMsk + mask.stride];
                    if (deltaX != 0 || deltaY != 0) {
                        if (deltaX < 0) {
                            deltaX = 0;
                        }
                        if (deltaY < 0) {
                            deltaY = 0;
                        }
                        for (int i = -r; i <= r; ++i) {
                            for (int j = -r; j <= r; ++j) {
                                disparity.set(deltaX + x + j, deltaY + y + i, 255.0f);
                            }
                        }
                    }
                    ++x;
                    ++indexMsk;
                }
            }
        }
    }

    public static void applyMask(GrayU8 disparity, GrayU8 mask, int radius) {
        if (disparity.isSubimage() || mask.isSubimage()) {
            throw new RuntimeException("Input is subimage. Currently not support but no reason why it can't be. Ask for it");
        }
        int N = disparity.width * disparity.height;
        for (int i = 0; i < N; ++i) {
            if (mask.data[i] != 0) continue;
            disparity.data[i] = -1;
        }
        if (radius > 0) {
            int r;
            for (int y = r = radius; y < mask.height - r - 1; ++y) {
                int indexMsk = y * mask.stride + r;
                int x = r;
                while (x < mask.width - r - 1) {
                    int deltaX = mask.data[indexMsk] - mask.data[indexMsk + 1];
                    int deltaY = mask.data[indexMsk] - mask.data[indexMsk + mask.stride];
                    if (deltaX != 0 || deltaY != 0) {
                        if (deltaX < 0) {
                            deltaX = 0;
                        }
                        if (deltaY < 0) {
                            deltaY = 0;
                        }
                        for (int i = -r; i <= r; ++i) {
                            for (int j = -r; j <= r; ++j) {
                                disparity.set(deltaX + x + j, deltaY + y + i, 255);
                            }
                        }
                    }
                    ++x;
                    ++indexMsk;
                }
            }
        }
    }
}

