/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import georegression.geometry.algs.TangentLinesTwoEllipses_F64;
import georegression.misc.GrlConstants;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastQueue;

public class KeyPointsCircleRegularGrid {
    FastQueue<Tangents> tangents = new FastQueue<Tangents>(Tangents.class, true);
    FastQueue<Point2D_F64> keypoints = new FastQueue<Point2D_F64>(Point2D_F64.class, true);
    private TangentLinesTwoEllipses_F64 tangentFinder = new TangentLinesTwoEllipses_F64(GrlConstants.TEST_F64, 10);
    private Point2D_F64 A0 = new Point2D_F64();
    private Point2D_F64 A1 = new Point2D_F64();
    private Point2D_F64 A2 = new Point2D_F64();
    private Point2D_F64 A3 = new Point2D_F64();
    private Point2D_F64 B0 = new Point2D_F64();
    private Point2D_F64 B1 = new Point2D_F64();
    private Point2D_F64 B2 = new Point2D_F64();
    private Point2D_F64 B3 = new Point2D_F64();

    public boolean process(EllipseClustersIntoGrid.Grid grid) {
        this.init(grid);
        if (!this.horizontal(grid)) {
            return false;
        }
        if (!this.vertical(grid)) {
            return false;
        }
        this.keypoints.reset();
        for (int i = 0; i < this.tangents.size(); ++i) {
            this.tangents.get(i).getTop(this.keypoints.grow());
            this.tangents.get(i).getRight(this.keypoints.grow());
            this.tangents.get(i).getBottom(this.keypoints.grow());
            this.tangents.get(i).getLeft(this.keypoints.grow());
        }
        return true;
    }

    void init(EllipseClustersIntoGrid.Grid grid) {
        this.tangents.resize(grid.ellipses.size());
        for (int i = 0; i < this.tangents.size(); ++i) {
            this.tangents.get(i).reset();
        }
    }

    boolean horizontal(EllipseClustersIntoGrid.Grid grid) {
        for (int i = 0; i < grid.rows; ++i) {
            for (int j = 0; j < grid.columns - 1; ++j) {
                if (this.addTangents(grid, i, j, i, j + 1)) continue;
                return false;
            }
        }
        return true;
    }

    boolean vertical(EllipseClustersIntoGrid.Grid grid) {
        for (int i = 0; i < grid.rows - 1; ++i) {
            for (int j = 0; j < grid.columns; ++j) {
                if (this.addTangents(grid, i, j, i + 1, j)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean addTangents(EllipseClustersIntoGrid.Grid grid, int rowA, int colA, int rowB, int colB) {
        EllipseRotated_F64 b;
        EllipseRotated_F64 a = grid.get(rowA, colA);
        if (!this.tangentFinder.process(a, b = grid.get(rowB, colB), this.A0, this.A1, this.A2, this.A3, this.B0, this.B1, this.B2, this.B3)) {
            return false;
        }
        Tangents ta = this.tangents.get(grid.getIndexOfRegEllipse(rowA, colA));
        Tangents tb = this.tangents.get(grid.getIndexOfRegEllipse(rowB, colB));
        double slopeX = b.center.x - a.center.x;
        double dy0 = this.A0.y - a.center.y;
        double slopeY = b.center.y - a.center.y;
        double dx0 = this.A0.x - a.center.x;
        double z = slopeX * dy0 - slopeY * dx0;
        if (z < 0.0 == (rowA == rowB)) {
            Point2D_F64 tmp = this.A0;
            this.A0 = this.A3;
            this.A3 = tmp;
            tmp = this.B0;
            this.B0 = this.B3;
            this.B3 = tmp;
        }
        if (rowA == rowB) {
            ta.t[ta.countT++].set(this.A0);
            ta.b[ta.countB++].set(this.A3);
            tb.t[tb.countT++].set(this.B0);
            tb.b[tb.countB++].set(this.B3);
        } else {
            ta.r[ta.countL++].set(this.A0);
            ta.l[ta.countR++].set(this.A3);
            tb.r[tb.countL++].set(this.B0);
            tb.l[tb.countR++].set(this.B3);
        }
        return true;
    }

    public FastQueue<Point2D_F64> getKeyPoints() {
        return this.keypoints;
    }

    public FastQueue<Tangents> getTangents() {
        return this.tangents;
    }

    public static class Tangents {
        public Point2D_F64[] t = new Point2D_F64[2];
        public Point2D_F64[] b = new Point2D_F64[2];
        public Point2D_F64[] l = new Point2D_F64[2];
        public Point2D_F64[] r = new Point2D_F64[2];
        int countT = 0;
        int countB = 0;
        int countL = 0;
        int countR = 0;

        public Tangents() {
            for (int i = 0; i < 2; ++i) {
                this.t[i] = new Point2D_F64();
                this.b[i] = new Point2D_F64();
                this.l[i] = new Point2D_F64();
                this.r[i] = new Point2D_F64();
            }
        }

        public void reset() {
            this.countR = 0;
            this.countL = 0;
            this.countB = 0;
            this.countT = 0;
        }

        public void getTop(Point2D_F64 top) {
            this.assign(this.t, this.countT, top);
        }

        public void getBottom(Point2D_F64 p) {
            this.assign(this.b, this.countB, p);
        }

        public void getLeft(Point2D_F64 p) {
            this.assign(this.l, this.countL, p);
        }

        public void getRight(Point2D_F64 p) {
            this.assign(this.r, this.countR, p);
        }

        private void assign(Point2D_F64[] array, int length, Point2D_F64 output) {
            if (length == 1) {
                output.set(array[0]);
            } else {
                output.x = (array[0].x + array[1].x) / 2.0;
                output.y = (array[0].y + array[1].y) / 2.0;
            }
        }
    }
}

