/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.feature.detect.chess.ChessboardCornerDistance;
import boofcv.alg.feature.detect.chess.DetectChessboardCornersX;
import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.alg.misc.ImageNormalization;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;

public class DetectChessboardCornersXPyramid<T extends ImageGray<T>> {
    int pyramidTopSize = 100;
    GrayF32 normalized = new GrayF32(1, 1);
    List<GrayF32> pyramid = new ArrayList<GrayF32>();
    int radius = 7;
    DetectChessboardCornersX detector;
    FastQueue<PyramidLevel> featureLevels = new FastQueue<PyramidLevel>(PyramidLevel.class, () -> new PyramidLevel());
    FastQueue<ChessboardCorner> corners = new FastQueue<ChessboardCorner>(ChessboardCorner.class, true);
    NearestNeighbor<ChessboardCorner> nn = FactoryNearestNeighbor.kdtree(new ChessboardCornerDistance());
    NearestNeighbor.Search<ChessboardCorner> nnSearch = this.nn.createSearch();
    FastQueue<NnData<ChessboardCorner>> nnResults = new FastQueue<NnData>(NnData.class, true);
    ImageType<T> imageType;

    public DetectChessboardCornersXPyramid(DetectChessboardCornersX detector, ImageType<T> imageType) {
        this.detector = detector;
        this.imageType = imageType;
    }

    public DetectChessboardCornersXPyramid(ImageType<T> imageType) {
        this(new DetectChessboardCornersX(), imageType);
    }

    public void process(T input) {
        float maxIntensityImage;
        this.constructPyramid(input);
        this.corners.reset();
        this.detector.considerMaxIntensityImage = maxIntensityImage = 0.0f;
        double scale = Math.pow(2.0, this.pyramid.size() - 1);
        for (int level = this.pyramid.size() - 1; level >= 0; --level) {
            this.detector.considerMaxIntensityImage = maxIntensityImage;
            this.detector.process(this.pyramid.get(level));
            maxIntensityImage = Math.max(maxIntensityImage, this.detector.maxIntensityImage);
            PyramidLevel featsLevel = this.featureLevels.get(level);
            List<ChessboardCorner> corners = this.detector.getCorners();
            featsLevel.corners.reset();
            for (int i = 0; i < corners.size(); ++i) {
                ChessboardCorner cf = corners.get(i);
                double x = cf.x * scale;
                double y = cf.y * scale;
                ChessboardCorner cl = featsLevel.corners.grow();
                cl.first = true;
                cl.set(x, y, cf.orientation, cf.intensity);
                cl.constrast = cf.constrast;
                cl.levelMax = level;
                cl.level1 = level;
                cl.level2 = level;
            }
            scale /= 2.0;
        }
        double baseScale = 1.0;
        for (int levelIdx = 0; levelIdx < this.pyramid.size(); ++levelIdx) {
            PyramidLevel level0 = this.featureLevels.get(levelIdx);
            scale = baseScale * 2.0;
            for (int nextIdx = levelIdx + 1; nextIdx < this.pyramid.size(); ++nextIdx) {
                PyramidLevel level1 = this.featureLevels.get(nextIdx);
                this.markSeenAsFalse(level0.corners, level1.corners, scale);
                scale *= 2.0;
            }
            baseScale *= 2.0;
        }
        int dropped = 0;
        for (int levelIdx = 0; levelIdx < this.pyramid.size(); ++levelIdx) {
            PyramidLevel level = this.featureLevels.get(levelIdx);
            for (int i = 0; i < level.corners.size; ++i) {
                ChessboardCorner c = level.corners.get(i);
                if (c.first) {
                    this.corners.grow().set(c);
                    continue;
                }
                ++dropped;
            }
        }
    }

    void markSeenAsFalse(FastQueue<ChessboardCorner> corners0, FastQueue<ChessboardCorner> corners1, double scale) {
        this.nn.setPoints(corners1.toList(), false);
        double searchRadius = (double)this.radius * scale;
        for (int i = 0; i < corners0.size; ++i) {
            ChessboardCorner c0 = corners0.get(i);
            double intensity = c0.intensity * (c0.first ? 8.0 : 1.0);
            this.nnSearch.findNearest(c0, searchRadius, 10, this.nnResults);
            boolean maximum = true;
            ChessboardCorner resultsMax = c0;
            double distanceMax = 0.0;
            int level2 = c0.level2;
            for (int j = 0; j < this.nnResults.size; ++j) {
                ChessboardCorner c1 = (ChessboardCorner)this.nnResults.get((int)j).point;
                level2 = c1.level2;
                if (c1.intensity < intensity) {
                    c1.first = false;
                } else {
                    maximum = false;
                }
                if (!(c1.intensity > resultsMax.intensity)) continue;
                distanceMax = this.nnResults.get((int)j).distance;
                resultsMax = c1;
            }
            if (!maximum) {
                c0.first = false;
            }
            if (!(distanceMax <= (double)(this.radius * this.radius))) continue;
            c0.orientation = resultsMax.orientation;
            c0.intensity = resultsMax.intensity;
            c0.constrast = resultsMax.constrast;
            c0.levelMax = resultsMax.levelMax;
            c0.level2 = level2;
        }
    }

    void constructPyramid(T input) {
        ImageNormalization.maxAbsOfOne(input, this.normalized, null);
        if (this.pyramid.size() == 0) {
            this.pyramid.add(this.normalized);
        } else {
            this.pyramid.set(0, this.normalized);
        }
        int pyramidTopSize = this.pyramidTopSize;
        if (pyramidTopSize != 0 && pyramidTopSize < (1 + 2 * this.radius) * 5) {
            pyramidTopSize = (1 + 2 * this.radius) * 5;
        }
        int levelIndex = 1;
        int divisor = 2;
        while (true) {
            GrayF32 level;
            int width = ((ImageGray)input).width / divisor;
            int height = ((ImageGray)input).height / divisor;
            if (pyramidTopSize == 0 || width < pyramidTopSize || height < pyramidTopSize) break;
            if (this.pyramid.size() <= levelIndex) {
                level = new GrayF32(width, height);
                this.pyramid.add(level);
            } else {
                level = this.pyramid.get(levelIndex);
                level.reshape(width, height);
            }
            AverageDownSampleOps.down(this.pyramid.get(levelIndex - 1), 2, level);
            divisor *= 2;
            ++levelIndex;
        }
        while (this.pyramid.size() > levelIndex) {
            this.pyramid.remove(this.pyramid.size() - 1);
        }
        this.featureLevels.resize(this.pyramid.size());
    }

    public DetectChessboardCornersX getDetector() {
        return this.detector;
    }

    public FastQueue<ChessboardCorner> getCorners() {
        return this.corners;
    }

    public int getNumberOfLevels() {
        return this.pyramid.size();
    }

    public int getPyramidTopSize() {
        return this.pyramidTopSize;
    }

    public void setPyramidTopSize(int pyramidTopSize) {
        this.pyramidTopSize = pyramidTopSize;
    }

    public ImageType<T> getImageType() {
        return this.imageType;
    }

    private static class PyramidLevel {
        FastQueue<ChessboardCorner> corners = new FastQueue<ChessboardCorner>(ChessboardCorner.class, true);

        private PyramidLevel() {
        }
    }
}

