/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.describe.DescribeSiftCommon;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.ImageGray;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastQueue;

public class DescribeDenseSiftAlg<D extends ImageGray<D>>
extends DescribeSiftCommon {
    double periodRows;
    double periodColumns;
    GImageGray imageDerivX;
    GImageGray imageDerivY;
    FastQueue<TupleDesc_F64> descriptors;
    GrayF64 savedAngle = new GrayF64(1, 1);
    GrayF32 savedMagnitude = new GrayF32(1, 1);
    FastQueue<Point2D_I32> sampleLocations = new FastQueue<Point2D_I32>(Point2D_I32.class, true);

    public DescribeDenseSiftAlg(int widthSubregion, int widthGrid, int numHistogramBins, double weightingSigmaFraction, double maxDescriptorElementValue, double periodColumns, double periodRows, Class<D> derivType) {
        super(widthSubregion, widthGrid, numHistogramBins, weightingSigmaFraction, maxDescriptorElementValue);
        this.periodRows = periodRows;
        this.periodColumns = periodColumns;
        final int DOF = this.getDescriptorLength();
        this.imageDerivX = FactoryGImageGray.create(derivType);
        this.imageDerivY = FactoryGImageGray.create(derivType);
        this.descriptors = new FastQueue<TupleDesc_F64>(TupleDesc_F64.class, true){

            @Override
            protected TupleDesc_F64 createInstance() {
                return new TupleDesc_F64(DOF);
            }
        };
    }

    public void setImageGradient(D derivX, D derivY) {
        InputSanityCheck.checkSameShape(derivX, derivY);
        if (((ImageGray)derivX).stride != ((ImageGray)derivY).stride || ((ImageGray)derivX).startIndex != ((ImageGray)derivY).startIndex) {
            throw new IllegalArgumentException("stride and start index must be the same");
        }
        this.savedAngle.reshape(((ImageGray)derivX).width, ((ImageGray)derivX).height);
        this.savedMagnitude.reshape(((ImageGray)derivX).width, ((ImageGray)derivX).height);
        this.imageDerivX.wrap((ImageGray)derivX);
        this.imageDerivY.wrap((ImageGray)derivY);
        this.precomputeAngles(derivX);
    }

    public void process() {
        int radius;
        int width = this.widthSubregion * this.widthGrid;
        int X0 = radius = width / 2;
        int X1 = this.savedAngle.width - radius;
        int Y0 = radius;
        int Y1 = this.savedAngle.height - radius;
        int numX = (int)((double)(X1 - X0) / this.periodColumns);
        int numY = (int)((double)(Y1 - Y0) / this.periodRows);
        this.descriptors.reset();
        this.sampleLocations.reset();
        for (int i = 0; i < numY; ++i) {
            int y = (Y1 - Y0) * i / (numY - 1) + Y0;
            for (int j = 0; j < numX; ++j) {
                int x = (X1 - X0) * j / (numX - 1) + X0;
                TupleDesc_F64 desc = this.descriptors.grow();
                this.computeDescriptor(x, y, desc);
                this.sampleLocations.grow().set(x, y);
            }
        }
    }

    void precomputeAngles(D image) {
        int savecIndex = 0;
        for (int y = 0; y < ((ImageGray)image).height; ++y) {
            int pixelIndex = y * ((ImageGray)image).stride + ((ImageGray)image).startIndex;
            int x = 0;
            while (x < ((ImageGray)image).width) {
                float spacialDX = this.imageDerivX.getF(pixelIndex);
                float spacialDY = this.imageDerivY.getF(pixelIndex);
                this.savedAngle.data[savecIndex] = UtilAngle.domain2PI(Math.atan2(spacialDY, spacialDX));
                this.savedMagnitude.data[savecIndex] = (float)Math.sqrt(spacialDX * spacialDX + spacialDY * spacialDY);
                ++x;
                ++pixelIndex;
                ++savecIndex;
            }
        }
    }

    public void computeDescriptor(int cx, int cy, TupleDesc_F64 desc) {
        desc.fill(0.0);
        int widthPixels = this.widthSubregion * this.widthGrid;
        int radius = widthPixels / 2;
        for (int i = 0; i < widthPixels; ++i) {
            int angleIndex = (cy - radius + i) * this.savedAngle.width + (cx - radius);
            float subY = (float)i / (float)this.widthSubregion;
            int j = 0;
            while (j < widthPixels) {
                float subX = (float)j / (float)this.widthSubregion;
                double angle = this.savedAngle.data[angleIndex];
                float weightGaussian = this.gaussianWeight[i * widthPixels + j];
                float weightGradient = this.savedMagnitude.data[angleIndex];
                this.trilinearInterpolation(weightGaussian * weightGradient, subX, subY, angle, desc);
                ++j;
                ++angleIndex;
            }
        }
        DescribeDenseSiftAlg.normalizeDescriptor(desc, this.maxDescriptorElementValue);
    }

    public double getPeriodRows() {
        return this.periodRows;
    }

    public void setPeriodRows(double periodRows) {
        this.periodRows = periodRows;
    }

    public double getPeriodColumns() {
        return this.periodColumns;
    }

    public void setPeriodColumns(double periodColumns) {
        this.periodColumns = periodColumns;
    }

    public FastQueue<TupleDesc_F64> getDescriptors() {
        return this.descriptors;
    }

    public FastQueue<Point2D_I32> getLocations() {
        return this.sampleLocations;
    }

    public Class<D> getDerivType() {
        return this.imageDerivX.getImageType();
    }
}

