/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.drawing;

import boofcv.abst.distort.FDistort;
import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.ConvertImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;

public class FiducialImageEngine
extends FiducialRenderEngine {
    protected GrayU8 gray = new GrayU8(1, 1);
    private int borderPixels;
    private int white = 255;
    private int black = 0;

    public void configure(int borderPixels, int markerPixels) {
        this.borderPixels = borderPixels;
        int width = markerPixels + 2 * borderPixels;
        this.gray.reshape(width, width);
    }

    @Override
    public void init() {
        ImageMiscOps.fill(this.gray, this.white);
    }

    @Override
    public void rectangle(double x0, double y0, double x1, double y1) {
        int pixelX0 = this.borderPixels + (int)(x0 + 0.5);
        int pixelY0 = this.borderPixels + (int)(y0 + 0.5);
        int pixelX1 = this.borderPixels + (int)(x1 + 0.5);
        int pixelY1 = this.borderPixels + (int)(y1 + 0.5);
        ImageMiscOps.fillRectangle(this.gray, 0, pixelX0, pixelY0, pixelX1 - pixelX0, pixelY1 - pixelY0);
    }

    @Override
    public void square(double x0, double y0, double width0, double thickness) {
        int X0 = this.borderPixels + (int)(x0 + 0.5);
        int Y0 = this.borderPixels + (int)(y0 + 0.5);
        int WIDTH = (int)(width0 + 0.5);
        int THICKNESS = (int)(thickness + 0.5);
        ImageMiscOps.fillRectangle(this.gray, this.black, X0, Y0, WIDTH, THICKNESS);
        ImageMiscOps.fillRectangle(this.gray, this.black, X0, Y0 + WIDTH - THICKNESS, WIDTH, THICKNESS);
        ImageMiscOps.fillRectangle(this.gray, this.black, X0, Y0 + THICKNESS, THICKNESS, WIDTH - THICKNESS * 2);
        ImageMiscOps.fillRectangle(this.gray, this.black, X0 + WIDTH - THICKNESS, Y0 + THICKNESS, THICKNESS, WIDTH - THICKNESS * 2);
    }

    @Override
    public void draw(GrayU8 image, double x0, double y0, double x1, double y1) {
        int X0 = this.borderPixels + (int)(x0 + 0.5);
        int Y0 = this.borderPixels + (int)(y0 + 0.5);
        int X1 = this.borderPixels + (int)(x1 + 0.5);
        int Y1 = this.borderPixels + (int)(y1 + 0.5);
        GrayU8 out = new GrayU8(X1 - X0, Y1 - Y0);
        new FDistort(image, out).scale().apply();
        ((GrayU8)this.gray.subimage(X0, Y0, X1, Y1)).setTo(out);
    }

    public int getBorderPixels() {
        return this.borderPixels;
    }

    public GrayU8 getGray() {
        return this.gray;
    }

    public GrayF32 getGrayF32() {
        GrayF32 out = new GrayF32(this.gray.width, this.gray.height);
        ConvertImage.convert(this.gray, out);
        return out;
    }

    public int getWhite() {
        return this.white;
    }

    public void setWhite(int white) {
        this.white = white;
    }

    public int getBlack() {
        return this.black;
    }

    public void setBlack(int black) {
        this.black = black;
    }
}

