/*
 * Decompiled with CFR 0.152.
 */
package org.mb.listeners;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.mb.listeners.IListenerManager;

public class RefListenerManager<T>
implements IListenerManager<T> {
    private List<T> m_arrListeners;
    private Class m_objClass;
    private T m_objProxy;

    public RefListenerManager(Class objClass) {
        this(objClass, RefListenerManager.class.getClassLoader());
    }

    public RefListenerManager(Class objClass, ClassLoader objLoader) {
        if (!objClass.isInterface()) {
            throw new IllegalArgumentException("The listener type " + this.m_objClass + " must be an interface");
        }
        this.m_objClass = objClass;
        this.m_arrListeners = new ArrayList<T>();
        this.m_objProxy = Proxy.newProxyInstance(objLoader, new Class[]{this.m_objClass}, (InvocationHandler)new ListenerInvocationHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(T objListener) throws IllegalArgumentException {
        if (!this.m_objClass.isInstance(objListener)) {
            throw new IllegalArgumentException("The listener must of type " + this.m_objClass);
        }
        T t = this.m_objProxy;
        synchronized (t) {
            ArrayList<T> arrListeners = new ArrayList<T>(this.m_arrListeners);
            if (arrListeners.contains(objListener)) {
                return;
            }
            arrListeners.add(objListener);
            this.m_arrListeners = arrListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(T objListener) throws IllegalArgumentException {
        if (!this.m_objClass.isInstance(objListener)) {
            throw new IllegalArgumentException("The listener must of type " + this.m_objClass);
        }
        T t = this.m_objProxy;
        synchronized (t) {
            ArrayList<T> arrListeners = new ArrayList<T>(this.m_arrListeners);
            arrListeners.remove(objListener);
            this.m_arrListeners = arrListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isListener(T objListener) {
        T t = this.m_objProxy;
        synchronized (t) {
            return this.m_arrListeners.contains(objListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T[] getListeners() {
        T t = this.m_objProxy;
        synchronized (t) {
            return this.m_arrListeners.toArray();
        }
    }

    @Override
    public T getProxy() {
        return this.m_objProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        T t = this.m_objProxy;
        synchronized (t) {
            this.m_arrListeners = new ArrayList<T>();
        }
    }

    private class ListenerInvocationHandler
    implements InvocationHandler {
        private ListenerInvocationHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws RuntimeException {
            List arrListeners;
            ListenerInvocationHandler listenerInvocationHandler = this;
            synchronized (listenerInvocationHandler) {
                arrListeners = RefListenerManager.this.m_arrListeners;
            }
            Object objResult = null;
            int nSize = arrListeners.size();
            if (nSize > 0) {
                try {
                    for (int i = 0; i < nSize; ++i) {
                        Object objListener = RefListenerManager.this.m_arrListeners.get(i);
                        objResult = method.invoke(objListener, args);
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException("An exception occurred while invoking listeners", e);
                }
            } else if (!method.getReturnType().equals(Void.TYPE)) {
                throw new IllegalStateException("Cannot return a value -- there are no listeners");
            }
            return objResult;
        }
    }
}

